/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.geometry;

import org.jogamp.java3d.utils.geometry.Triangulator;
import org.jogamp.vecmath.Point2f;
import org.jogamp.vecmath.Tuple2f;

class Clean {
    Clean() {
    }

    static void initPUnsorted(Triangulator triRef, int number) {
        if (number > triRef.maxNumPUnsorted) {
            triRef.maxNumPUnsorted = number;
            triRef.pUnsorted = new Point2f[triRef.maxNumPUnsorted];
            int i = 0;
            while (i < triRef.maxNumPUnsorted) {
                triRef.pUnsorted[i] = new Point2f();
                ++i;
            }
        }
    }

    static int cleanPolyhedralFace(Triangulator triRef, int i1, int i2) {
        Clean.initPUnsorted(triRef, triRef.numPoints);
        int i = 0;
        while (i < triRef.numPoints) {
            triRef.pUnsorted[i].set((Tuple2f)triRef.points[i]);
            ++i;
        }
        Clean.sort(triRef.points, triRef.numPoints);
        i = 0;
        int j = 1;
        while (j < triRef.numPoints) {
            if (Clean.pComp(triRef.points[i], triRef.points[j]) != 0) {
                triRef.points[++i] = triRef.points[j];
            }
            ++j;
        }
        int numSorted = i + 1;
        int removed = triRef.numPoints - numSorted;
        i = i1;
        while (i < i2) {
            int ind1 = triRef.loops[i];
            int ind2 = triRef.fetchNextData(ind1);
            int index = triRef.fetchData(ind2);
            while (ind2 != ind1) {
                j = Clean.findPInd(triRef.points, numSorted, triRef.pUnsorted[index]);
                triRef.updateIndex(ind2, j);
                ind2 = triRef.fetchNextData(ind2);
                index = triRef.fetchData(ind2);
            }
            j = Clean.findPInd(triRef.points, numSorted, triRef.pUnsorted[index]);
            triRef.updateIndex(ind2, j);
            ++i;
        }
        triRef.numPoints = numSorted;
        return removed;
    }

    static void sort(Point2f[] points, int numPts) {
        Point2f swap = new Point2f();
        int i = 0;
        while (i < numPts) {
            int j = i + 1;
            while (j < numPts) {
                if (Clean.pComp(points[i], points[j]) > 0) {
                    swap.set((Tuple2f)points[i]);
                    points[i].set((Tuple2f)points[j]);
                    points[j].set((Tuple2f)swap);
                }
                ++j;
            }
            ++i;
        }
    }

    static int findPInd(Point2f[] sorted, int numPts, Point2f pnt) {
        int i = 0;
        while (i < numPts) {
            if (pnt.x == sorted[i].x && pnt.y == sorted[i].y) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    static int pComp(Point2f a, Point2f b) {
        if (a.x < b.x) {
            return -1;
        }
        if (a.x > b.x) {
            return 1;
        }
        if (a.y < b.y) {
            return -1;
        }
        if (a.y > b.y) {
            return 1;
        }
        return 0;
    }
}

