/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.toolbar.group;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.ExpandableToolbarItemStrategy;
import bibliothek.gui.dock.ToolbarGroupDockStation;
import bibliothek.gui.dock.station.StationChildHandle;
import bibliothek.gui.dock.station.toolbar.group.ExpandToolbarGroupActions;
import bibliothek.gui.dock.station.toolbar.group.ToolbarColumn;
import bibliothek.gui.dock.station.toolbar.group.ToolbarColumnListener;
import bibliothek.gui.dock.station.toolbar.group.ToolbarColumnModel;
import bibliothek.gui.dock.station.toolbar.group.ToolbarColumnModelListener;
import bibliothek.gui.dock.station.toolbar.title.ColumnDockActionSource;
import bibliothek.gui.dock.toolbar.expand.ExpandableToolbarItemStrategyListener;
import bibliothek.gui.dock.toolbar.expand.ExpandedState;
import bibliothek.gui.dock.util.PropertyValue;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ComponentListener;
import javax.swing.SwingUtilities;

public class ToolbarGroupExpander {
    private Actions actions;
    private ToolbarGroupDockStation station;
    private DockController controller;
    private ColumnHandler columnHandler = new ColumnHandler();
    private StrategyHandler strategyHandler = new StrategyHandler();
    private PropertyValue<ExpandableToolbarItemStrategy> strategy = new PropertyValue<ExpandableToolbarItemStrategy>(ExpandableToolbarItemStrategy.STRATEGY){

        @Override
        protected void valueChanged(ExpandableToolbarItemStrategy expandableToolbarItemStrategy, ExpandableToolbarItemStrategy expandableToolbarItemStrategy2) {
            if (expandableToolbarItemStrategy != null) {
                expandableToolbarItemStrategy.removeExpandedListener(ToolbarGroupExpander.this.strategyHandler);
            }
            if (expandableToolbarItemStrategy2 != null) {
                expandableToolbarItemStrategy2.addExpandedListener(ToolbarGroupExpander.this.strategyHandler);
                ToolbarGroupExpander.this.columnHandler.validateAll();
            }
        }
    };

    public ToolbarGroupExpander(ToolbarGroupDockStation toolbarGroupDockStation) {
        this.station = toolbarGroupDockStation;
        this.setController(toolbarGroupDockStation.getController());
        toolbarGroupDockStation.getColumnModel().addListener(new ToolbarColumnModelListener<Dockable, StationChildHandle>(){

            @Override
            public void removed(ToolbarColumnModel<Dockable, StationChildHandle> toolbarColumnModel, ToolbarColumn<Dockable, StationChildHandle> toolbarColumn, int n) {
                toolbarColumn.removeListener(ToolbarGroupExpander.this.columnHandler);
            }

            @Override
            public void inserted(ToolbarColumnModel<Dockable, StationChildHandle> toolbarColumnModel, ToolbarColumn<Dockable, StationChildHandle> toolbarColumn, int n) {
                toolbarColumn.addListener(ToolbarGroupExpander.this.columnHandler);
            }
        });
    }

    public void setController(DockController dockController) {
        if (this.controller != dockController) {
            if (this.actions != null) {
                this.actions.setModel(null);
                this.actions.destroy();
                this.actions = null;
            }
            this.controller = dockController;
            this.strategy.setProperties(dockController);
            if (dockController != null) {
                this.actions = new Actions(dockController);
                this.actions.setModel(this.station.getColumnModel());
            }
        }
    }

    public ColumnDockActionSource getActions() {
        return this.actions;
    }

    private ExpandableToolbarItemStrategy getStrategy() {
        return this.strategy.getValue();
    }

    private class Actions
    extends ExpandToolbarGroupActions<StationChildHandle> {
        public Actions(DockController dockController) {
            super(dockController, ToolbarGroupExpander.this.station);
        }

        @Override
        protected void uninstallListener(StationChildHandle stationChildHandle, ComponentListener componentListener) {
            stationChildHandle.getDockable().getComponent().removeComponentListener(componentListener);
        }

        @Override
        protected void installListener(StationChildHandle stationChildHandle, ComponentListener componentListener) {
            stationChildHandle.getDockable().getComponent().addComponentListener(componentListener);
        }

        @Override
        protected Rectangle getBoundaries(StationChildHandle stationChildHandle) {
            Rectangle rectangle = this.getBoundaries(stationChildHandle.getDockable().getComponent());
            Rectangle rectangle2 = null;
            if (stationChildHandle.getTitle() != null) {
                rectangle2 = this.getBoundaries(stationChildHandle.getTitle().getComponent());
                rectangle = rectangle == null ? rectangle2 : rectangle.union(rectangle2);
            }
            return rectangle;
        }

        @Override
        private Rectangle getBoundaries(Component component) {
            Rectangle rectangle = component.getBounds();
            if (SwingUtilities.isDescendingFrom(component, ToolbarGroupExpander.this.station.getComponent())) {
                return SwingUtilities.convertRectangle(component.getParent(), rectangle, ToolbarGroupExpander.this.station.getComponent());
            }
            return null;
        }
    }

    private class ColumnHandler
    implements ToolbarColumnListener<Dockable, StationChildHandle> {
        private ColumnHandler() {
        }

        @Override
        public void inserted(ToolbarColumn<Dockable, StationChildHandle> toolbarColumn, StationChildHandle stationChildHandle, final Dockable dockable, int n) {
            final ExpandableToolbarItemStrategy expandableToolbarItemStrategy = ToolbarGroupExpander.this.getStrategy();
            if (expandableToolbarItemStrategy != null) {
                int n2 = 0;
                int n3 = toolbarColumn.getDockableCount();
                ExpandedState expandedState = null;
                while (n2 < n3 && expandedState == null) {
                    if (n2 != n) {
                        expandedState = expandableToolbarItemStrategy.getState(toolbarColumn.getDockable(n2++));
                        continue;
                    }
                    ++n2;
                }
                if (expandedState != null) {
                    if (ToolbarGroupExpander.this.controller != null) {
                        final ExpandedState expandedState2 = expandedState;
                        ToolbarGroupExpander.this.controller.getHierarchyLock().onRelease(new Runnable(){

                            @Override
                            public void run() {
                                ColumnHandler.this.set(expandableToolbarItemStrategy, dockable, expandedState2);
                                ToolbarGroupExpander.this.actions.update(dockable);
                            }
                        });
                    } else {
                        this.set(expandableToolbarItemStrategy, dockable, expandedState);
                    }
                }
            }
        }

        @Override
        public void removed(ToolbarColumn<Dockable, StationChildHandle> toolbarColumn, StationChildHandle stationChildHandle, Dockable dockable, int n) {
        }

        public void validateAll() {
            ToolbarColumnModel<Dockable, StationChildHandle> toolbarColumnModel = ToolbarGroupExpander.this.station.getColumnModel();
            int n = toolbarColumnModel.getColumnCount();
            for (int i = 0; i < n; ++i) {
                this.validate(toolbarColumnModel.getColumn((Dockable)i));
            }
        }

        public void validate(ToolbarColumn<Dockable, StationChildHandle> toolbarColumn) {
            ExpandableToolbarItemStrategy expandableToolbarItemStrategy = ToolbarGroupExpander.this.getStrategy();
            if (expandableToolbarItemStrategy != null) {
                int n = 0;
                int n2 = toolbarColumn.getDockableCount();
                ExpandedState expandedState = null;
                while (n < n2 && expandedState == null) {
                    expandedState = expandableToolbarItemStrategy.getState(toolbarColumn.getDockable(n++));
                }
                while (n < n2) {
                    Dockable dockable = toolbarColumn.getDockable(n++);
                    this.set(expandableToolbarItemStrategy, dockable, expandedState);
                }
            }
        }

        private void set(ExpandableToolbarItemStrategy expandableToolbarItemStrategy, Dockable dockable, ExpandedState expandedState) {
            if (expandableToolbarItemStrategy.isEnabled(dockable, expandedState)) {
                expandableToolbarItemStrategy.setState(dockable, expandedState);
                return;
            }
            ExpandedState expandedState2 = expandedState;
            while (expandedState2 != expandedState2.smaller()) {
                if (!expandableToolbarItemStrategy.isEnabled(dockable, expandedState2 = expandedState2.smaller())) continue;
                expandableToolbarItemStrategy.setState(dockable, expandedState2);
                return;
            }
            ExpandedState expandedState3 = expandedState;
            while (expandedState3 != expandedState3.larger()) {
                if (!expandableToolbarItemStrategy.isEnabled(dockable, expandedState3 = expandedState3.larger())) continue;
                expandableToolbarItemStrategy.setState(dockable, expandedState3);
                return;
            }
        }
    }

    private class StrategyHandler
    implements ExpandableToolbarItemStrategyListener {
        private StrategyHandler() {
        }

        @Override
        public void enablementChanged(Dockable dockable, ExpandedState expandedState, boolean bl) {
            ToolbarColumn<Dockable, StationChildHandle> toolbarColumn = ToolbarGroupExpander.this.station.getColumnModel().getColumn(dockable);
            if (toolbarColumn != null) {
                ToolbarGroupExpander.this.columnHandler.validate(toolbarColumn);
            }
        }

        @Override
        public void expanded(Dockable dockable) {
        }

        @Override
        public void shrunk(Dockable dockable) {
        }

        @Override
        public void stretched(Dockable dockable) {
        }
    }
}

