/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.toolbar.group;

import bibliothek.gui.dock.layout.AbstractDockableProperty;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.util.Path;
import bibliothek.util.Version;
import bibliothek.util.xml.XElement;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ToolbarGroupProperty
extends AbstractDockableProperty {
    private int column;
    private int line;
    private Path placeholder;

    public ToolbarGroupProperty() {
    }

    public ToolbarGroupProperty(int n, int n2, Path path) {
        this.column = n;
        this.line = n2;
        this.placeholder = path;
    }

    public int getColumn() {
        return this.column;
    }

    public int getLine() {
        return this.line;
    }

    public Path getPlaceholder() {
        return this.placeholder;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[column=" + this.getColumn() + ", line=" + this.getLine() + ", placeholder=" + this.getPlaceholder() + ", successor=" + this.getSuccessor() + "]";
    }

    @Override
    public DockableProperty copy() {
        ToolbarGroupProperty toolbarGroupProperty = new ToolbarGroupProperty(this.column, this.line, this.placeholder);
        this.copy(toolbarGroupProperty);
        return toolbarGroupProperty;
    }

    @Override
    public String getFactoryID() {
        return "ToolbarGroupProperty";
    }

    @Override
    public void store(DataOutputStream dataOutputStream) throws IOException {
        Version.write(dataOutputStream, Version.VERSION_1_1_1a);
        dataOutputStream.writeInt(this.column);
        dataOutputStream.writeInt(this.line);
        if (this.placeholder == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            dataOutputStream.writeUTF(this.placeholder.toString());
        }
    }

    @Override
    public void store(XElement xElement) {
        xElement.addElement("column").setInt(this.column);
        xElement.addElement("line").setInt(this.line);
        if (this.placeholder != null) {
            xElement.addElement("placeholder").setString(this.placeholder.toString());
        }
    }

    @Override
    public void load(DataInputStream dataInputStream) throws IOException {
        Version version = Version.read(dataInputStream);
        if (!version.equals(Version.VERSION_1_1_1a)) {
            throw new IOException("data from an unknown version: " + version);
        }
        this.column = dataInputStream.readInt();
        this.line = dataInputStream.readInt();
        this.placeholder = dataInputStream.readBoolean() ? new Path(dataInputStream.readUTF()) : null;
    }

    @Override
    public void load(XElement xElement) {
        XElement xElement2 = xElement.getElement("column");
        XElement xElement3 = xElement.getElement("xline");
        XElement xElement4 = xElement.getElement("placeholder");
        if (xElement2 != null) {
            this.column = xElement2.getInt();
        }
        if (xElement3 != null) {
            this.line = xElement3.getInt();
        }
        this.placeholder = xElement4 != null ? new Path(xElement4.getString()) : null;
    }
}

