/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.toolbar.title;

import bibliothek.gui.Dockable;
import bibliothek.gui.Orientation;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.action.LineDockActionSource;
import bibliothek.gui.dock.station.toolbar.title.ColumnDockActionSource;
import bibliothek.gui.dock.station.toolbar.title.ColumnDockActionSourceListener;
import bibliothek.gui.dock.themes.basic.action.BasicTitleViewItem;
import bibliothek.gui.dock.themes.basic.action.buttons.ButtonPanel;
import bibliothek.gui.dock.title.AbstractMultiDockTitle;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.title.DockTitleVersion;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public abstract class ColumnDockTitle
extends AbstractMultiDockTitle {
    private List<ButtonPanel> itemPanels = new ArrayList<ButtonPanel>();
    private ButtonPanel directPanel;
    private ColumnDockActionSource source;
    private ColumnDockActionSourceListener listener = new ColumnDockActionSourceListener(){

        @Override
        public void reshaped(ColumnDockActionSource columnDockActionSource) {
            ColumnDockTitle.this.revalidate();
        }

        @Override
        public void removed(ColumnDockActionSource columnDockActionSource, DockActionSource dockActionSource, int n) {
            if (ColumnDockTitle.this.isBound()) {
                ButtonPanel buttonPanel = (ButtonPanel)ColumnDockTitle.this.itemPanels.remove(n);
                buttonPanel.set(null);
                buttonPanel.setController(null);
                ColumnDockTitle.this.remove(buttonPanel);
                ColumnDockTitle.this.revalidate();
            }
        }

        @Override
        public void inserted(ColumnDockActionSource columnDockActionSource, DockActionSource dockActionSource, int n) {
            if (ColumnDockTitle.this.isBound()) {
                ColumnDockTitle.this.createPanel(dockActionSource, n);
            }
        }
    };

    public ColumnDockTitle(Dockable dockable, DockTitleVersion dockTitleVersion) {
        this.init(dockable, dockTitleVersion);
        this.directPanel = new ButtonPanel(true){

            @Override
            protected BasicTitleViewItem<JComponent> createItemFor(DockAction dockAction, Dockable dockable) {
                return ColumnDockTitle.this.createItemFor(dockAction, dockable);
            }
        };
        this.add(this.directPanel);
    }

    private void createPanel(DockActionSource dockActionSource, int n) {
        ButtonPanel buttonPanel = new ButtonPanel(true){

            @Override
            protected BasicTitleViewItem<JComponent> createItemFor(DockAction dockAction, Dockable dockable) {
                return ColumnDockTitle.this.createItemFor(dockAction, dockable);
            }
        };
        buttonPanel.set(this.getDockable(), dockActionSource);
        buttonPanel.setController(this.getDockable().getController());
        buttonPanel.setOrientation(this.getOrientation());
        buttonPanel.setToolTipText(this.getToolTipText());
        this.itemPanels.add(n, buttonPanel);
        this.add(buttonPanel);
        this.revalidate();
    }

    @Override
    public void setOrientation(DockTitle.Orientation orientation) {
        if (this.getOrientation() != orientation) {
            super.setOrientation(orientation);
            for (ButtonPanel buttonPanel : this.itemPanels) {
                buttonPanel.setOrientation(orientation);
            }
            this.directPanel.setOrientation(orientation);
            this.revalidate();
        }
    }

    protected abstract ColumnDockActionSource getSourceFor(Dockable var1);

    protected DockActionSource getActionSourceFor(Dockable dockable) {
        return new LineDockActionSource(dockable.getGlobalActionOffers());
    }

    @Override
    public void bind() {
        if (!this.isBound()) {
            Dockable dockable = this.getDockable();
            this.source = this.getSourceFor(dockable);
            if (this.source != null) {
                int n = this.source.getSourceCount();
                for (int i = 0; i < n; ++i) {
                    this.createPanel(this.source.getSource(i), i);
                }
                this.source.addListener(this.listener);
            }
            this.directPanel.set(dockable, this.getActionSourceFor(dockable));
        }
        super.bind();
    }

    @Override
    public void unbind() {
        super.unbind();
        if (!this.isBound() && this.source != null) {
            this.source.removeListener(this.listener);
            for (ButtonPanel buttonPanel : this.itemPanels) {
                buttonPanel.set(null);
                buttonPanel.setController(null);
                this.remove(buttonPanel);
            }
            this.directPanel.set(null);
            this.itemPanels.clear();
            this.revalidate();
            this.source = null;
        }
    }

    @Override
    protected void updateIcon() {
    }

    @Override
    protected void updateText() {
    }

    private int getOffset(int n) {
        int n2 = this.source.getSourceOffset(n);
        Component component = this.getDockable().getComponent();
        Point point = new Point(n2, n2);
        if (SwingUtilities.getRoot(this) == SwingUtilities.getRoot(component)) {
            point = SwingUtilities.convertPoint(component, point, this);
        }
        if (this.source.getOrientation() == Orientation.VERTICAL) {
            return point.x;
        }
        return point.y;
    }

    @Override
    protected void doTitleLayout() {
        if (this.source == null) {
            return;
        }
        Insets insets = this.titleInsets();
        int n = insets.left;
        int n2 = insets.top;
        int n3 = this.getWidth() - insets.left - insets.right;
        int n4 = this.getHeight() - insets.top - insets.bottom;
        boolean bl = this.getOrientation().isHorizontal();
        int n5 = this.source.getSourceCount();
        for (int i = 0; i < n5; ++i) {
            int n6;
            int n7;
            int n8;
            int n9;
            int n10 = this.getOffset(i);
            int n11 = this.source.getSourceLength(i);
            ButtonPanel buttonPanel = this.itemPanels.get(i);
            Dimension[] dimensionArray = buttonPanel.getPreferredSizes();
            Dimension[] dimensionArray2 = null;
            if (i + 1 == n5) {
                dimensionArray2 = this.directPanel.getPreferredSizes();
                n11 = bl ? (n11 -= dimensionArray2[0].width) : (n11 -= dimensionArray2[0].height);
            }
            if (bl) {
                n9 = 0;
                n8 = 0;
                for (n7 = dimensionArray.length - 1; n7 >= 0; --n7) {
                    if (dimensionArray[n7].width > n11) continue;
                    n9 = n7;
                    n8 = n11 - dimensionArray[n7].width;
                    break;
                }
                buttonPanel.setVisibleActions(n9);
                buttonPanel.setBounds(n10, n2, n11 - n8, n4);
                if (i + 1 != n5) continue;
                n7 = n3 - n10 - n11 + n8;
                n9 = 0;
                n8 = 0;
                for (n6 = dimensionArray2.length - 1; n6 >= 0; --n6) {
                    if (dimensionArray2[n6].width > n7) continue;
                    n9 = n6;
                    n8 = n7 - dimensionArray2[n6].width;
                    break;
                }
                this.directPanel.setVisibleActions(n9);
                this.directPanel.setBounds(n + n3 - n7 + n8, n2, n7 - n8, n4);
                continue;
            }
            n9 = 0;
            n8 = 0;
            for (n7 = dimensionArray.length - 1; n7 >= 0; --n7) {
                if (dimensionArray[n7].height > n11) continue;
                n9 = n7;
                n8 = n11 - dimensionArray[n7].height;
                break;
            }
            buttonPanel.setVisibleActions(n9);
            buttonPanel.setBounds(n, n10, n3, n11 - n8);
            if (i + 1 != n5) continue;
            n7 = n4 - n10 - n11 + n8;
            n9 = 0;
            n8 = 0;
            for (n6 = dimensionArray2.length - 1; n6 >= 0; --n6) {
                if (dimensionArray2[n6].height > n7) continue;
                n9 = n6;
                n8 = n7 - dimensionArray2[n6].height;
                break;
            }
            this.directPanel.setVisibleActions(n9);
            this.directPanel.setBounds(n, n2 + n4 - n7 + n8, n3, n7 - n8);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        int n = 0;
        int n2 = 0;
        if (this.source != null) {
            int n3;
            if (this.getOrientation().isHorizontal()) {
                int n4 = this.source.getSourceCount();
                for (n3 = 0; n3 < n4; ++n3) {
                    n = Math.max(n, this.getOffset(n3) + this.source.getSourceLength(n3));
                    n2 = Math.max(n2, this.itemPanels.get((int)n3).getPreferredSize().height);
                }
            } else {
                int n5 = this.source.getSourceCount();
                for (n3 = 0; n3 < n5; ++n3) {
                    n = Math.max(n, this.itemPanels.get((int)n3).getPreferredSize().width);
                    n2 = Math.max(n2, this.getOffset(n3) + this.source.getSourceLength(n3));
                }
            }
        }
        n = Math.max(n, 5);
        n2 = Math.max(n2, 5);
        Insets insets = this.titleInsets();
        return new Dimension(n += insets.left + insets.right, n2 += insets.top + insets.bottom);
    }
}

