/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.wizard;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.SplitDockStation;
import bibliothek.gui.dock.station.split.Leaf;
import bibliothek.gui.dock.station.split.Node;
import bibliothek.gui.dock.station.split.Placeholder;
import bibliothek.gui.dock.station.split.Root;
import bibliothek.gui.dock.station.split.SplitNode;
import bibliothek.gui.dock.station.split.SplitNodeVisitor;
import bibliothek.gui.dock.wizard.PersistentCell;
import bibliothek.gui.dock.wizard.PersistentColumn;
import bibliothek.gui.dock.wizard.WizardSplitDockStation;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public abstract class WizardNodeMap {
    private Map<SplitNode, Column> columns;
    private WizardSplitDockStation station;
    private PersistentColumn[] persistentColumns;

    public WizardNodeMap(WizardSplitDockStation wizardSplitDockStation, PersistentColumn[] persistentColumnArray) {
        this.station = wizardSplitDockStation;
        this.persistentColumns = persistentColumnArray;
    }

    private void buildColumns() {
        this.columns = new HashMap<SplitNode, Column>();
        this.station.getRoot().visit(new SplitNodeVisitor(){

            @Override
            public void handleRoot(Root root) {
            }

            @Override
            public void handleNode(Node node) {
                if (WizardNodeMap.this.isColumnRoot(node)) {
                    WizardNodeMap.this.columns.put(node, new Column(node));
                }
            }

            @Override
            public void handleLeaf(Leaf leaf) {
                if (WizardNodeMap.this.isColumnRoot(leaf)) {
                    WizardNodeMap.this.columns.put(leaf, new Column(leaf));
                }
            }

            @Override
            public void handlePlaceholder(Placeholder placeholder) {
            }
        });
        Column[] columnArray = this.columns.values().toArray(new Column[this.columns.size()]);
        Arrays.sort(columnArray, new Comparator<Column>(){

            @Override
            public int compare(Column column, Column column2) {
                int n;
                int n2 = this.score(column);
                if (n2 < (n = this.score(column2))) {
                    return -1;
                }
                if (n2 > n) {
                    return 1;
                }
                return 0;
            }

            private int score(Column column) {
                int n = 0;
                SplitNode splitNode = column.root;
                while (splitNode != null) {
                    SplitNode splitNode2 = splitNode.getParent();
                    if (splitNode2 != null && splitNode2.getChildLocation(splitNode) > 0) {
                        ++n;
                    }
                    splitNode = splitNode2;
                }
                return n;
            }
        });
        for (int i = 0; i < columnArray.length; ++i) {
            columnArray[i].index = i;
        }
    }

    public Map<SplitNode, Column> getColumns() {
        if (this.columns == null) {
            this.buildColumns();
        }
        return this.columns;
    }

    public int getColumnCount() {
        return this.getColumns().size();
    }

    public Column getColumn(int n) {
        for (Column column : this.getColumns().values()) {
            if (column.index != n) continue;
            return column;
        }
        throw new IndexOutOfBoundsException("index: " + n);
    }

    public Column[] getSortedColumns() {
        Collection<Column> collection = this.getColumns().values();
        Column[] columnArray = collection.toArray(new Column[collection.size()]);
        Arrays.sort(columnArray, new Comparator<Column>(){

            @Override
            public int compare(Column column, Column column2) {
                return column.getIndex() - column2.getIndex();
            }
        });
        return columnArray;
    }

    public boolean isColumnRoot(SplitNode splitNode) {
        if (splitNode instanceof Root) {
            return false;
        }
        if (splitNode instanceof Node) {
            Node node = (Node)splitNode;
            if (node.getOrientation() == this.side().getHeaderOrientation()) {
                return false;
            }
            if (node.getLeft() == null || !node.getLeft().isVisible()) {
                return false;
            }
            if (node.getRight() == null || !node.getRight().isVisible()) {
                return false;
            }
            return this.isHeaderLevel(splitNode);
        }
        if (splitNode instanceof Leaf) {
            return this.isHeaderLevel(splitNode, false);
        }
        return false;
    }

    public boolean isHeaderLevel(SplitNode splitNode) {
        return this.isHeaderLevel(splitNode, true);
    }

    public boolean isHeaderLevel(SplitNode splitNode, boolean bl) {
        if (splitNode instanceof Root) {
            return true;
        }
        if (splitNode instanceof Node) {
            Node node = (Node)splitNode;
            if (node.getLeft() == null || node.getRight() == null) {
                return false;
            }
            if (!node.getLeft().isVisible() || !node.getRight().isVisible()) {
                return this.isHeaderLevel(splitNode.getParent(), bl);
            }
            if (node.getOrientation() == this.side().getHeaderOrientation()) {
                return true;
            }
            if (bl) {
                return this.isHeaderLevel(splitNode.getParent(), false);
            }
            return false;
        }
        if (splitNode.getParent() instanceof Root) {
            return true;
        }
        if (splitNode instanceof Leaf) {
            return this.isHeaderLevel(splitNode.getParent(), false);
        }
        return false;
    }

    private WizardSplitDockStation.Side side() {
        return this.station.getSide();
    }

    public Column getOutermostColumn() {
        return this.getHeadColumn(this.station.getRoot());
    }

    public Column getHeadColumn(SplitNode splitNode) {
        while (splitNode != null) {
            Column column = this.getColumns().get(splitNode);
            if (column != null) {
                return column;
            }
            if (splitNode instanceof Node) {
                if (((Node)splitNode).getLeft() == null || !((Node)splitNode).getLeft().isVisible()) {
                    splitNode = ((Node)splitNode).getRight();
                    continue;
                }
                if (((Node)splitNode).getRight() == null || !((Node)splitNode).getRight().isVisible()) {
                    splitNode = ((Node)splitNode).getLeft();
                    continue;
                }
                if (this.side() == WizardSplitDockStation.Side.RIGHT || this.side() == WizardSplitDockStation.Side.BOTTOM) {
                    splitNode = ((Node)splitNode).getLeft();
                    continue;
                }
                splitNode = ((Node)splitNode).getRight();
                continue;
            }
            if (splitNode instanceof Root) {
                splitNode = ((Root)splitNode).getChild();
                continue;
            }
            splitNode = null;
        }
        return null;
    }

    public PersistentCell getHeadCell(SplitNode splitNode) {
        while (splitNode != null) {
            if (splitNode instanceof Leaf) {
                Dockable dockable = ((Leaf)splitNode).getDockable();
                for (Column column : this.getColumns().values()) {
                    PersistentCell persistentCell;
                    if (column.cells.get(splitNode) == null || (persistentCell = column.getPersistentColumn().getCells().get(dockable)) == null) continue;
                    return persistentCell;
                }
                splitNode = null;
            }
            if (splitNode instanceof Node) {
                splitNode = ((Node)splitNode).getRight();
                continue;
            }
            splitNode = null;
        }
        return null;
    }

    public Column getColumn(SplitNode splitNode) {
        Column column = this.getColumn(splitNode, true);
        if (column != null) {
            return column;
        }
        if (splitNode instanceof Root) {
            splitNode = ((Root)splitNode).getChild();
        }
        if (splitNode instanceof Node) {
            SplitNode splitNode2 = ((Node)splitNode).getRight();
            while (splitNode2 != null) {
                Column column2 = this.getColumns().get(splitNode2);
                if (column2 != null) {
                    return column2;
                }
                if (splitNode2 instanceof Node) {
                    splitNode2 = ((Node)splitNode2).getLeft();
                    continue;
                }
                splitNode2 = null;
            }
        }
        return null;
    }

    public Column getColumn(SplitNode splitNode, boolean bl) {
        if (bl) {
            Column column = null;
            while (splitNode != null && column == null) {
                column = this.getColumns().get(splitNode);
                splitNode = splitNode.getParent();
            }
            return column;
        }
        return this.getColumns().get(splitNode);
    }

    public Column getColumn(Dockable dockable) {
        for (Column column : this.getColumns().values()) {
            if (!column.getLeafs().containsKey(dockable)) continue;
            return column;
        }
        return null;
    }

    public Leaf[] getLastLeafOfColumns() {
        ArrayList<Leaf> arrayList = new ArrayList<Leaf>();
        for (Column column : this.getColumns().values()) {
            Leaf leaf = column.getLastLeafOfColumn();
            if (leaf == null) continue;
            arrayList.add(leaf);
        }
        return arrayList.toArray(new Leaf[arrayList.size()]);
    }

    public PersistentColumn getPersistentColumn(int n) {
        for (PersistentColumn persistentColumn : this.getPersistentColumns()) {
            if (persistentColumn.getSource().index != n) continue;
            return persistentColumn;
        }
        return null;
    }

    public PersistentColumn[] getPersistentColumns() {
        ArrayList<PersistentColumn> arrayList = new ArrayList<PersistentColumn>(this.getColumns().size());
        for (Column column : this.getColumns().values()) {
            PersistentColumn persistentColumn = column.toPersistentColumn();
            if (persistentColumn == null) continue;
            arrayList.add(persistentColumn);
        }
        this.persistentColumns = this.persistentColumns == null ? arrayList.toArray(new PersistentColumn[arrayList.size()]) : this.adapt(this.persistentColumns, arrayList.toArray(new PersistentColumn[arrayList.size()]));
        this.handlePersistentColumnsAdapted(this.persistentColumns);
        return this.persistentColumns;
    }

    protected abstract void handlePersistentColumnsAdapted(PersistentColumn[] var1);

    private PersistentColumn[] adapt(PersistentColumn[] persistentColumnArray, PersistentColumn[] persistentColumnArray2) {
        for (PersistentColumn persistentColumn : persistentColumnArray2) {
            HashSet<PersistentColumn> hashSet = new HashSet<PersistentColumn>();
            block1: for (Map.Entry<Dockable, PersistentCell> entry : persistentColumn.getCells().entrySet()) {
                for (PersistentColumn persistentColumn2 : persistentColumnArray) {
                    PersistentCell persistentCell = persistentColumn2.getCells().get(entry.getKey());
                    if (persistentCell == null) continue;
                    hashSet.add(persistentColumn2);
                    entry.getValue().setSize(persistentCell.getSize());
                    continue block1;
                }
            }
            if (hashSet.size() == 1) {
                PersistentColumn persistentColumn3 = (PersistentColumn)hashSet.iterator().next();
                if (persistentColumn3.getCells().keySet().containsAll(persistentColumn.getCells().keySet())) {
                    persistentColumn.setSize(persistentColumn3.getSize());
                    continue;
                }
                persistentColumn.setSize(Math.max(persistentColumn3.getSize(), persistentColumn.getPreferredSize()));
                continue;
            }
            if (hashSet.size() <= 0) continue;
            int n = 0;
            for (Object object : hashSet) {
                n = Math.max(n, ((PersistentColumn)object).getSize());
            }
            persistentColumn.setSize(n);
        }
        return persistentColumnArray2;
    }

    public class Cell {
        private SplitNode node;
        private Column column;
        private Dimension preferredSize;
        private Dimension minimumSize;
        private int index;

        private Cell(SplitNode splitNode, Column column) {
            this.node = splitNode;
            this.column = column;
        }

        public SplitNode getNode() {
            return this.node;
        }

        public int getIndex() {
            return this.index;
        }

        public Dimension getPreferredSize() {
            if (this.preferredSize == null) {
                Object object;
                if (this.node instanceof Leaf && (object = ((Leaf)this.node).getDisplayer()) != null) {
                    this.preferredSize = object.getComponent().getPreferredSize();
                }
                if (this.node instanceof Node) {
                    object = this.column.getPreferredSize(((Node)this.node).getLeft());
                    Dimension dimension = this.column.getPreferredSize(((Node)this.node).getRight());
                    if (object == null) {
                        this.preferredSize = dimension;
                    } else if (dimension == null) {
                        this.preferredSize = object;
                    } else if (object != null && dimension != null) {
                        this.preferredSize = ((Node)this.node).getOrientation() == SplitDockStation.Orientation.HORIZONTAL ? new Dimension(((Dimension)object).width + dimension.width, Math.max(((Dimension)object).height, dimension.height)) : new Dimension(Math.max(((Dimension)object).width, dimension.width), ((Dimension)object).height + dimension.height);
                    }
                }
                if (this.node instanceof Root) {
                    this.preferredSize = this.column.getPreferredSize(((Root)this.node).getChild());
                }
            }
            return this.preferredSize;
        }

        public Dimension getMinimumSize() {
            if (this.minimumSize == null) {
                Object object;
                if (this.node instanceof Leaf && (object = ((Leaf)this.node).getDisplayer()) != null) {
                    this.minimumSize = object.getComponent().getMinimumSize();
                }
                if (this.node instanceof Node) {
                    object = this.column.getMinimumSize(((Node)this.node).getLeft());
                    Dimension dimension = this.column.getMinimumSize(((Node)this.node).getRight());
                    if (object == null) {
                        this.minimumSize = dimension;
                    } else if (dimension == null) {
                        this.minimumSize = object;
                    } else if (object != null && dimension != null) {
                        this.minimumSize = ((Node)this.node).getOrientation() == SplitDockStation.Orientation.HORIZONTAL ? new Dimension(((Dimension)object).width + dimension.width, Math.max(((Dimension)object).height, dimension.height)) : new Dimension(Math.max(((Dimension)object).width, dimension.width), ((Dimension)object).height + dimension.height);
                    }
                }
                if (this.node instanceof Root) {
                    this.minimumSize = this.column.getMinimumSize(((Root)this.node).getChild());
                }
            }
            return this.minimumSize;
        }

        public int getGaps() {
            if (this.node instanceof Leaf) {
                return 0;
            }
            if (this.node instanceof Node) {
                int n = this.column.getGaps(((Node)this.node).getLeft());
                int n2 = this.column.getGaps(((Node)this.node).getRight());
                if (n == -1) {
                    return n2;
                }
                if (n2 == -1) {
                    return n;
                }
                if (n == -1 && n2 == -1) {
                    return -1;
                }
                return n + 1 + n2;
            }
            if (this.node instanceof Root) {
                return this.column.getGaps(((Root)this.node).getChild());
            }
            return -1;
        }
    }

    public class Column {
        private SplitNode root;
        private Map<SplitNode, Cell> cells = new HashMap<SplitNode, Cell>();
        private List<Cell> leafCells = new ArrayList<Cell>();
        private int index;

        private Column(SplitNode splitNode) {
            this.root = splitNode;
            splitNode.visit(new SplitNodeVisitor(){

                @Override
                public void handleRoot(Root root) {
                    Column.this.cells.put(root, new Cell(root, Column.this));
                }

                @Override
                public void handlePlaceholder(Placeholder placeholder) {
                    Column.this.cells.put(placeholder, new Cell(placeholder, Column.this));
                }

                @Override
                public void handleNode(Node node) {
                    Column.this.cells.put(node, new Cell(node, Column.this));
                }

                @Override
                public void handleLeaf(Leaf leaf) {
                    Cell cell = new Cell(leaf, Column.this);
                    Column.this.cells.put(leaf, cell);
                    Column.this.leafCells.add(cell);
                }
            });
            Cell[] cellArray = this.leafCells.toArray(new Cell[this.leafCells.size()]);
            Arrays.sort(cellArray, new Comparator<Cell>(){

                @Override
                public int compare(Cell cell, Cell cell2) {
                    int n;
                    int n2 = this.score(cell);
                    if (n2 < (n = this.score(cell2))) {
                        return -1;
                    }
                    if (n2 > n) {
                        return 1;
                    }
                    return 0;
                }

                private int score(Cell cell) {
                    int n = 0;
                    for (SplitNode splitNode = cell.getNode(); splitNode != Column.this.root; splitNode = splitNode.getParent()) {
                        if (splitNode.getParent().getChildLocation(splitNode) <= 0) continue;
                        ++n;
                    }
                    return n;
                }
            });
            for (int i = 0; i < cellArray.length; ++i) {
                cellArray[i].index = i;
            }
        }

        public SplitNode getRoot() {
            return this.root;
        }

        public Cell[] getSortedCells() {
            Cell[] cellArray = this.cells.values().toArray(new Cell[this.cells.size()]);
            Arrays.sort(cellArray, new Comparator<Cell>(){

                @Override
                public int compare(Cell cell, Cell cell2) {
                    return cell.getIndex() - cell2.getIndex();
                }
            });
            return cellArray;
        }

        public PersistentColumn toPersistentColumn() {
            int n;
            int n2;
            Map<Dockable, PersistentCell> map = this.getLeafs();
            if (map.size() == 0) {
                return null;
            }
            if (WizardNodeMap.this.side().getHeaderOrientation() == SplitDockStation.Orientation.HORIZONTAL) {
                n2 = this.root.getSize().width;
                n = this.getPreferredSize().width;
            } else {
                n2 = this.root.getSize().height;
                n = this.getPreferredSize().height;
            }
            return new PersistentColumn(n2, n, this, map);
        }

        public int getIndex() {
            return this.index;
        }

        public PersistentColumn getPersistentColumn() {
            Map<Dockable, PersistentCell> map = this.getLeafs();
            for (PersistentColumn persistentColumn : WizardNodeMap.this.getPersistentColumns()) {
                if (!persistentColumn.getCells().keySet().equals(map.keySet())) continue;
                return persistentColumn;
            }
            return null;
        }

        private Map<Dockable, PersistentCell> getLeafs() {
            final HashMap<Dockable, PersistentCell> hashMap = new HashMap<Dockable, PersistentCell>();
            this.root.visit(new SplitNodeVisitor(){

                @Override
                public void handleRoot(Root root) {
                }

                @Override
                public void handlePlaceholder(Placeholder placeholder) {
                }

                @Override
                public void handleNode(Node node) {
                }

                @Override
                public void handleLeaf(Leaf leaf) {
                    Dimension dimension = Column.this.getPreferredSize(leaf);
                    if (dimension != null) {
                        int n;
                        int n2;
                        if (WizardNodeMap.this.side().getHeaderOrientation() == SplitDockStation.Orientation.HORIZONTAL) {
                            n2 = leaf.getSize().height;
                            n = dimension.height;
                        } else {
                            n2 = leaf.getSize().width;
                            n = dimension.width;
                        }
                        hashMap.put(leaf.getDockable(), new PersistentCell(n2, n));
                    }
                }
            });
            return hashMap;
        }

        public Cell getRightmostCell(SplitNode splitNode) {
            while (splitNode != null) {
                if (splitNode instanceof Node) {
                    splitNode = ((Node)splitNode).getRight();
                    continue;
                }
                return this.cells.get(splitNode);
            }
            return null;
        }

        public Cell getLeftmostCell(SplitNode splitNode) {
            while (splitNode != null) {
                if (splitNode instanceof Node) {
                    splitNode = ((Node)splitNode).getLeft();
                    continue;
                }
                return this.cells.get(splitNode);
            }
            return null;
        }

        public Leaf getLastLeafOfColumn() {
            SplitNode splitNode = this.root;
            while (splitNode != null) {
                if (splitNode instanceof Root) {
                    splitNode = ((Root)splitNode).getChild();
                    continue;
                }
                if (splitNode instanceof Node) {
                    splitNode = ((Node)splitNode).getRight();
                    continue;
                }
                if (splitNode instanceof Leaf) {
                    return (Leaf)splitNode;
                }
                splitNode = null;
            }
            return null;
        }

        public Dimension getPreferredSize(SplitNode splitNode) {
            Cell cell = this.cells.get(splitNode);
            if (cell == null) {
                return null;
            }
            return cell.getPreferredSize();
        }

        public Dimension getMinimumSize(SplitNode splitNode) {
            Cell cell = this.cells.get(splitNode);
            if (cell == null) {
                return null;
            }
            return cell.getMinimumSize();
        }

        public Dimension getPreferredSize() {
            return this.getPreferredSize(this.root);
        }

        public Dimension getMinimumSize() {
            return this.getMinimumSize(this.root);
        }

        public Rectangle getBounds() {
            return this.root.getBounds();
        }

        public int getCellCount() {
            return this.leafCells.size();
        }

        public int getGaps(SplitNode splitNode) {
            Cell cell = this.cells.get(splitNode);
            if (cell == null) {
                return 0;
            }
            return cell.getGaps();
        }

        public int getGaps() {
            return this.getGaps(this.root);
        }
    }
}

