/*
 * Decompiled with CFR 0.152.
 */
package cadex.Collections;

import cadex.CadExMTKJNI;
import java.util.AbstractList;
import java.util.RandomAccess;

public class DoubleList
extends AbstractList<Double>
implements RandomAccess {
    private transient long swigCPtr;
    public transient boolean swigCMemOwn;

    public DoubleList(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    public static long getCPtr(DoubleList obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    public static long swigRelease(DoubleList obj) {
        long ptr = 0L;
        if (obj != null) {
            if (!obj.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            ptr = obj.swigCPtr;
            obj.swigCMemOwn = false;
            obj.delete();
        }
        return ptr;
    }

    public void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                CadExMTKJNI.delete_std_DoubleList(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public DoubleList(double[] initialElements) {
        this();
        this.reserve(initialElements.length);
        for (double element : initialElements) {
            this.add(element);
        }
    }

    public DoubleList(Iterable<Double> initialElements) {
        this();
        for (double element : initialElements) {
            this.add(element);
        }
    }

    @Override
    public Double get(int index) {
        return this.doGet(index);
    }

    @Override
    public Double set(int index, Double e) {
        return this.doSet(index, e);
    }

    @Override
    public boolean add(Double e) {
        ++this.modCount;
        this.doAdd(e);
        return true;
    }

    @Override
    public void add(int index, Double e) {
        ++this.modCount;
        this.doAdd(index, e);
    }

    @Override
    public Double remove(int index) {
        ++this.modCount;
        return this.doRemove(index);
    }

    @Override
    public void removeRange(int fromIndex, int toIndex) {
        ++this.modCount;
        this.doRemoveRange(fromIndex, toIndex);
    }

    @Override
    public int size() {
        return this.doSize();
    }

    public int capacity() {
        return this.doCapacity();
    }

    public void reserve(int n) {
        this.doReserve(n);
    }

    public DoubleList() {
        this(CadExMTKJNI.new_std_DoubleList__SWIG_0(), true);
    }

    public DoubleList(DoubleList other) {
        this(CadExMTKJNI.new_std_DoubleList__SWIG_1(DoubleList.getCPtr(other), other), true);
    }

    @Override
    public boolean isEmpty() {
        return CadExMTKJNI.std_DoubleList_isEmpty(this.swigCPtr, this);
    }

    @Override
    public void clear() {
        CadExMTKJNI.std_DoubleList_clear(this.swigCPtr, this);
    }

    public DoubleList(int count, double value) {
        this(CadExMTKJNI.new_std_DoubleList__SWIG_2(count, value), true);
    }

    private int doCapacity() {
        return CadExMTKJNI.std_DoubleList_doCapacity(this.swigCPtr, this);
    }

    private void doReserve(int n) {
        CadExMTKJNI.std_DoubleList_doReserve(this.swigCPtr, this, n);
    }

    private int doSize() {
        return CadExMTKJNI.std_DoubleList_doSize(this.swigCPtr, this);
    }

    private void doAdd(double x) {
        CadExMTKJNI.std_DoubleList_doAdd__SWIG_0(this.swigCPtr, this, x);
    }

    private void doAdd(int index, double x) {
        CadExMTKJNI.std_DoubleList_doAdd__SWIG_1(this.swigCPtr, this, index, x);
    }

    private double doRemove(int index) {
        return CadExMTKJNI.std_DoubleList_doRemove(this.swigCPtr, this, index);
    }

    private double doGet(int index) {
        return CadExMTKJNI.std_DoubleList_doGet(this.swigCPtr, this, index);
    }

    private double doSet(int index, double val) {
        return CadExMTKJNI.std_DoubleList_doSet(this.swigCPtr, this, index, val);
    }

    private void doRemoveRange(int fromIndex, int toIndex) {
        CadExMTKJNI.std_DoubleList_doRemoveRange(this.swigCPtr, this, fromIndex, toIndex);
    }
}

