/*
 * Decompiled with CFR 0.152.
 */
package cadex.Collections;

import cadex.CadExMTKJNI;
import cadex.ModelData.Shell;
import java.util.AbstractList;
import java.util.RandomAccess;

public class ShellList
extends AbstractList<Shell>
implements RandomAccess {
    private transient long swigCPtr;
    public transient boolean swigCMemOwn;

    public ShellList(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    public static long getCPtr(ShellList obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    public static long swigRelease(ShellList obj) {
        long ptr = 0L;
        if (obj != null) {
            if (!obj.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            ptr = obj.swigCPtr;
            obj.swigCMemOwn = false;
            obj.delete();
        }
        return ptr;
    }

    public void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                CadExMTKJNI.delete_std_ShellList(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public ShellList(Shell[] initialElements) {
        this();
        this.reserve(initialElements.length);
        for (Shell element : initialElements) {
            this.add(element);
        }
    }

    public ShellList(Iterable<Shell> initialElements) {
        this();
        for (Shell element : initialElements) {
            this.add(element);
        }
    }

    @Override
    public Shell get(int index) {
        return this.doGet(index);
    }

    @Override
    public Shell set(int index, Shell e) {
        return this.doSet(index, e);
    }

    @Override
    public boolean add(Shell e) {
        ++this.modCount;
        this.doAdd(e);
        return true;
    }

    @Override
    public void add(int index, Shell e) {
        ++this.modCount;
        this.doAdd(index, e);
    }

    @Override
    public Shell remove(int index) {
        ++this.modCount;
        return this.doRemove(index);
    }

    @Override
    public void removeRange(int fromIndex, int toIndex) {
        ++this.modCount;
        this.doRemoveRange(fromIndex, toIndex);
    }

    @Override
    public int size() {
        return this.doSize();
    }

    public int capacity() {
        return this.doCapacity();
    }

    public void reserve(int n) {
        this.doReserve(n);
    }

    public ShellList() {
        this(CadExMTKJNI.new_std_ShellList__SWIG_0(), true);
    }

    public ShellList(ShellList other) {
        this(CadExMTKJNI.new_std_ShellList__SWIG_1(ShellList.getCPtr(other), other), true);
    }

    @Override
    public boolean isEmpty() {
        return CadExMTKJNI.std_ShellList_isEmpty(this.swigCPtr, this);
    }

    @Override
    public void clear() {
        CadExMTKJNI.std_ShellList_clear(this.swigCPtr, this);
    }

    public ShellList(int count, Shell value) {
        this(CadExMTKJNI.new_std_ShellList__SWIG_2(count, Shell.getCPtr(value), value), true);
    }

    private int doCapacity() {
        return CadExMTKJNI.std_ShellList_doCapacity(this.swigCPtr, this);
    }

    private void doReserve(int n) {
        CadExMTKJNI.std_ShellList_doReserve(this.swigCPtr, this, n);
    }

    private int doSize() {
        return CadExMTKJNI.std_ShellList_doSize(this.swigCPtr, this);
    }

    private void doAdd(Shell x) {
        CadExMTKJNI.std_ShellList_doAdd__SWIG_0(this.swigCPtr, this, Shell.getCPtr(x), x);
    }

    private void doAdd(int index, Shell x) {
        CadExMTKJNI.std_ShellList_doAdd__SWIG_1(this.swigCPtr, this, index, Shell.getCPtr(x), x);
    }

    private Shell doRemove(int index) {
        return new Shell(CadExMTKJNI.std_ShellList_doRemove(this.swigCPtr, this, index), true);
    }

    private Shell doGet(int index) {
        return new Shell(CadExMTKJNI.std_ShellList_doGet(this.swigCPtr, this, index), false);
    }

    private Shell doSet(int index, Shell val) {
        return new Shell(CadExMTKJNI.std_ShellList_doSet(this.swigCPtr, this, index, Shell.getCPtr(val), val), true);
    }

    private void doRemoveRange(int fromIndex, int toIndex) {
        CadExMTKJNI.std_ShellList_doRemoveRange(this.swigCPtr, this, fromIndex, toIndex);
    }
}

