/*
 * Decompiled with CFR 0.152.
 */
package cadex;

import cadex.CadExMTKJNI;
import cadex.Collections.UuidData;
import java.nio.ByteBuffer;

public class Uuid {
    private transient long swigCPtr;
    public transient boolean swigCMemOwn;

    public Uuid(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    public static long getCPtr(Uuid obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    public static long swigRelease(Uuid obj) {
        long ptr = 0L;
        if (obj != null) {
            if (!obj.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            ptr = obj.swigCPtr;
            obj.swigCMemOwn = false;
            obj.delete();
        }
        return ptr;
    }

    public void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                CadExMTKJNI.delete_cadex_Uuid(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    private Uuid() {
        this(CadExMTKJNI.new_cadex_Uuid__SWIG_0(), true);
    }

    private Uuid(UuidData theData) {
        this(CadExMTKJNI.new_cadex_Uuid__SWIG_1(UuidData.getCPtr(theData), theData), true);
    }

    public boolean IsNull() {
        return CadExMTKJNI.cadex_Uuid_IsNull(this.swigCPtr, this);
    }

    public short Value(long theIndex) {
        return CadExMTKJNI.cadex_Uuid_Value(this.swigCPtr, this, theIndex);
    }

    private static UuidData ToUuidData(long mostSigBits, long leastSigBits) {
        ByteBuffer bb = ByteBuffer.wrap(new byte[16]);
        bb.putLong(mostSigBits);
        bb.putLong(leastSigBits);
        byte[] bytes = bb.array();
        UuidData data = new UuidData();
        for (int i = 0; i < 16; ++i) {
            data.set(i, bytes[i]);
        }
        return data;
    }

    public Uuid(long mostSigBits, long leastSigBits) {
        this(Uuid.ToUuidData(mostSigBits, leastSigBits));
    }
}

