/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.action;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.action.popup.ActionPopupMenu;
import bibliothek.gui.dock.action.popup.ActionPopupMenuFactory;
import bibliothek.gui.dock.action.popup.ActionPopupMenuListener;
import bibliothek.gui.dock.control.PopupController;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.event.MouseInputAdapter;

public abstract class ActionPopup
extends MouseInputAdapter {
    private boolean suppressable;
    private ActionPopupMenu menu;

    public ActionPopup(boolean suppressable) {
        this.suppressable = suppressable;
    }

    public boolean isSuppressable() {
        return this.suppressable;
    }

    public void setSuppressable(boolean suppressable) {
        this.suppressable = suppressable;
    }

    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.popup(e);
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.popup(e);
        }
    }

    protected abstract boolean isEnabled();

    protected abstract Dockable getDockable();

    protected abstract DockActionSource getActions();

    protected abstract Object getSource();

    protected void popup(MouseEvent e) {
        boolean shown;
        if (this.isMenuOpen()) {
            return;
        }
        if (e.isConsumed()) {
            return;
        }
        if (this.isEnabled() && (shown = this.popup(e.getComponent(), e.getX(), e.getY()))) {
            e.consume();
        }
    }

    protected Point getPopupLocation(Component owner, Point location) {
        return location;
    }

    protected ActionPopupMenuFactory getFactory() {
        return this.getDockable().getController().getPopupController().getPopupMenuFactory();
    }

    public boolean popup(Component owner, int x, int y) {
        Point location = this.getPopupLocation(owner, new Point(x, y));
        if (location == null) {
            return false;
        }
        Dockable dockable = this.getDockable();
        if (dockable.getController() == null) {
            return false;
        }
        PopupController popup = dockable.getController().getPopupController();
        if (!popup.isAllowOnMove() && dockable.getController().getRelocator().isOnMove()) {
            return false;
        }
        DockActionSource actions = this.getActions();
        if (!popup.isAllowEmptyMenu() && actions.getDockActionCount() == 0) {
            return false;
        }
        if (this.isSuppressable() && dockable.getController().getPopupSuppressor().suppress(dockable, actions)) {
            return false;
        }
        final ActionPopupMenu methodMenu = this.getFactory().createMenu(owner, dockable, actions, this.getSource());
        if (methodMenu == null) {
            return false;
        }
        this.menu = methodMenu;
        this.menu.addListener(new ActionPopupMenuListener(){

            public void closed(ActionPopupMenu menu) {
                if (methodMenu == menu) {
                    ActionPopup.this.menu = null;
                }
            }
        });
        this.menu.show(owner, location.x, location.y);
        return true;
    }

    public boolean isMenuOpen() {
        return this.menu != null;
    }
}

