/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.audioengines.javasound;

import java.io.InputStream;
import java.net.URL;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.DataLine;
import org.jogamp.java3d.MediaContainer;
import org.jogamp.java3d.View;
import org.jogamp.java3d.audioengines.AuralParameters;
import org.jogamp.java3d.audioengines.Sample;
import org.jogamp.java3d.audioengines.javasound.JSChannel;
import org.jogamp.java3d.audioengines.javasound.JSClip;
import org.jogamp.java3d.audioengines.javasound.JSStream;

class JSSample
extends Sample {
    static final int STREAMING_AUDIO_DATA = 1;
    static final int BUFFERED_AUDIO_DATA = 2;
    static final int STREAMING_MIDI_DATA = 3;
    static final int BUFFERED_MIDI_DATA = 3;
    static final int UNSUPPORTED_DATA_TYPE = -1;
    static final int NULL_SAMPLE = -1;
    int dataType = 2;
    JSChannel channel = null;
    long dataOffset = 0L;
    long timeDeactivated = 0L;
    long positionDeactivated = 0L;
    long sampleLength = 0L;
    long loopStartOffset = 0L;
    long loopLength = 0L;
    long attackLength = 0L;
    long releaseLength = 0L;
    float rateRatio = 1.0f;
    float currentRateRatio = -1.0f;
    float targetRateRatio = -1.0f;
    boolean rampRateFlag = false;

    @Override
    public void render(int dirtyFlags, View view, AuralParameters attribs) {
        float freqScaleFactor = attribs.frequencyScaleFactor;
        if (attribs != null) {
            if (!(freqScaleFactor <= 0.0f)) {
                this.rateRatio = this.currentRateRatio * freqScaleFactor;
            }
        } else {
            this.rateRatio = this.currentRateRatio;
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.dataType = -1;
        this.dataOffset = 0L;
        this.timeDeactivated = 0L;
        this.positionDeactivated = 0L;
        this.sampleLength = 0L;
        this.loopStartOffset = 0L;
        this.loopLength = 0L;
        this.attackLength = 0L;
        this.releaseLength = 0L;
        this.rateRatio = 1.0f;
        this.channel = null;
    }

    boolean load(MediaContainer soundData) {
        String path = soundData.getURLString();
        URL url = soundData.getURLObject();
        InputStream inputStream = soundData.getInputStream();
        boolean cacheFlag = soundData.getCacheEnable();
        AudioInputStream ais = null;
        DataLine dataLine = null;
        this.dataType = cacheFlag ? 2 : 1;
        if (url == null && inputStream == null && path == null) {
            return true;
        }
        if (path != null) {
            try {
                url = new URL(path);
            }
            catch (Exception e) {
                return true;
            }
        }
        if (this.dataType == 2) {
            this.channel = new JSClip();
            if (url != null) {
                ais = this.channel.initAudioInputStream(url, cacheFlag);
            } else if (inputStream != null) {
                ais = this.channel.initAudioInputStream(inputStream, cacheFlag);
            }
            if (ais == null) {
                return true;
            }
            dataLine = this.channel.initDataLine(ais);
        } else if (this.dataType == 1) {
            this.channel = new JSStream();
            if (url != null) {
                ais = this.channel.initAudioInputStream(url, cacheFlag);
            } else if (inputStream != null) {
                ais = this.channel.initAudioInputStream(inputStream, cacheFlag);
            }
            if (ais == null) {
                return true;
            }
            dataLine = this.channel.initDataLine(ais);
        }
        if (dataLine == null) {
            this.channel = null;
            return true;
        }
        this.duration = this.channel.getDuration();
        this.setDirtyFlags(65535);
        this.setSoundType(this.soundType);
        this.setSoundData(soundData);
        return false;
    }

    void reset() {
        this.rateRatio = 1.0f;
    }

    boolean getFilterFlag() {
        return false;
    }

    float getFilterFreq() {
        return -1.0f;
    }

    void setCurrentRateRatio(float ratio) {
        this.currentRateRatio = ratio;
    }

    float getCurrentRateRatio() {
        return this.currentRateRatio;
    }

    void setTargetRateRatio(float ratio) {
        this.targetRateRatio = ratio;
    }

    float getTargetRateRatio() {
        return this.targetRateRatio;
    }

    void setRampRateFlag(boolean flag) {
        this.rampRateFlag = flag;
    }

    boolean getRampRateFlag() {
        return this.rampRateFlag;
    }

    void setDataType(int type) {
        this.dataType = type;
    }

    int getDataType() {
        return this.dataType;
    }
}

