/*
 * Decompiled with CFR 0.152.
 */
package cadex.Collections;

import cadex.CadExMTKJNI;
import cadex.Collections.DoubleList;
import java.util.AbstractList;
import java.util.RandomAccess;

public class DoubleMatrix
extends AbstractList<DoubleList>
implements RandomAccess {
    private transient long swigCPtr;
    public transient boolean swigCMemOwn;

    public DoubleMatrix(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    public static long getCPtr(DoubleMatrix obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    public static long swigRelease(DoubleMatrix obj) {
        long ptr = 0L;
        if (obj != null) {
            if (!obj.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            ptr = obj.swigCPtr;
            obj.swigCMemOwn = false;
            obj.delete();
        }
        return ptr;
    }

    public void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                CadExMTKJNI.delete_std_DoubleMatrix(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public DoubleMatrix(DoubleList[] initialElements) {
        this();
        this.reserve(initialElements.length);
        for (DoubleList element : initialElements) {
            this.add(element);
        }
    }

    public DoubleMatrix(Iterable<DoubleList> initialElements) {
        this();
        for (DoubleList element : initialElements) {
            this.add(element);
        }
    }

    @Override
    public DoubleList get(int index) {
        return this.doGet(index);
    }

    @Override
    public DoubleList set(int index, DoubleList e) {
        return this.doSet(index, e);
    }

    @Override
    public boolean add(DoubleList e) {
        ++this.modCount;
        this.doAdd(e);
        return true;
    }

    @Override
    public void add(int index, DoubleList e) {
        ++this.modCount;
        this.doAdd(index, e);
    }

    @Override
    public DoubleList remove(int index) {
        ++this.modCount;
        return this.doRemove(index);
    }

    @Override
    public void removeRange(int fromIndex, int toIndex) {
        ++this.modCount;
        this.doRemoveRange(fromIndex, toIndex);
    }

    @Override
    public int size() {
        return this.doSize();
    }

    public int capacity() {
        return this.doCapacity();
    }

    public void reserve(int n) {
        this.doReserve(n);
    }

    public DoubleMatrix() {
        this(CadExMTKJNI.new_std_DoubleMatrix__SWIG_0(), true);
    }

    public DoubleMatrix(DoubleMatrix other) {
        this(CadExMTKJNI.new_std_DoubleMatrix__SWIG_1(DoubleMatrix.getCPtr(other), other), true);
    }

    @Override
    public boolean isEmpty() {
        return CadExMTKJNI.std_DoubleMatrix_isEmpty(this.swigCPtr, this);
    }

    @Override
    public void clear() {
        CadExMTKJNI.std_DoubleMatrix_clear(this.swigCPtr, this);
    }

    public DoubleMatrix(int count, DoubleList value) {
        this(CadExMTKJNI.new_std_DoubleMatrix__SWIG_2(count, DoubleList.getCPtr(value), value), true);
    }

    private int doCapacity() {
        return CadExMTKJNI.std_DoubleMatrix_doCapacity(this.swigCPtr, this);
    }

    private void doReserve(int n) {
        CadExMTKJNI.std_DoubleMatrix_doReserve(this.swigCPtr, this, n);
    }

    private int doSize() {
        return CadExMTKJNI.std_DoubleMatrix_doSize(this.swigCPtr, this);
    }

    private void doAdd(DoubleList x) {
        CadExMTKJNI.std_DoubleMatrix_doAdd__SWIG_0(this.swigCPtr, this, DoubleList.getCPtr(x), x);
    }

    private void doAdd(int index, DoubleList x) {
        CadExMTKJNI.std_DoubleMatrix_doAdd__SWIG_1(this.swigCPtr, this, index, DoubleList.getCPtr(x), x);
    }

    private DoubleList doRemove(int index) {
        return new DoubleList(CadExMTKJNI.std_DoubleMatrix_doRemove(this.swigCPtr, this, index), true);
    }

    private DoubleList doGet(int index) {
        return new DoubleList(CadExMTKJNI.std_DoubleMatrix_doGet(this.swigCPtr, this, index), false);
    }

    private DoubleList doSet(int index, DoubleList val) {
        return new DoubleList(CadExMTKJNI.std_DoubleMatrix_doSet(this.swigCPtr, this, index, DoubleList.getCPtr(val), val), true);
    }

    private void doRemoveRange(int fromIndex, int toIndex) {
        CadExMTKJNI.std_DoubleMatrix_doRemoveRange(this.swigCPtr, this, fromIndex, toIndex);
    }
}

