/*
 * Decompiled with CFR 0.152.
 */
package cadex.Collections;

import cadex.CadExMTKJNI;
import cadex.ModelData.Shape;
import java.util.AbstractList;
import java.util.RandomAccess;

public class ShapeList
extends AbstractList<Shape>
implements RandomAccess {
    private transient long swigCPtr;
    public transient boolean swigCMemOwn;

    public ShapeList(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    public static long getCPtr(ShapeList obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    public static long swigRelease(ShapeList obj) {
        long ptr = 0L;
        if (obj != null) {
            if (!obj.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            ptr = obj.swigCPtr;
            obj.swigCMemOwn = false;
            obj.delete();
        }
        return ptr;
    }

    public void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                CadExMTKJNI.delete_std_ShapeList(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public ShapeList(Shape[] initialElements) {
        this();
        this.reserve(initialElements.length);
        for (Shape element : initialElements) {
            this.add(element);
        }
    }

    public ShapeList(Iterable<Shape> initialElements) {
        this();
        for (Shape element : initialElements) {
            this.add(element);
        }
    }

    @Override
    public Shape get(int index) {
        return this.doGet(index);
    }

    @Override
    public Shape set(int index, Shape e) {
        return this.doSet(index, e);
    }

    @Override
    public boolean add(Shape e) {
        ++this.modCount;
        this.doAdd(e);
        return true;
    }

    @Override
    public void add(int index, Shape e) {
        ++this.modCount;
        this.doAdd(index, e);
    }

    @Override
    public Shape remove(int index) {
        ++this.modCount;
        return this.doRemove(index);
    }

    @Override
    public void removeRange(int fromIndex, int toIndex) {
        ++this.modCount;
        this.doRemoveRange(fromIndex, toIndex);
    }

    @Override
    public int size() {
        return this.doSize();
    }

    public int capacity() {
        return this.doCapacity();
    }

    public void reserve(int n) {
        this.doReserve(n);
    }

    public ShapeList() {
        this(CadExMTKJNI.new_std_ShapeList__SWIG_0(), true);
    }

    public ShapeList(ShapeList other) {
        this(CadExMTKJNI.new_std_ShapeList__SWIG_1(ShapeList.getCPtr(other), other), true);
    }

    @Override
    public boolean isEmpty() {
        return CadExMTKJNI.std_ShapeList_isEmpty(this.swigCPtr, this);
    }

    @Override
    public void clear() {
        CadExMTKJNI.std_ShapeList_clear(this.swigCPtr, this);
    }

    public ShapeList(int count, Shape value) {
        this(CadExMTKJNI.new_std_ShapeList__SWIG_2(count, Shape.getCPtr(value), value), true);
    }

    private int doCapacity() {
        return CadExMTKJNI.std_ShapeList_doCapacity(this.swigCPtr, this);
    }

    private void doReserve(int n) {
        CadExMTKJNI.std_ShapeList_doReserve(this.swigCPtr, this, n);
    }

    private int doSize() {
        return CadExMTKJNI.std_ShapeList_doSize(this.swigCPtr, this);
    }

    private void doAdd(Shape x) {
        CadExMTKJNI.std_ShapeList_doAdd__SWIG_0(this.swigCPtr, this, Shape.getCPtr(x), x);
    }

    private void doAdd(int index, Shape x) {
        CadExMTKJNI.std_ShapeList_doAdd__SWIG_1(this.swigCPtr, this, index, Shape.getCPtr(x), x);
    }

    private Shape doRemove(int index) {
        return new Shape(CadExMTKJNI.std_ShapeList_doRemove(this.swigCPtr, this, index), true);
    }

    private Shape doGet(int index) {
        return new Shape(CadExMTKJNI.std_ShapeList_doGet(this.swigCPtr, this, index), false);
    }

    private Shape doSet(int index, Shape val) {
        return new Shape(CadExMTKJNI.std_ShapeList_doSet(this.swigCPtr, this, index, Shape.getCPtr(val), val), true);
    }

    private void doRemoveRange(int fromIndex, int toIndex) {
        CadExMTKJNI.std_ShapeList_doRemoveRange(this.swigCPtr, this, fromIndex, toIndex);
    }
}

