/*
 * Decompiled with CFR 0.152.
 */
package cadex.Drawing;

import cadex.BaseObject;
import cadex.CadExMTKJNI;
import cadex.Drawing.View;
import cadex.Uuid;
import java.nio.ByteBuffer;
import java.util.UUID;

public class Sheet
extends BaseObject {
    private transient long swigCPtr;

    public Sheet(long cPtr, boolean cMemoryOwn) {
        super(CadExMTKJNI.cadex_Drawing_Sheet_SWIGUpcast(cPtr), cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    public static long getCPtr(Sheet obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    public static long swigRelease(Sheet obj) {
        long ptr = 0L;
        if (obj != null) {
            if (!obj.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            ptr = obj.swigCPtr;
            obj.swigCMemOwn = false;
            obj.delete();
        }
        return ptr;
    }

    @Override
    public void finalize() {
        this.delete();
    }

    @Override
    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                CadExMTKJNI.delete_cadex_Drawing_Sheet(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public Sheet() {
        this(CadExMTKJNI.new_cadex_Drawing_Sheet(), true);
    }

    public void SetUuid(UUID theUuid) {
        Uuid temptheUuid = new Uuid(theUuid.getMostSignificantBits(), theUuid.getLeastSignificantBits());
        CadExMTKJNI.cadex_Drawing_Sheet_SetUuid(this.swigCPtr, this, Uuid.getCPtr(temptheUuid), temptheUuid);
    }

    public UUID Uuid() {
        Uuid ret = new Uuid(CadExMTKJNI.cadex_Drawing_Sheet_Uuid(this.swigCPtr, this), true);
        if (!ret.IsNull()) {
            byte[] aBytes = new byte[16];
            for (int i = 0; i < 16; ++i) {
                aBytes[i] = (byte)ret.Value(i);
            }
            ByteBuffer bb = ByteBuffer.wrap(aBytes);
            long mostSigBits = bb.getLong();
            long leastSigBits = bb.getLong();
            return new UUID(mostSigBits, leastSigBits);
        }
        return new UUID(0L, 0L);
    }

    public double Width() {
        return CadExMTKJNI.cadex_Drawing_Sheet_Width(this.swigCPtr, this);
    }

    public double Height() {
        return CadExMTKJNI.cadex_Drawing_Sheet_Height(this.swigCPtr, this);
    }

    public PaperSizeType PaperSize() {
        return PaperSizeType.swigToEnum(CadExMTKJNI.cadex_Drawing_Sheet_PaperSize(this.swigCPtr, this));
    }

    public OrientationType Orientation() {
        return OrientationType.swigToEnum(CadExMTKJNI.cadex_Drawing_Sheet_Orientation(this.swigCPtr, this));
    }

    public void SetStandardSheetSize(PaperSizeType thePaperSize, OrientationType theOrientation) {
        CadExMTKJNI.cadex_Drawing_Sheet_SetStandardSheetSize(this.swigCPtr, this, thePaperSize.swigValue(), theOrientation.swigValue());
    }

    public void SetCustomSheetSize(double theWidth, double theHeight) {
        CadExMTKJNI.cadex_Drawing_Sheet_SetCustomSheetSize(this.swigCPtr, this, theWidth, theHeight);
    }

    public long NumberOfViews() {
        return CadExMTKJNI.cadex_Drawing_Sheet_NumberOfViews(this.swigCPtr, this);
    }

    public void AddView(View theView) {
        CadExMTKJNI.cadex_Drawing_Sheet_AddView(this.swigCPtr, this, View.getCPtr(theView), theView);
    }

    public static boolean CompareType(BaseObject theObject) {
        return CadExMTKJNI.cadex_Drawing_Sheet_CompareType(BaseObject.getCPtr(theObject), theObject);
    }

    public static Sheet Cast(BaseObject theBase) {
        return new Sheet(CadExMTKJNI.cadex_Drawing_Sheet_Cast(BaseObject.getCPtr(theBase), theBase), true);
    }

    public static enum OrientationType {
        Landscape,
        Portrait;

        private final int swigValue;

        public final int swigValue() {
            return this.swigValue;
        }

        public static OrientationType swigToEnum(int swigValue) {
            OrientationType[] swigValues = (OrientationType[])OrientationType.class.getEnumConstants();
            if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            for (OrientationType swigEnum : swigValues) {
                if (swigEnum.swigValue != swigValue) continue;
                return swigEnum;
            }
            throw new IllegalArgumentException("No enum " + OrientationType.class + " with value " + swigValue);
        }

        private OrientationType() {
            this.swigValue = SwigNext.next++;
        }

        private OrientationType(int swigValue) {
            this.swigValue = swigValue;
            SwigNext.next = swigValue + 1;
        }

        private OrientationType(OrientationType swigEnum) {
            this.swigValue = swigEnum.swigValue;
            SwigNext.next = this.swigValue + 1;
        }

        private static class SwigNext {
            private static int next = 0;

            private SwigNext() {
            }
        }
    }

    public static enum PaperSizeType {
        UnknownPaperSize(CadExMTKJNI.cadex_Drawing_Sheet_PaperSizeType_UnknownPaperSize_get()),
        A0,
        A1,
        A2,
        A3,
        A4,
        A,
        B,
        C,
        D,
        E,
        UserDefinedPaperSize(CadExMTKJNI.cadex_Drawing_Sheet_PaperSizeType_UserDefinedPaperSize_get());

        private final int swigValue;

        public final int swigValue() {
            return this.swigValue;
        }

        public static PaperSizeType swigToEnum(int swigValue) {
            PaperSizeType[] swigValues = (PaperSizeType[])PaperSizeType.class.getEnumConstants();
            if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            for (PaperSizeType swigEnum : swigValues) {
                if (swigEnum.swigValue != swigValue) continue;
                return swigEnum;
            }
            throw new IllegalArgumentException("No enum " + PaperSizeType.class + " with value " + swigValue);
        }

        private PaperSizeType() {
            this.swigValue = SwigNext.next++;
        }

        private PaperSizeType(int swigValue) {
            this.swigValue = swigValue;
            SwigNext.next = swigValue + 1;
        }

        private PaperSizeType(PaperSizeType swigEnum) {
            this.swigValue = swigEnum.swigValue;
            SwigNext.next = this.swigValue + 1;
        }

        private static class SwigNext {
            private static int next = 0;

            private SwigNext() {
            }
        }
    }

    public static class ViewIterator
    extends BaseObject {
        private transient long swigCPtr;

        public ViewIterator(long cPtr, boolean cMemoryOwn) {
            super(CadExMTKJNI.cadex_Drawing_Sheet_ViewIterator_SWIGUpcast(cPtr), cMemoryOwn);
            this.swigCPtr = cPtr;
        }

        public static long getCPtr(ViewIterator obj) {
            return obj == null ? 0L : obj.swigCPtr;
        }

        public static long swigRelease(ViewIterator obj) {
            long ptr = 0L;
            if (obj != null) {
                if (!obj.swigCMemOwn) {
                    throw new RuntimeException("Cannot release ownership as memory is not owned");
                }
                ptr = obj.swigCPtr;
                obj.swigCMemOwn = false;
                obj.delete();
            }
            return ptr;
        }

        @Override
        public void finalize() {
            this.delete();
        }

        @Override
        public synchronized void delete() {
            if (this.swigCPtr != 0L) {
                if (this.swigCMemOwn) {
                    this.swigCMemOwn = false;
                    CadExMTKJNI.delete_cadex_Drawing_Sheet_ViewIterator(this.swigCPtr);
                }
                this.swigCPtr = 0L;
            }
            super.delete();
        }

        public ViewIterator(Sheet theSheet) {
            this(CadExMTKJNI.new_cadex_Drawing_Sheet_ViewIterator(Sheet.getCPtr(theSheet), theSheet), true);
        }

        public boolean HasNext() {
            return CadExMTKJNI.cadex_Drawing_Sheet_ViewIterator_HasNext(this.swigCPtr, this);
        }

        public View Next() {
            return new View(CadExMTKJNI.cadex_Drawing_Sheet_ViewIterator_Next(this.swigCPtr, this), false);
        }
    }
}

