/*
 * Decompiled with CFR 0.152.
 */
package cadex;

import cadex.Base_LoggerAppender;
import cadex.CadExCoreJNI;
import java.util.ArrayList;

public class Base_Logger {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;
    private ArrayList<Base_LoggerAppender> myAppenders = new ArrayList();
    private static Base_Logger theGlobalLogger = null;

    protected Base_Logger(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(Base_Logger obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected static long swigRelease(Base_Logger obj) {
        long ptr = 0L;
        if (obj != null) {
            if (!obj.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            ptr = obj.swigCPtr;
            obj.swigCMemOwn = false;
            obj.delete();
        }
        return ptr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                if (this.myAppenders.size() > 0) {
                    ArrayList<Base_LoggerAppender> anAppenders = new ArrayList<Base_LoggerAppender>(this.myAppenders);
                    for (Base_LoggerAppender anAppender : anAppenders) {
                        this.Unregister(anAppender);
                    }
                }
                this.swigCMemOwn = false;
                CadExCoreJNI.delete_cadex_Base_Logger(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    private void AddAppender(Base_LoggerAppender theAppender) {
        this.myAppenders.add(theAppender);
    }

    private void RemoveAppender(Base_LoggerAppender theAppender) {
        this.myAppenders.remove(theAppender);
    }

    private static Base_Logger GlobalInstanceImpl() {
        return new Base_Logger(CadExCoreJNI.cadex_Base_Logger_GlobalInstanceImpl(), false);
    }

    public void SetLevel(Level theLevel) {
        CadExCoreJNI.cadex_Base_Logger_SetLevel(this.swigCPtr, this, theLevel.swigValue());
    }

    public Level GetLevel() {
        return Level.swigToEnum(CadExCoreJNI.cadex_Base_Logger_GetLevel(this.swigCPtr, this));
    }

    public boolean CanAccept(Level theLevel) {
        return CadExCoreJNI.cadex_Base_Logger_CanAccept(this.swigCPtr, this, theLevel.swigValue());
    }

    private void RegisterImpl(Base_LoggerAppender theAppender, Level theMinLevel, Level theMaxLevel) {
        CadExCoreJNI.cadex_Base_Logger_RegisterImpl__SWIG_0(this.swigCPtr, this, Base_LoggerAppender.getCPtr(theAppender), theAppender, theMinLevel.swigValue(), theMaxLevel.swigValue());
    }

    private void RegisterImpl(Base_LoggerAppender theAppender, Level theMinLevel) {
        CadExCoreJNI.cadex_Base_Logger_RegisterImpl__SWIG_1(this.swigCPtr, this, Base_LoggerAppender.getCPtr(theAppender), theAppender, theMinLevel.swigValue());
    }

    private void RegisterImpl(Base_LoggerAppender theAppender) {
        CadExCoreJNI.cadex_Base_Logger_RegisterImpl__SWIG_2(this.swigCPtr, this, Base_LoggerAppender.getCPtr(theAppender), theAppender);
    }

    private void UnregisterImpl(Base_LoggerAppender theAppender) {
        CadExCoreJNI.cadex_Base_Logger_UnregisterImpl(this.swigCPtr, this, Base_LoggerAppender.getCPtr(theAppender), theAppender);
    }

    public static Base_Logger GlobalInstance() {
        if (theGlobalLogger == null) {
            theGlobalLogger = Base_Logger.GlobalInstanceImpl();
        }
        return theGlobalLogger;
    }

    public void Register(Base_LoggerAppender theAppender, Level theMinLevel, Level theMaxLevel) {
        this.RegisterImpl(theAppender, theMinLevel, theMaxLevel);
        this.AddAppender(theAppender);
    }

    public void Register(Base_LoggerAppender theAppender, Level theMinLevel) {
        this.RegisterImpl(theAppender, theMinLevel);
        this.AddAppender(theAppender);
    }

    public void Register(Base_LoggerAppender theAppender) {
        this.RegisterImpl(theAppender);
        this.AddAppender(theAppender);
    }

    public void Unregister(Base_LoggerAppender theAppender) {
        this.UnregisterImpl(theAppender);
        this.RemoveAppender(theAppender);
    }

    public static enum Level {
        Trace,
        Debug,
        Info,
        Warning,
        Error,
        Fatal;

        private final int swigValue;

        public final int swigValue() {
            return this.swigValue;
        }

        public static Level swigToEnum(int swigValue) {
            Level[] swigValues = (Level[])Level.class.getEnumConstants();
            if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            for (Level swigEnum : swigValues) {
                if (swigEnum.swigValue != swigValue) continue;
                return swigEnum;
            }
            throw new IllegalArgumentException("No enum " + Level.class + " with value " + swigValue);
        }

        private Level() {
            this.swigValue = SwigNext.next++;
        }

        private Level(int swigValue) {
            this.swigValue = swigValue;
            SwigNext.next = swigValue + 1;
        }

        private Level(Level swigEnum) {
            this.swigValue = swigEnum.swigValue;
            SwigNext.next = this.swigValue + 1;
        }

        private static class SwigNext {
            private static int next = 0;

            private SwigNext() {
            }
        }
    }
}

