/*
 * Decompiled with CFR 0.152.
 */
package jogamp.nativewindow.x11;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.nio.StructAccessor;
import com.jogamp.common.os.MachineDataInfo;
import java.nio.ByteBuffer;
import jogamp.common.os.MachineDataInfoRuntime;

public class XRenderDirectFormat {
    StructAccessor accessor;
    private static final int mdIdx = MachineDataInfoRuntime.getStatic().ordinal();
    private final MachineDataInfo md;
    private static final int[] XRenderDirectFormat_size = new int[]{16, 16, 16, 16, 16, 16, 16, 16, 16, 16};
    private static final int[] red_offset = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final int[] redMask_offset = new int[]{2, 2, 2, 2, 2, 2, 2, 2, 2, 2};
    private static final int[] green_offset = new int[]{4, 4, 4, 4, 4, 4, 4, 4, 4, 4};
    private static final int[] greenMask_offset = new int[]{6, 6, 6, 6, 6, 6, 6, 6, 6, 6};
    private static final int[] blue_offset = new int[]{8, 8, 8, 8, 8, 8, 8, 8, 8, 8};
    private static final int[] blueMask_offset = new int[]{10, 10, 10, 10, 10, 10, 10, 10, 10, 10};
    private static final int[] alpha_offset = new int[]{12, 12, 12, 12, 12, 12, 12, 12, 12, 12};
    private static final int[] alphaMask_offset = new int[]{14, 14, 14, 14, 14, 14, 14, 14, 14, 14};

    public static int size() {
        return XRenderDirectFormat_size[mdIdx];
    }

    public static XRenderDirectFormat create() {
        return XRenderDirectFormat.create(Buffers.newDirectByteBuffer(XRenderDirectFormat.size()));
    }

    public static XRenderDirectFormat create(ByteBuffer byteBuffer) {
        return new XRenderDirectFormat(byteBuffer);
    }

    XRenderDirectFormat(ByteBuffer byteBuffer) {
        this.md = MachineDataInfo.StaticConfig.values()[XRenderDirectFormat.mdIdx].md;
        this.accessor = new StructAccessor(byteBuffer);
    }

    public ByteBuffer getBuffer() {
        return this.accessor.getBuffer();
    }

    public XRenderDirectFormat setRed(short s) {
        this.accessor.setShortAt(red_offset[mdIdx], s);
        return this;
    }

    public short getRed() {
        return this.accessor.getShortAt(red_offset[mdIdx]);
    }

    public XRenderDirectFormat setRedMask(short s) {
        this.accessor.setShortAt(redMask_offset[mdIdx], s);
        return this;
    }

    public short getRedMask() {
        return this.accessor.getShortAt(redMask_offset[mdIdx]);
    }

    public XRenderDirectFormat setGreen(short s) {
        this.accessor.setShortAt(green_offset[mdIdx], s);
        return this;
    }

    public short getGreen() {
        return this.accessor.getShortAt(green_offset[mdIdx]);
    }

    public XRenderDirectFormat setGreenMask(short s) {
        this.accessor.setShortAt(greenMask_offset[mdIdx], s);
        return this;
    }

    public short getGreenMask() {
        return this.accessor.getShortAt(greenMask_offset[mdIdx]);
    }

    public XRenderDirectFormat setBlue(short s) {
        this.accessor.setShortAt(blue_offset[mdIdx], s);
        return this;
    }

    public short getBlue() {
        return this.accessor.getShortAt(blue_offset[mdIdx]);
    }

    public XRenderDirectFormat setBlueMask(short s) {
        this.accessor.setShortAt(blueMask_offset[mdIdx], s);
        return this;
    }

    public short getBlueMask() {
        return this.accessor.getShortAt(blueMask_offset[mdIdx]);
    }

    public XRenderDirectFormat setAlpha(short s) {
        this.accessor.setShortAt(alpha_offset[mdIdx], s);
        return this;
    }

    public short getAlpha() {
        return this.accessor.getShortAt(alpha_offset[mdIdx]);
    }

    public XRenderDirectFormat setAlphaMask(short s) {
        this.accessor.setShortAt(alphaMask_offset[mdIdx], s);
        return this;
    }

    public short getAlphaMask() {
        return this.accessor.getShortAt(alphaMask_offset[mdIdx]);
    }
}

