/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.os.Platform;
import com.jogamp.nativewindow.AbstractGraphicsConfiguration;
import com.jogamp.nativewindow.AbstractGraphicsDevice;
import com.jogamp.nativewindow.AbstractGraphicsScreen;
import com.jogamp.nativewindow.CapabilitiesChooser;
import com.jogamp.nativewindow.CapabilitiesImmutable;
import com.jogamp.nativewindow.GraphicsConfigurationFactory;
import com.jogamp.nativewindow.NativeSurface;
import com.jogamp.nativewindow.NativeWindow;
import com.jogamp.nativewindow.NativeWindowFactory;
import com.jogamp.nativewindow.ProxySurface;
import com.jogamp.nativewindow.UpstreamSurfaceHook;
import com.jogamp.nativewindow.awt.AWTGraphicsConfiguration;
import com.jogamp.nativewindow.awt.AWTGraphicsDevice;
import com.jogamp.nativewindow.awt.AWTGraphicsScreen;
import com.jogamp.nativewindow.awt.JAWTWindow;
import com.jogamp.opengl.DefaultGLCapabilitiesChooser;
import com.jogamp.opengl.FBObject;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesChooser;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLDrawable;
import com.jogamp.opengl.GLDrawableFactory;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLFBODrawable;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.Threading;
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.DisplayMode;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Window;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jogamp.java3d.Canvas3D;
import org.jogamp.java3d.Context;
import org.jogamp.java3d.Drawable;
import org.jogamp.java3d.DrawingSurfaceObject;
import org.jogamp.java3d.GeometryArrayRetained;
import org.jogamp.java3d.GeometryStripArrayRetained;
import org.jogamp.java3d.GraphicsConfigInfo;
import org.jogamp.java3d.GraphicsConfigTemplate3D;
import org.jogamp.java3d.IllegalRenderingStateException;
import org.jogamp.java3d.IndexedGeometryStripArrayRetained;
import org.jogamp.java3d.JoglContext;
import org.jogamp.java3d.JoglDrawable;
import org.jogamp.java3d.JoglDrawingSurfaceObject;
import org.jogamp.java3d.JoglGraphicsConfiguration;
import org.jogamp.java3d.JoglShaderObject;
import org.jogamp.java3d.MasterControl;
import org.jogamp.java3d.Pipeline;
import org.jogamp.java3d.ShaderAttrLoc;
import org.jogamp.java3d.ShaderError;
import org.jogamp.java3d.ShaderId;
import org.jogamp.java3d.ShaderProgramId;
import org.jogamp.java3d.VirtualUniverse;

class JoglPipeline
extends Pipeline {
    private static final boolean DEBUG = true;
    private static final boolean VERBOSE = false;
    private static final boolean DEBUG_CONFIG = false;
    private static final boolean EXTRA_DEBUGGING = false;
    private static final int WAIT_TIME = 1000;
    private static final int MIN_FRAME_SIZE = 1;
    private GLProfile profile;
    private Object mainThreadContext;
    private static final float[] black;
    private static final int[][] screen_door;
    private static final ByteBuffer[] screen_door_table;
    private static final int[] blendFunctionTable;
    private static final int[] _gl_combineRgbSrcIndex;
    private static final int[] _gl_combineAlphaSrcIndex;
    private static final int[] _gl_combineRgbOpIndex;
    private static final int[] _gl_combineAlphaOpIndex;
    private static final int[] _gl_combineSrc;
    private static final int[] _gl_combineFcn;
    private static final int[] _gl_textureCubeMapFace;
    int numInvalidLists = 0;
    private boolean checkedForGetScreenMethod = false;
    private Method getScreenMethod = null;
    private static ThreadLocal<FloatBuffer> nioVertexTemp;
    private static ThreadLocal<DoubleBuffer> nioVertexDoubleTemp;
    private static ThreadLocal<FloatBuffer> nioColorTemp;
    private static ThreadLocal<ByteBuffer> nioColorByteTemp;
    private static ThreadLocal<FloatBuffer> nioNormalTemp;
    private static ThreadLocal<FloatBuffer[]> nioTexCoordSetTemp;
    private static ThreadLocal<FloatBuffer[]> nioVertexAttrSetTemp;

    protected JoglPipeline() {
        int javaVersion = JoglPipeline.getVersion();
        if (javaVersion == 7 || javaVersion == 8) {
            try {
                this.mainThreadContext = Class.forName("sun.awt.AppContext").getMethod("getAppContext", new Class[0]).invoke(null, new Object[0]);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    void initialize(Pipeline.Type pipelineType) {
        super.initialize(pipelineType);
        assert (pipelineType == Pipeline.Type.JOGL);
        Threading.disableSingleThreading();
        this.profile = GLProfile.getMaxFixedFunc((boolean)true);
    }

    @Override
    void execute(Context ctx, GeometryArrayRetained geo, int geo_type, boolean isNonUniformScale, boolean useAlpha, boolean ignoreVertexColors, int startVIndex, int vcount, int vformat, int texCoordSetCount, int[] texCoordSetMap, int texCoordSetMapLen, int[] texUnitOffset, int numActiveTexUnitState, int vertexAttrCount, int[] vertexAttrSizes, float[] varray, float[] carray, int cDirty) {
        this.executeGeometryArray(ctx, geo, geo_type, isNonUniformScale, useAlpha, ignoreVertexColors, startVIndex, vcount, vformat, texCoordSetCount, texCoordSetMap, texCoordSetMapLen, texUnitOffset, numActiveTexUnitState, vertexAttrCount, vertexAttrSizes, varray, null, carray, cDirty);
    }

    @Override
    void executeVA(Context ctx, GeometryArrayRetained geo, int geo_type, boolean isNonUniformScale, boolean ignoreVertexColors, int vcount, int vformat, int vdefined, int initialCoordIndex, float[] vfcoords, double[] vdcoords, int initialColorIndex, float[] cfdata, byte[] cbdata, int initialNormalIndex, float[] ndata, int vertexAttrCount, int[] vertexAttrSizes, int[] vertexAttrIndices, float[][] vertexAttrData, int texCoordMapLength, int[] texcoordoffset, int numActiveTexUnitState, int[] texIndex, int texstride, Object[] texCoords, int cdirty) {
        boolean floatCoordDefined = (vdefined & 1) != 0;
        boolean doubleCoordDefined = (vdefined & 2) != 0;
        boolean floatColorsDefined = (vdefined & 4) != 0;
        boolean byteColorsDefined = (vdefined & 8) != 0;
        boolean normalsDefined = (vdefined & 0x10) != 0;
        boolean vattrDefined = (vdefined & 0x40) != 0;
        boolean textureDefined = (vdefined & 0x20) != 0;
        FloatBuffer fverts = null;
        DoubleBuffer dverts = null;
        FloatBuffer fclrs = null;
        ByteBuffer bclrs = null;
        FloatBuffer[] texCoordBufs = null;
        FloatBuffer norms = null;
        FloatBuffer[] vertexAttrBufs = null;
        if (vattrDefined) {
            vertexAttrBufs = JoglPipeline.getVertexAttrSetBuffer((Object[])vertexAttrData);
        }
        if (textureDefined) {
            texCoordBufs = JoglPipeline.getTexCoordSetBuffer(texCoords);
        }
        if (floatCoordDefined) {
            fverts = JoglPipeline.getVertexArrayBuffer(vfcoords);
        } else if (doubleCoordDefined) {
            dverts = JoglPipeline.getVertexArrayBuffer(vdcoords);
        }
        if (floatColorsDefined) {
            fclrs = JoglPipeline.getColorArrayBuffer(cfdata);
        } else if (byteColorsDefined) {
            bclrs = JoglPipeline.getColorArrayBuffer(cbdata);
        }
        if (normalsDefined) {
            norms = JoglPipeline.getNormalArrayBuffer(ndata);
        }
        int[] sarray = null;
        int[] start_array = null;
        int strip_len = 0;
        if (geo_type == 5 || geo_type == 6 || geo_type == 7) {
            sarray = ((GeometryStripArrayRetained)geo).stripVertexCounts;
            strip_len = sarray.length;
            start_array = ((GeometryStripArrayRetained)geo).stripStartOffsetIndices;
        }
        this.executeGeometryArrayVA(ctx, geo, geo_type, isNonUniformScale, ignoreVertexColors, vcount, vformat, vdefined, initialCoordIndex, fverts, dverts, initialColorIndex, fclrs, bclrs, initialNormalIndex, norms, vertexAttrCount, vertexAttrSizes, vertexAttrIndices, vertexAttrBufs, texCoordMapLength, texcoordoffset, numActiveTexUnitState, texIndex, texstride, texCoordBufs, cdirty, sarray, strip_len, start_array);
    }

    @Override
    void executeVABuffer(Context ctx, GeometryArrayRetained geo, int geo_type, boolean isNonUniformScale, boolean ignoreVertexColors, int vcount, int vformat, int vdefined, int initialCoordIndex, Buffer vcoords, int initialColorIndex, Buffer cdataBuffer, float[] cfdata, byte[] cbdata, int initialNormalIndex, FloatBuffer ndata, int vertexAttrCount, int[] vertexAttrSizes, int[] vertexAttrIndices, FloatBuffer[] vertexAttrData, int texCoordMapLength, int[] texcoordoffset, int numActiveTexUnitState, int[] texIndex, int texstride, Object[] texCoords, int cdirty) {
        boolean floatCoordDefined = (vdefined & 1) != 0;
        boolean doubleCoordDefined = (vdefined & 2) != 0;
        boolean floatColorsDefined = (vdefined & 4) != 0;
        boolean byteColorsDefined = (vdefined & 8) != 0;
        boolean normalsDefined = (vdefined & 0x10) != 0;
        boolean vattrDefined = (vdefined & 0x40) != 0;
        boolean textureDefined = (vdefined & 0x20) != 0;
        FloatBuffer fverts = null;
        DoubleBuffer dverts = null;
        FloatBuffer fclrs = null;
        ByteBuffer bclrs = null;
        FloatBuffer[] texCoordBufs = null;
        FloatBuffer norms = null;
        FloatBuffer[] vertexAttrBufs = null;
        if (vattrDefined) {
            vertexAttrBufs = vertexAttrData;
        }
        if (textureDefined) {
            texCoordBufs = new FloatBuffer[texCoords.length];
            for (int i = 0; i < texCoords.length; ++i) {
                texCoordBufs[i] = (FloatBuffer)texCoords[i];
            }
        }
        if (floatCoordDefined) {
            fverts = (FloatBuffer)vcoords;
        } else if (doubleCoordDefined) {
            dverts = (DoubleBuffer)vcoords;
        }
        if (fverts == null && dverts == null) {
            return;
        }
        if (floatColorsDefined) {
            fclrs = cfdata != null ? JoglPipeline.getColorArrayBuffer(cfdata) : (FloatBuffer)cdataBuffer;
        } else if (byteColorsDefined) {
            bclrs = cbdata != null ? JoglPipeline.getColorArrayBuffer(cbdata) : (ByteBuffer)cdataBuffer;
        }
        if (normalsDefined) {
            norms = ndata;
        }
        int[] sarray = null;
        int[] start_array = null;
        int strip_len = 0;
        if (geo_type == 5 || geo_type == 6 || geo_type == 7) {
            sarray = ((GeometryStripArrayRetained)geo).stripVertexCounts;
            strip_len = sarray.length;
            start_array = ((GeometryStripArrayRetained)geo).stripStartOffsetIndices;
        }
        this.executeGeometryArrayVA(ctx, geo, geo_type, isNonUniformScale, ignoreVertexColors, vcount, vformat, vdefined, initialCoordIndex, fverts, dverts, initialColorIndex, fclrs, bclrs, initialNormalIndex, norms, vertexAttrCount, vertexAttrSizes, vertexAttrIndices, vertexAttrBufs, texCoordMapLength, texcoordoffset, numActiveTexUnitState, texIndex, texstride, texCoordBufs, cdirty, sarray, strip_len, start_array);
    }

    @Override
    void executeInterleavedBuffer(Context ctx, GeometryArrayRetained geo, int geo_type, boolean isNonUniformScale, boolean useAlpha, boolean ignoreVertexColors, int startVIndex, int vcount, int vformat, int texCoordSetCount, int[] texCoordSetMap, int texCoordSetMapLen, int[] texUnitOffset, int numActiveTexUnit, FloatBuffer varray, float[] cdata, int cdirty) {
        this.executeGeometryArray(ctx, geo, geo_type, isNonUniformScale, useAlpha, ignoreVertexColors, startVIndex, vcount, vformat, texCoordSetCount, texCoordSetMap, texCoordSetMapLen, texUnitOffset, numActiveTexUnit, 0, null, null, varray, cdata, cdirty);
    }

    @Override
    void setVertexFormat(Context ctx, GeometryArrayRetained geo, int vformat, boolean useAlpha, boolean ignoreVertexColors) {
        GL2 gl = this.context(ctx).getGL().getGL2();
        if ((vformat & 2) != 0) {
            gl.glEnableClientState(32885);
        } else {
            gl.glDisableClientState(32885);
        }
        if (!ignoreVertexColors && (vformat & 4) != 0) {
            gl.glEnableClientState(32886);
        } else {
            gl.glDisableClientState(32886);
        }
        if ((vformat & 1) != 0) {
            gl.glEnableClientState(32884);
        } else {
            gl.glDisableClientState(32884);
        }
    }

    @Override
    void buildGA(Context ctx, GeometryArrayRetained geo, int geo_type, boolean isNonUniformScale, boolean updateAlpha, float alpha, boolean ignoreVertexColors, int startVIndex, int vcount, int vformat, int texCoordSetCount, int[] texCoordSetMap, int texCoordSetMapLen, int[] texCoordSetMapOffset, int vertexAttrCount, int[] vertexAttrSizes, double[] xform, double[] nxform, float[] varray) {
        JoglContext jctx = (JoglContext)ctx;
        GL2 gl = this.context(ctx).getGL().getGL2();
        FloatBuffer verts = null;
        int stride = 0;
        int coordoff = 0;
        int normoff = 0;
        int coloroff = 0;
        int texCoordoff = 0;
        int texStride = 0;
        int vAttrOff = 0;
        if ((vformat & 1) != 0) {
            stride += 3;
        }
        if ((vformat & 2) != 0) {
            stride += 3;
            coordoff += 3;
        }
        if ((vformat & 4) != 0) {
            if ((vformat & 0x80) != 0) {
                if ((vformat & 8) != 0) {
                    stride += 4;
                    normoff += 4;
                    coordoff += 4;
                } else {
                    stride += 3;
                    normoff += 3;
                    coordoff += 3;
                }
            } else {
                stride += 4;
                normoff += 4;
                coordoff += 4;
            }
        }
        if ((vformat & 0x460) != 0) {
            if ((vformat & 0x20) != 0) {
                texStride = 2 * texCoordSetCount;
            } else if ((vformat & 0x40) != 0) {
                texStride = 3 * texCoordSetCount;
            } else if ((vformat & 0x400) != 0) {
                texStride = 4 * texCoordSetCount;
            }
            stride += texStride;
            normoff += texStride;
            coloroff += texStride;
            coordoff += texStride;
        }
        int vAttrStride = 0;
        if ((vformat & 0x1000) != 0) {
            for (int i = 0; i < vertexAttrCount; ++i) {
                vAttrStride += vertexAttrSizes[i];
            }
            stride += vAttrStride;
            normoff += vAttrStride;
            coloroff += vAttrStride;
            coordoff += vAttrStride;
            texCoordoff += vAttrStride;
        }
        int bstride = stride * 4;
        int initialOffset = startVIndex * stride;
        normoff += initialOffset;
        coloroff += initialOffset;
        coordoff += initialOffset;
        texCoordoff += initialOffset;
        vAttrOff += initialOffset;
        boolean useAlpha = false;
        if (updateAlpha && !ignoreVertexColors) {
            useAlpha = true;
        }
        if (geo_type == 5 || geo_type == 6 || geo_type == 7) {
            int[] sarray = ((GeometryStripArrayRetained)geo).stripVertexCounts;
            int primType = 0;
            switch (geo_type) {
                case 5: {
                    primType = 5;
                    break;
                }
                case 6: {
                    primType = 6;
                    break;
                }
                case 7: {
                    primType = 3;
                }
            }
            if (ignoreVertexColors) {
                vformat &= 0xFFFFFFFB;
            }
            for (int i = 0; i < sarray.length; ++i) {
                gl.glBegin(primType);
                for (int j = 0; j < sarray[i]; ++j) {
                    if ((vformat & 2) != 0) {
                        if (nxform != null) {
                            float nx = (float)(nxform[0] * (double)varray[normoff] + nxform[1] * (double)varray[normoff + 1] + nxform[2] * (double)varray[normoff + 2]);
                            float ny = (float)(nxform[4] * (double)varray[normoff] + nxform[5] * (double)varray[normoff + 1] + nxform[6] * (double)varray[normoff + 2]);
                            float nz = (float)(nxform[8] * (double)varray[normoff] + nxform[9] * (double)varray[normoff + 1] + nxform[10] * (double)varray[normoff + 2]);
                            gl.glNormal3f(nx, ny, nz);
                        } else {
                            gl.glNormal3f(varray[normoff], varray[normoff + 1], varray[normoff + 2]);
                        }
                    }
                    if ((vformat & 4) != 0) {
                        if (useAlpha) {
                            gl.glColor4f(varray[coloroff], varray[coloroff + 1], varray[coloroff + 2], varray[coloroff + 3] * alpha);
                        } else if ((vformat & 8) != 0) {
                            gl.glColor4f(varray[coloroff], varray[coloroff + 1], varray[coloroff + 2], varray[coloroff + 3]);
                        } else {
                            gl.glColor3f(varray[coloroff], varray[coloroff + 1], varray[coloroff + 2]);
                        }
                    }
                    if ((vformat & 0x1000) != 0) {
                        int vaOff = vAttrOff;
                        if (verts == null) {
                            verts = FloatBuffer.wrap(varray);
                        }
                        for (int vaIdx = 0; vaIdx < vertexAttrCount; ++vaIdx) {
                            switch (vertexAttrSizes[vaIdx]) {
                                case 1: {
                                    verts.position(vaOff);
                                    jctx.vertexAttr1fv((GL)gl, vaIdx, verts);
                                    break;
                                }
                                case 2: {
                                    verts.position(vaOff);
                                    jctx.vertexAttr2fv((GL)gl, vaIdx, verts);
                                    break;
                                }
                                case 3: {
                                    verts.position(vaOff);
                                    jctx.vertexAttr3fv((GL)gl, vaIdx, verts);
                                    break;
                                }
                                case 4: {
                                    verts.position(vaOff);
                                    jctx.vertexAttr4fv((GL)gl, vaIdx, verts);
                                }
                            }
                            vaOff += vertexAttrSizes[vaIdx];
                        }
                    }
                    if ((vformat & 0x460) != 0 && texCoordSetMapLen > 0) {
                        if (gl.isExtensionAvailable("GL_VERSION_1_3")) {
                            if ((vformat & 0x20) != 0) {
                                for (int k = 0; k < texCoordSetMapLen; ++k) {
                                    if (texCoordSetMapOffset[k] == -1) continue;
                                    int off = texCoordoff + texCoordSetMapOffset[k];
                                    gl.glMultiTexCoord2f(33984 + k, varray[off], varray[off + 1]);
                                }
                            } else if ((vformat & 0x40) != 0) {
                                for (int k = 0; k < texCoordSetMapLen; ++k) {
                                    if (texCoordSetMapOffset[k] == -1) continue;
                                    int off = texCoordoff + texCoordSetMapOffset[k];
                                    gl.glMultiTexCoord3f(33984 + k, varray[off], varray[off + 1], varray[off + 2]);
                                }
                            } else {
                                for (int k = 0; k < texCoordSetMapLen; ++k) {
                                    if (texCoordSetMapOffset[k] == -1) continue;
                                    int off = texCoordoff + texCoordSetMapOffset[k];
                                    gl.glMultiTexCoord4f(33984 + k, varray[off], varray[off + 1], varray[off + 2], varray[off + 3]);
                                }
                            }
                        } else if (texCoordSetMapOffset[0] != -1) {
                            int off = texCoordoff + texCoordSetMapOffset[0];
                            if ((vformat & 0x20) != 0) {
                                gl.glTexCoord2f(varray[off], varray[off + 1]);
                            } else if ((vformat & 0x40) != 0) {
                                gl.glTexCoord3f(varray[off], varray[off + 1], varray[off + 2]);
                            } else {
                                gl.glTexCoord4f(varray[off], varray[off + 1], varray[off + 2], varray[off + 3]);
                            }
                        }
                    }
                    if ((vformat & 1) != 0) {
                        if (xform != null) {
                            float w = (float)(xform[12] * (double)varray[coordoff] + xform[13] * (double)varray[coordoff + 1] + xform[14] * (double)varray[coordoff + 2] + xform[15]);
                            float winv = 1.0f / w;
                            float vx = (float)(xform[0] * (double)varray[coordoff] + xform[1] * (double)varray[coordoff + 1] + xform[2] * (double)varray[coordoff + 2] + xform[3]) * winv;
                            float vy = (float)(xform[4] * (double)varray[coordoff] + xform[5] * (double)varray[coordoff + 1] + xform[6] * (double)varray[coordoff + 2] + xform[7]) * winv;
                            float vz = (float)(xform[8] * (double)varray[coordoff] + xform[9] * (double)varray[coordoff + 1] + xform[10] * (double)varray[coordoff + 2] + xform[11]) * winv;
                            gl.glVertex3f(vx, vy, vz);
                        } else {
                            gl.glVertex3f(varray[coordoff], varray[coordoff + 1], varray[coordoff + 2]);
                        }
                    }
                    normoff += stride;
                    coloroff += stride;
                    coordoff += stride;
                    texCoordoff += stride;
                    vAttrOff += stride;
                }
                gl.glEnd();
            }
        } else if (geo_type == 1 || geo_type == 2 || geo_type == 3 || geo_type == 4) {
            int primType = 0;
            switch (geo_type) {
                case 1: {
                    primType = 7;
                    break;
                }
                case 2: {
                    primType = 4;
                    break;
                }
                case 3: {
                    primType = 0;
                    break;
                }
                case 4: {
                    primType = 1;
                }
            }
            if (ignoreVertexColors) {
                vformat &= 0xFFFFFFFB;
            }
            gl.glBegin(primType);
            for (int j = 0; j < vcount; ++j) {
                if ((vformat & 2) != 0) {
                    if (nxform != null) {
                        float nx = (float)(nxform[0] * (double)varray[normoff] + nxform[1] * (double)varray[normoff + 1] + nxform[2] * (double)varray[normoff + 2]);
                        float ny = (float)(nxform[4] * (double)varray[normoff] + nxform[5] * (double)varray[normoff + 1] + nxform[6] * (double)varray[normoff + 2]);
                        float nz = (float)(nxform[8] * (double)varray[normoff] + nxform[9] * (double)varray[normoff + 1] + nxform[10] * (double)varray[normoff + 2]);
                        gl.glNormal3f(nx, ny, nz);
                    } else {
                        gl.glNormal3f(varray[normoff], varray[normoff + 1], varray[normoff + 2]);
                    }
                }
                if ((vformat & 4) != 0) {
                    if (useAlpha) {
                        float ca;
                        float cb;
                        float cg;
                        float cr;
                        if ((vformat & 8) != 0) {
                            cr = varray[coloroff];
                            cg = varray[coloroff + 1];
                            cb = varray[coloroff + 2];
                            ca = varray[coloroff + 3] * alpha;
                        } else {
                            cr = varray[coloroff];
                            cg = varray[coloroff + 1];
                            cb = varray[coloroff + 2];
                            ca = alpha;
                        }
                        gl.glColor4f(cr, cg, cb, ca);
                    } else if ((vformat & 8) != 0) {
                        gl.glColor4f(varray[coloroff], varray[coloroff + 1], varray[coloroff + 2], varray[coloroff + 3]);
                    } else {
                        gl.glColor3f(varray[coloroff], varray[coloroff + 1], varray[coloroff + 2]);
                    }
                }
                if ((vformat & 0x1000) != 0) {
                    int vaOff = vAttrOff;
                    if (verts == null) {
                        verts = FloatBuffer.wrap(varray);
                    }
                    for (int vaIdx = 0; vaIdx < vertexAttrCount; ++vaIdx) {
                        switch (vertexAttrSizes[vaIdx]) {
                            case 1: {
                                verts.position(vaOff);
                                jctx.vertexAttr1fv((GL)gl, vaIdx, verts);
                                break;
                            }
                            case 2: {
                                verts.position(vaOff);
                                jctx.vertexAttr2fv((GL)gl, vaIdx, verts);
                                break;
                            }
                            case 3: {
                                verts.position(vaOff);
                                jctx.vertexAttr3fv((GL)gl, vaIdx, verts);
                                break;
                            }
                            case 4: {
                                verts.position(vaOff);
                                jctx.vertexAttr4fv((GL)gl, vaIdx, verts);
                            }
                        }
                        vaOff += vertexAttrSizes[vaIdx];
                    }
                }
                if ((vformat & 0x460) != 0 && texCoordSetMapLen > 0) {
                    if (gl.isExtensionAvailable("GL_VERSION_1_3")) {
                        if ((vformat & 0x20) != 0) {
                            for (int k = 0; k < texCoordSetMapLen; ++k) {
                                if (texCoordSetMapOffset[k] == -1) continue;
                                int off = texCoordoff + texCoordSetMapOffset[k];
                                gl.glMultiTexCoord2f(33984 + k, varray[off], varray[off + 1]);
                            }
                        } else if ((vformat & 0x40) != 0) {
                            for (int k = 0; k < texCoordSetMapLen; ++k) {
                                if (texCoordSetMapOffset[k] == -1) continue;
                                int off = texCoordoff + texCoordSetMapOffset[k];
                                gl.glMultiTexCoord3f(33984 + k, varray[off], varray[off + 1], varray[off + 2]);
                            }
                        } else {
                            for (int k = 0; k < texCoordSetMapLen; ++k) {
                                if (texCoordSetMapOffset[k] == -1) continue;
                                int off = texCoordoff + texCoordSetMapOffset[k];
                                gl.glMultiTexCoord4f(33984 + k, varray[off], varray[off + 1], varray[off + 2], varray[off + 3]);
                            }
                        }
                    } else if (texCoordSetMapOffset[0] != -1) {
                        int off = texCoordoff + texCoordSetMapOffset[0];
                        if ((vformat & 0x20) != 0) {
                            gl.glTexCoord2f(varray[off], varray[off + 1]);
                        } else if ((vformat & 0x40) != 0) {
                            gl.glTexCoord3f(varray[off], varray[off + 1], varray[off + 2]);
                        } else {
                            gl.glTexCoord4f(varray[off], varray[off + 1], varray[off + 2], varray[off + 3]);
                        }
                    }
                }
                if ((vformat & 1) != 0) {
                    if (xform != null) {
                        float w = (float)(xform[12] * (double)varray[coordoff] + xform[13] * (double)varray[coordoff + 1] + xform[14] * (double)varray[coordoff + 2] + xform[15]);
                        float winv = 1.0f / w;
                        float vx = (float)(xform[0] * (double)varray[coordoff] + xform[1] * (double)varray[coordoff + 1] + xform[2] * (double)varray[coordoff + 2] + xform[3]) * winv;
                        float vy = (float)(xform[4] * (double)varray[coordoff] + xform[5] * (double)varray[coordoff + 1] + xform[6] * (double)varray[coordoff + 2] + xform[7]) * winv;
                        float vz = (float)(xform[8] * (double)varray[coordoff] + xform[9] * (double)varray[coordoff + 1] + xform[10] * (double)varray[coordoff + 2] + xform[11]) * winv;
                        gl.glVertex3f(vx, vy, vz);
                    } else {
                        gl.glVertex3f(varray[coordoff], varray[coordoff + 1], varray[coordoff + 2]);
                    }
                }
                normoff += stride;
                coloroff += stride;
                coordoff += stride;
                texCoordoff += stride;
                vAttrOff += stride;
            }
            gl.glEnd();
        }
    }

    @Override
    void buildGAForByRef(Context ctx, GeometryArrayRetained geo, int geo_type, boolean isNonUniformScale, boolean updateAlpha, float alpha, boolean ignoreVertexColors, int vcount, int vformat, int vdefined, int initialCoordIndex, float[] vfcoords, double[] vdcoords, int initialColorIndex, float[] cfdata, byte[] cbdata, int initialNormalIndex, float[] ndata, int vertexAttrCount, int[] vertexAttrSizes, int[] vertexAttrIndices, float[][] vertexAttrData, int texCoordMapLength, int[] tcoordsetmap, int[] texIndices, int texStride, Object[] texCoords, double[] xform, double[] nxform) {
        int i;
        int k;
        int i2;
        GL2 gl = this.context(ctx).getGL().getGL2();
        boolean floatCoordDefined = (vdefined & 1) != 0;
        boolean doubleCoordDefined = (vdefined & 2) != 0;
        boolean floatColorsDefined = (vdefined & 4) != 0;
        boolean byteColorsDefined = (vdefined & 8) != 0;
        boolean normalsDefined = (vdefined & 0x10) != 0;
        boolean vattrDefined = (vdefined & 0x40) != 0;
        boolean textureDefined = (vdefined & 0x20) != 0;
        FloatBuffer fverts = null;
        DoubleBuffer dverts = null;
        FloatBuffer fclrs = null;
        ByteBuffer bclrs = null;
        FloatBuffer[] texCoordBufs = null;
        FloatBuffer norms = null;
        FloatBuffer[] vertexAttrBufs = null;
        if (vattrDefined) {
            vertexAttrBufs = JoglPipeline.getVertexAttrSetBuffer((Object[])vertexAttrData);
        }
        if (textureDefined) {
            texCoordBufs = JoglPipeline.getTexCoordSetBuffer(texCoords);
        }
        boolean useAlpha = false;
        if (updateAlpha && !ignoreVertexColors) {
            useAlpha = true;
        }
        int[] sarray = null;
        int[] start_array = null;
        int strip_len = 0;
        if (geo_type == 5 || geo_type == 6 || geo_type == 7) {
            sarray = ((GeometryStripArrayRetained)geo).stripVertexCounts;
            strip_len = sarray.length;
            start_array = ((GeometryStripArrayRetained)geo).stripStartOffsetIndices;
        }
        if (ignoreVertexColors) {
            vformat &= 0xFFFFFFFB;
            floatColorsDefined = false;
            byteColorsDefined = false;
        }
        if (floatCoordDefined) {
            gl.glEnableClientState(32884);
            fverts = JoglPipeline.getVertexArrayBuffer(vfcoords, xform == null);
            if (xform != null) {
                for (i2 = initialCoordIndex; i2 < vcount * 3; i2 += 3) {
                    fverts.put(i2, (float)(xform[0] * (double)vfcoords[i2] + xform[1] * (double)vfcoords[i2 + 1] + xform[2] * (double)vfcoords[i2 + 2]));
                    fverts.put(i2 + 1, (float)(xform[4] * (double)vfcoords[i2] + xform[5] * (double)vfcoords[i2 + 1] + xform[6] * (double)vfcoords[i2 + 2]));
                    fverts.put(i2 + 2, (float)(xform[8] * (double)vfcoords[i2] + xform[9] * (double)vfcoords[i2 + 1] + xform[10] * (double)vfcoords[i2 + 2]));
                }
            }
        } else if (doubleCoordDefined) {
            gl.glEnableClientState(32884);
            dverts = JoglPipeline.getVertexArrayBuffer(vdcoords, xform == null);
            if (xform != null) {
                for (i2 = initialCoordIndex; i2 < vcount * 3; i2 += 3) {
                    dverts.put(i2, xform[0] * vdcoords[i2] + xform[1] * vdcoords[i2 + 1] + xform[2] * vdcoords[i2 + 2]);
                    dverts.put(i2 + 1, xform[4] * vdcoords[i2] + xform[5] * vdcoords[i2 + 1] + xform[6] * vdcoords[i2 + 2]);
                    dverts.put(i2 + 2, xform[8] * vdcoords[i2] + xform[9] * vdcoords[i2 + 1] + xform[10] * vdcoords[i2 + 2]);
                }
            }
        } else {
            gl.glDisableClientState(32884);
        }
        if (floatColorsDefined) {
            gl.glEnableClientState(32886);
            fclrs = JoglPipeline.getColorArrayBuffer(cfdata, !useAlpha);
            if (useAlpha) {
                if ((vformat & 8) != 0) {
                    for (i2 = initialColorIndex; i2 < vcount * 4; i2 += 4) {
                        fclrs.put(i2, cfdata[i2]);
                        fclrs.put(i2 + 1, cfdata[i2 + 1]);
                        fclrs.put(i2 + 2, cfdata[i2 + 2]);
                        fclrs.put(i2 + 3, alpha * cfdata[i2 + 3]);
                    }
                } else {
                    k = 0;
                    for (i = initialColorIndex; i < vcount * 4; i += 4) {
                        fclrs.put(i, cfdata[k++]);
                        fclrs.put(i + 1, cfdata[k++]);
                        fclrs.put(i + 2, cfdata[k++]);
                        fclrs.put(i + 3, alpha);
                    }
                }
                vformat |= 8;
            }
        } else if (byteColorsDefined) {
            gl.glEnableClientState(32886);
            bclrs = JoglPipeline.getColorArrayBuffer(cbdata, !useAlpha);
            if (useAlpha) {
                if ((vformat & 8) != 0) {
                    for (i2 = initialColorIndex; i2 < vcount * 4; i2 += 4) {
                        bclrs.put(i2, cbdata[i2]);
                        bclrs.put(i2 + 1, cbdata[i2 + 1]);
                        bclrs.put(i2 + 2, cbdata[i2 + 2]);
                        bclrs.put(i2 + 3, (byte)(alpha * (float)(cbdata[i2 + 3] & 0xFF)));
                    }
                } else {
                    k = 0;
                    for (i = initialColorIndex; i < vcount * 4; i += 4) {
                        bclrs.put(i, cbdata[k++]);
                        bclrs.put(i + 1, cbdata[k++]);
                        bclrs.put(i + 2, cbdata[k++]);
                        bclrs.put(i + 3, (byte)(alpha * 255.0f));
                    }
                }
                vformat |= 8;
            }
        } else {
            gl.glDisableClientState(32886);
        }
        if (normalsDefined) {
            gl.glEnableClientState(32885);
            norms = JoglPipeline.getNormalArrayBuffer(ndata, nxform == null);
            if (nxform != null) {
                for (i2 = initialNormalIndex; i2 < vcount * 3; i2 += 3) {
                    norms.put(i2, (float)(nxform[0] * (double)ndata[i2] + nxform[1] * (double)ndata[i2 + 1] + nxform[2] * (double)ndata[i2 + 2]));
                    norms.put(i2 + 1, (float)(nxform[4] * (double)ndata[i2] + nxform[5] * (double)ndata[i2 + 1] + nxform[6] * (double)ndata[i2 + 2]));
                    norms.put(i2 + 2, (float)(nxform[8] * (double)ndata[i2] + nxform[9] * (double)ndata[i2 + 1] + nxform[10] * (double)ndata[i2 + 2]));
                }
            }
        } else {
            gl.glDisableClientState(32885);
        }
        this.executeGeometryArrayVA(ctx, geo, geo_type, isNonUniformScale, ignoreVertexColors, vcount, vformat, vdefined, initialCoordIndex, fverts, dverts, initialColorIndex, fclrs, bclrs, initialNormalIndex, norms, vertexAttrCount, vertexAttrSizes, vertexAttrIndices, vertexAttrBufs, texCoordMapLength, tcoordsetmap, texCoordMapLength, texIndices, texStride, texCoordBufs, 0, sarray, strip_len, start_array);
    }

    private void testForInterleavedArrays(int vformat, boolean[] useInterleavedArrays, int[] iaFormat) {
        useInterleavedArrays[0] = true;
        switch (vformat) {
            case 1: {
                iaFormat[0] = 10785;
                break;
            }
            case 3: {
                iaFormat[0] = 10789;
                break;
            }
            case 33: {
                iaFormat[0] = 10791;
                break;
            }
            case 7: 
            case 15: {
                iaFormat[0] = 10790;
                break;
            }
            case 35: {
                iaFormat[0] = 10795;
                break;
            }
            case 39: 
            case 47: {
                iaFormat[0] = 10796;
                break;
            }
            default: {
                useInterleavedArrays[0] = false;
            }
        }
    }

    private void enableTexCoordPointer(GL2 gl, int texUnit, int texSize, int texDataType, int stride, Buffer pointer) {
        this.clientActiveTextureUnit(gl, texUnit);
        gl.glEnableClientState(32888);
        gl.glTexCoordPointer(texSize, texDataType, stride, pointer);
    }

    private void disableTexCoordPointer(GL2 gl, int texUnit) {
        this.clientActiveTextureUnit(gl, texUnit);
        gl.glDisableClientState(32888);
    }

    private void clientActiveTextureUnit(GL2 gl, int texUnit) {
        if (gl.isExtensionAvailable("GL_VERSION_1_3")) {
            gl.glClientActiveTexture(texUnit + 33984);
        }
    }

    private void executeTexture(int texCoordSetMapLen, int texSize, int bstride, int texCoordoff, int[] texCoordSetMapOffset, int numActiveTexUnit, FloatBuffer verts, GL2 gl) {
        int tus = 0;
        for (int i = 0; i < numActiveTexUnit; ++i) {
            tus = i;
            if (tus < texCoordSetMapLen && texCoordSetMapOffset[tus] != -1) {
                verts.position(texCoordoff + texCoordSetMapOffset[tus]);
                this.enableTexCoordPointer(gl, i, texSize, 5126, bstride, verts);
                continue;
            }
            this.disableTexCoordPointer(gl, i);
        }
    }

    private void resetTexture(GL2 gl, JoglContext ctx) {
        for (int i = 0; i < ctx.getMaxTexCoordSets(); ++i) {
            this.disableTexCoordPointer(gl, i);
        }
        this.clientActiveTextureUnit(gl, 0);
    }

    private void executeGeometryArray(Context absCtx, GeometryArrayRetained geo, int geo_type, boolean isNonUniformScale, boolean useAlpha, boolean ignoreVertexColors, int startVIndex, int vcount, int vformat, int texCoordSetCount, int[] texCoordSetMap, int texCoordSetMapLen, int[] texCoordSetMapOffset, int numActiveTexUnitState, int vertexAttrCount, int[] vertexAttrSizes, float[] varray, FloatBuffer varrayBuffer, float[] carray, int cDirty) {
        JoglContext ctx = (JoglContext)absCtx;
        GLContext context = this.context(ctx);
        GL2 gl = context.getGL().getGL2();
        int iaFormat = 0;
        int primType = 0;
        int stride = 0;
        int coordoff = 0;
        int normoff = 0;
        int coloroff = 0;
        int texCoordoff = 0;
        int texSize = 0;
        int texStride = 0;
        int vAttrOff = 0;
        int vAttrStride = 0;
        int bstride = 0;
        int cbstride = 0;
        FloatBuffer verts = null;
        FloatBuffer clrs = null;
        int[] sarray = null;
        int[] start_array = null;
        if ((vformat & 1) != 0) {
            stride += 3;
        }
        if ((vformat & 2) != 0) {
            stride += 3;
            coordoff += 3;
        }
        if ((vformat & 4) != 0) {
            if ((vformat & 8) != 0) {
                stride += 4;
                normoff += 4;
                coordoff += 4;
            } else {
                stride += 3;
                normoff += 3;
                coordoff += 3;
            }
        }
        if ((vformat & 0x460) != 0) {
            if ((vformat & 0x20) != 0) {
                texSize = 2;
                texStride = 2 * texCoordSetCount;
            } else if ((vformat & 0x40) != 0) {
                texSize = 3;
                texStride = 3 * texCoordSetCount;
            } else if ((vformat & 0x400) != 0) {
                texSize = 4;
                texStride = 4 * texCoordSetCount;
            }
            stride += texStride;
            normoff += texStride;
            coloroff += texStride;
            coordoff += texStride;
        }
        if ((vformat & 0x1000) != 0) {
            for (int i = 0; i < vertexAttrCount; ++i) {
                vAttrStride += vertexAttrSizes[i];
            }
            stride += vAttrStride;
            normoff += vAttrStride;
            coloroff += vAttrStride;
            coordoff += vAttrStride;
            texCoordoff += vAttrStride;
        }
        bstride = stride * 4;
        if (geo_type == 5 || geo_type == 6 || geo_type == 7) {
            sarray = ((GeometryStripArrayRetained)geo).stripVertexCounts;
            start_array = ((GeometryStripArrayRetained)geo).stripStartOffsetIndices;
        }
        if (varray != null) {
            verts = JoglPipeline.getVertexArrayBuffer(varray);
        } else if (varrayBuffer != null) {
            verts = varrayBuffer;
        } else {
            throw new AssertionError((Object)"Unable to get vertex pointer");
        }
        int cstride = stride;
        if (carray != null) {
            clrs = JoglPipeline.getColorArrayBuffer(carray);
            cstride = 4;
        } else {
            clrs = verts;
        }
        cbstride = cstride * 4;
        if (isNonUniformScale) {
            gl.glEnable(2977);
        }
        int startVertex = stride * startVIndex;
        int startClrs = cstride * startVIndex;
        if (clrs == verts) {
            startClrs += coloroff;
        }
        if (geo_type == 5 || geo_type == 6 || geo_type == 7) {
            boolean useInterleavedArrays;
            if (ignoreVertexColors || carray != null || (vformat & 0x460) != 0 && (texCoordSetMapLen > 1 || texCoordSetCount > 1)) {
                useInterleavedArrays = false;
            } else {
                boolean[] tmp = new boolean[1];
                int[] tmp2 = new int[1];
                this.testForInterleavedArrays(vformat, tmp, tmp2);
                useInterleavedArrays = tmp[0];
                iaFormat = tmp2[0];
            }
            if (useInterleavedArrays) {
                verts.position(startVertex);
                gl.glInterleavedArrays(iaFormat, bstride, (Buffer)verts);
            } else {
                if ((vformat & 2) != 0) {
                    verts.position(startVertex + normoff);
                    gl.glNormalPointer(5126, bstride, (Buffer)verts);
                }
                if (!ignoreVertexColors && (vformat & 4) != 0) {
                    clrs.position(startClrs);
                    if ((vformat & 8) != 0 || useAlpha) {
                        gl.glColorPointer(4, 5126, cbstride, (Buffer)clrs);
                    } else {
                        gl.glColorPointer(3, 5126, cbstride, (Buffer)clrs);
                    }
                }
                if ((vformat & 1) != 0) {
                    verts.position(startVertex + coordoff);
                    gl.glVertexPointer(3, 5126, bstride, (Buffer)verts);
                }
                if ((vformat & 0x460) != 0) {
                    this.executeTexture(texCoordSetMapLen, texSize, bstride, texCoordoff, texCoordSetMapOffset, numActiveTexUnitState, verts, gl);
                }
                if ((vformat & 0x1000) != 0) {
                    int vAttrOffset = startVertex + vAttrOff;
                    for (int i = 0; i < vertexAttrCount; ++i) {
                        ctx.enableVertexAttrArray((GL)gl, i);
                        verts.position(vAttrOffset);
                        ctx.vertexAttrPointer((GL)gl, i, vertexAttrSizes[i], 5126, bstride, verts);
                        vAttrOffset += vertexAttrSizes[i];
                    }
                }
            }
            switch (geo_type) {
                case 5: {
                    primType = 5;
                    break;
                }
                case 6: {
                    primType = 6;
                    break;
                }
                case 7: {
                    primType = 3;
                }
            }
            if (gl.isExtensionAvailable("GL_EXT_multi_draw_arrays")) {
                gl.glMultiDrawArrays(primType, start_array, 0, sarray, 0, sarray.length);
            } else {
                for (int i = 0; i < sarray.length; ++i) {
                    gl.glDrawArrays(primType, start_array[i], sarray[i]);
                }
            }
        } else if (geo_type == 1 || geo_type == 2 || geo_type == 3 || geo_type == 4) {
            boolean useInterleavedArrays;
            if (ignoreVertexColors || carray != null || (vformat & 0x460) != 0 && (texCoordSetMapLen > 1 || texCoordSetCount > 1)) {
                useInterleavedArrays = false;
            } else {
                boolean[] tmp = new boolean[1];
                int[] tmp2 = new int[1];
                this.testForInterleavedArrays(vformat, tmp, tmp2);
                useInterleavedArrays = tmp[0];
                iaFormat = tmp2[0];
            }
            if (useInterleavedArrays) {
                verts.position(startVertex);
                gl.glInterleavedArrays(iaFormat, bstride, (Buffer)verts);
            } else {
                if ((vformat & 2) != 0) {
                    verts.position(startVertex + normoff);
                    gl.glNormalPointer(5126, bstride, (Buffer)verts);
                }
                if (!ignoreVertexColors && (vformat & 4) != 0) {
                    clrs.position(startClrs);
                    if ((vformat & 8) != 0 || useAlpha) {
                        gl.glColorPointer(4, 5126, cbstride, (Buffer)clrs);
                    } else {
                        gl.glColorPointer(3, 5126, cbstride, (Buffer)clrs);
                    }
                }
                if ((vformat & 1) != 0) {
                    verts.position(startVertex + coordoff);
                    gl.glVertexPointer(3, 5126, bstride, (Buffer)verts);
                }
                if ((vformat & 0x460) != 0) {
                    this.executeTexture(texCoordSetMapLen, texSize, bstride, texCoordoff, texCoordSetMapOffset, numActiveTexUnitState, verts, gl);
                }
                if ((vformat & 0x1000) != 0) {
                    int vAttrOffset = startVertex + vAttrOff;
                    for (int i = 0; i < vertexAttrCount; ++i) {
                        ctx.enableVertexAttrArray((GL)gl, i);
                        verts.position(vAttrOffset);
                        ctx.vertexAttrPointer((GL)gl, i, vertexAttrSizes[i], 5126, bstride, verts);
                        vAttrOffset += vertexAttrSizes[i];
                    }
                }
            }
            switch (geo_type) {
                case 1: {
                    gl.glDrawArrays(7, 0, vcount);
                    break;
                }
                case 2: {
                    gl.glDrawArrays(4, 0, vcount);
                    break;
                }
                case 3: {
                    gl.glDrawArrays(0, 0, vcount);
                    break;
                }
                case 4: {
                    gl.glDrawArrays(1, 0, vcount);
                }
            }
        }
        if (isNonUniformScale) {
            gl.glDisable(2977);
        }
        if ((vformat & 0x1000) != 0) {
            this.resetVertexAttrs((GL)gl, ctx, vertexAttrCount);
        }
        if ((vformat & 0x460) != 0) {
            this.resetTexture(gl, ctx);
        }
    }

    private void lockArray(GL2 gl, int vertexCount) {
        if (gl.isExtensionAvailable("GL_EXT_compiled_vertex_array")) {
            gl.glLockArraysEXT(0, vertexCount);
        }
    }

    private void unlockArray(GL2 gl) {
        if (gl.isExtensionAvailable("GL_EXT_compiled_vertex_array")) {
            gl.glUnlockArraysEXT();
        }
    }

    private void executeGeometryArrayVA(Context absCtx, GeometryArrayRetained geo, int geo_type, boolean isNonUniformScale, boolean ignoreVertexColors, int vcount, int vformat, int vdefined, int initialCoordIndex, FloatBuffer fverts, DoubleBuffer dverts, int initialColorIndex, FloatBuffer fclrs, ByteBuffer bclrs, int initialNormalIndex, FloatBuffer norms, int vertexAttrCount, int[] vertexAttrSizes, int[] vertexAttrIndices, FloatBuffer[] vertexAttrData, int texCoordMapLength, int[] texCoordSetMap, int numActiveTexUnit, int[] texindices, int texStride, FloatBuffer[] texCoords, int cdirty, int[] sarray, int strip_len, int[] start_array) {
        int i;
        int sz;
        int coloroff;
        boolean textureDefined;
        JoglContext ctx = (JoglContext)absCtx;
        GLContext context = this.context(ctx);
        GL2 gl = context.getGL().getGL2();
        boolean floatCoordDefined = (vdefined & 1) != 0;
        boolean doubleCoordDefined = (vdefined & 2) != 0;
        boolean floatColorsDefined = (vdefined & 4) != 0;
        boolean byteColorsDefined = (vdefined & 8) != 0;
        boolean normalsDefined = (vdefined & 0x10) != 0;
        boolean vattrDefined = (vdefined & 0x40) != 0;
        boolean bl = textureDefined = (vdefined & 0x20) != 0;
        if (isNonUniformScale) {
            gl.glEnable(2977);
        }
        int coordoff = 3 * initialCoordIndex;
        if (floatCoordDefined) {
            fverts.position(coordoff);
            gl.glVertexPointer(3, 5126, 0, (Buffer)fverts);
        } else if (doubleCoordDefined) {
            dverts.position(coordoff);
            gl.glVertexPointer(3, 5130, 0, (Buffer)dverts);
        }
        if (floatColorsDefined) {
            if ((vformat & 8) != 0) {
                coloroff = 4 * initialColorIndex;
                sz = 4;
            } else {
                coloroff = 3 * initialColorIndex;
                sz = 3;
            }
            fclrs.position(coloroff);
            gl.glColorPointer(sz, 5126, 0, (Buffer)fclrs);
        } else if (byteColorsDefined) {
            if ((vformat & 8) != 0) {
                coloroff = 4 * initialColorIndex;
                sz = 4;
            } else {
                coloroff = 3 * initialColorIndex;
                sz = 3;
            }
            bclrs.position(coloroff);
            gl.glColorPointer(sz, 5121, 0, (Buffer)bclrs);
        }
        if (normalsDefined) {
            int normoff = 3 * initialNormalIndex;
            norms.position(normoff);
            gl.glNormalPointer(5126, 0, (Buffer)norms);
        }
        if (vattrDefined) {
            for (int i2 = 0; i2 < vertexAttrCount; ++i2) {
                FloatBuffer vertexAttrs = vertexAttrData[i2];
                int sz2 = vertexAttrSizes[i2];
                int initIdx = vertexAttrIndices[i2];
                ctx.enableVertexAttrArray((GL)gl, i2);
                vertexAttrs.position(initIdx * sz2);
                ctx.vertexAttrPointer((GL)gl, i2, sz2, 5126, 0, vertexAttrs);
            }
        }
        if (textureDefined) {
            int texSet = 0;
            for (i = 0; i < numActiveTexUnit; ++i) {
                if (i < texCoordMapLength && (texSet = texCoordSetMap[i]) != -1) {
                    FloatBuffer buf = texCoords[texSet];
                    buf.position(texStride * texindices[texSet]);
                    this.enableTexCoordPointer(gl, i, texStride, 5126, 0, buf);
                    continue;
                }
                this.disableTexCoordPointer(gl, i);
            }
            this.clientActiveTextureUnit(gl, 0);
        }
        if (geo_type == 5 || geo_type == 6 || geo_type == 7) {
            int primType = 0;
            switch (geo_type) {
                case 5: {
                    primType = 5;
                    break;
                }
                case 6: {
                    primType = 6;
                    break;
                }
                case 7: {
                    primType = 3;
                }
            }
            if (gl.isExtensionAvailable("GL_EXT_multi_draw_arrays")) {
                gl.glMultiDrawArrays(primType, start_array, 0, sarray, 0, strip_len);
            } else if (gl.isExtensionAvailable("GL_VERSION_1_4")) {
                gl.glMultiDrawArrays(primType, start_array, 0, sarray, 0, strip_len);
            } else {
                for (i = 0; i < strip_len; ++i) {
                    gl.glDrawArrays(primType, start_array[i], sarray[i]);
                }
            }
        } else {
            switch (geo_type) {
                case 1: {
                    gl.glDrawArrays(7, 0, vcount);
                    break;
                }
                case 2: {
                    gl.glDrawArrays(4, 0, vcount);
                    break;
                }
                case 3: {
                    gl.glDrawArrays(0, 0, vcount);
                    break;
                }
                case 4: {
                    gl.glDrawArrays(1, 0, vcount);
                }
            }
        }
        if (isNonUniformScale) {
            gl.glDisable(2977);
        }
        if (vattrDefined) {
            this.resetVertexAttrs((GL)gl, ctx, vertexAttrCount);
        }
        if (textureDefined) {
            this.resetTexture(gl, ctx);
        }
    }

    private String getVertexDescription(int vformat) {
        String res = "";
        if ((vformat & 1) != 0) {
            res = res + "COORDINATES ";
        }
        if ((vformat & 2) != 0) {
            res = res + "NORMALS ";
        }
        if ((vformat & 4) != 0) {
            res = res + "COLOR ";
        }
        if ((vformat & 8) != 0) {
            res = res + "(WITH_ALPHA) ";
        }
        if ((vformat & 0x460) != 0) {
            res = res + "TEXTURE_COORDINATE ";
        }
        if ((vformat & 0x20) != 0) {
            res = res + "(2) ";
        }
        if ((vformat & 0x40) != 0) {
            res = res + "(3) ";
        }
        if ((vformat & 0x400) != 0) {
            res = res + "(4) ";
        }
        if ((vformat & 0x1000) != 0) {
            res = res + "VERTEX_ATTRIBUTES ";
        }
        return res;
    }

    private String getGeometryDescription(int geo_type) {
        switch (geo_type) {
            case 5: {
                return "GEO_TYPE_TRI_STRIP_SET";
            }
            case 6: {
                return "GEO_TYPE_TRI_FAN_SET";
            }
            case 7: {
                return "GEO_TYPE_LINE_STRIP_SET";
            }
            case 1: {
                return "GEO_TYPE_QUAD_SET";
            }
            case 2: {
                return "GEO_TYPE_TRI_SET";
            }
            case 3: {
                return "GEO_TYPE_POINT_SET";
            }
            case 4: {
                return "GEO_TYPE_LINE_SET";
            }
        }
        return "(unknown " + geo_type + ")";
    }

    private void resetVertexAttrs(GL gl, JoglContext ctx, int vertexAttrCount) {
        for (int i = 0; i < vertexAttrCount; ++i) {
            ctx.disableVertexAttrArray(gl, i);
        }
    }

    @Override
    void executeIndexedGeometry(Context ctx, GeometryArrayRetained geo, int geo_type, boolean isNonUniformScale, boolean useAlpha, boolean ignoreVertexColors, int initialIndexIndex, int indexCount, int vertexCount, int vformat, int vertexAttrCount, int[] vertexAttrSizes, int texCoordSetCount, int[] texCoordSetMap, int texCoordSetMapLen, int[] texCoordSetOffset, int numActiveTexUnitState, float[] varray, float[] carray, int cdirty, int[] indexCoord) {
        this.executeIndexedGeometryArray(ctx, geo, geo_type, isNonUniformScale, useAlpha, ignoreVertexColors, initialIndexIndex, indexCount, vertexCount, vformat, vertexAttrCount, vertexAttrSizes, texCoordSetCount, texCoordSetMap, texCoordSetMapLen, texCoordSetOffset, numActiveTexUnitState, varray, null, carray, cdirty, indexCoord);
    }

    @Override
    void executeIndexedGeometryBuffer(Context ctx, GeometryArrayRetained geo, int geo_type, boolean isNonUniformScale, boolean useAlpha, boolean ignoreVertexColors, int initialIndexIndex, int indexCount, int vertexCount, int vformat, int texCoordSetCount, int[] texCoordSetMap, int texCoordSetMapLen, int[] texCoordSetOffset, int numActiveTexUnitState, FloatBuffer vdata, float[] carray, int cDirty, int[] indexCoord) {
        this.executeIndexedGeometryArray(ctx, geo, geo_type, isNonUniformScale, useAlpha, ignoreVertexColors, initialIndexIndex, indexCount, vertexCount, vformat, 0, null, texCoordSetCount, texCoordSetMap, texCoordSetMapLen, texCoordSetOffset, numActiveTexUnitState, null, vdata, carray, cDirty, indexCoord);
    }

    @Override
    void executeIndexedGeometryVA(Context ctx, GeometryArrayRetained geo, int geo_type, boolean isNonUniformScale, boolean ignoreVertexColors, int initialIndexIndex, int validIndexCount, int vertexCount, int vformat, int vdefined, float[] vfcoords, double[] vdcoords, float[] cfdata, byte[] cbdata, float[] ndata, int vertexAttrCount, int[] vertexAttrSizes, float[][] vertexAttrData, int texCoordMapLength, int[] texcoordoffset, int numActiveTexUnitState, int texStride, Object[] texCoords, int cdirty, int[] indexCoord) {
        boolean floatCoordDefined = (vdefined & 1) != 0;
        boolean doubleCoordDefined = (vdefined & 2) != 0;
        boolean floatColorsDefined = (vdefined & 4) != 0;
        boolean byteColorsDefined = (vdefined & 8) != 0;
        boolean normalsDefined = (vdefined & 0x10) != 0;
        boolean vattrDefined = (vdefined & 0x40) != 0;
        boolean textureDefined = (vdefined & 0x20) != 0;
        FloatBuffer fverts = null;
        DoubleBuffer dverts = null;
        FloatBuffer fclrs = null;
        ByteBuffer bclrs = null;
        FloatBuffer[] texCoordBufs = null;
        FloatBuffer norms = null;
        FloatBuffer[] vertexAttrBufs = null;
        if (vattrDefined) {
            vertexAttrBufs = JoglPipeline.getVertexAttrSetBuffer((Object[])vertexAttrData);
        }
        if (textureDefined) {
            texCoordBufs = JoglPipeline.getTexCoordSetBuffer(texCoords);
        }
        int[] sarray = null;
        int strip_len = 0;
        if (geo_type == 12 || geo_type == 13 || geo_type == 14) {
            sarray = ((IndexedGeometryStripArrayRetained)geo).stripIndexCounts;
            strip_len = sarray.length;
        }
        if (floatCoordDefined) {
            fverts = JoglPipeline.getVertexArrayBuffer(vfcoords);
        } else if (doubleCoordDefined) {
            dverts = JoglPipeline.getVertexArrayBuffer(vdcoords);
        }
        if (floatColorsDefined) {
            fclrs = JoglPipeline.getColorArrayBuffer(cfdata);
        } else if (byteColorsDefined) {
            bclrs = JoglPipeline.getColorArrayBuffer(cbdata);
        }
        if (normalsDefined) {
            norms = JoglPipeline.getNormalArrayBuffer(ndata);
        }
        this.executeIndexedGeometryArrayVA(ctx, geo, geo_type, isNonUniformScale, ignoreVertexColors, initialIndexIndex, validIndexCount, vertexCount, vformat, vdefined, fverts, dverts, fclrs, bclrs, norms, vertexAttrCount, vertexAttrSizes, vertexAttrBufs, texCoordMapLength, texcoordoffset, numActiveTexUnitState, texStride, texCoordBufs, cdirty, indexCoord, sarray, strip_len);
    }

    @Override
    void executeIndexedGeometryVABuffer(Context ctx, GeometryArrayRetained geo, int geo_type, boolean isNonUniformScale, boolean ignoreVertexColors, int initialIndexIndex, int validIndexCount, int vertexCount, int vformat, int vdefined, Buffer vcoords, Buffer cdataBuffer, float[] cfdata, byte[] cbdata, FloatBuffer ndata, int vertexAttrCount, int[] vertexAttrSizes, FloatBuffer[] vertexAttrData, int texCoordMapLength, int[] texcoordoffset, int numActiveTexUnitState, int texStride, Object[] texCoords, int cdirty, int[] indexCoord) {
        boolean floatCoordDefined = (vdefined & 1) != 0;
        boolean doubleCoordDefined = (vdefined & 2) != 0;
        boolean floatColorsDefined = (vdefined & 4) != 0;
        boolean byteColorsDefined = (vdefined & 8) != 0;
        boolean normalsDefined = (vdefined & 0x10) != 0;
        boolean vattrDefined = (vdefined & 0x40) != 0;
        boolean textureDefined = (vdefined & 0x20) != 0;
        FloatBuffer fverts = null;
        DoubleBuffer dverts = null;
        FloatBuffer fclrs = null;
        ByteBuffer bclrs = null;
        FloatBuffer[] texCoordBufs = null;
        FloatBuffer norms = null;
        FloatBuffer[] vertexAttrBufs = null;
        if (vattrDefined) {
            vertexAttrBufs = vertexAttrData;
        }
        if (textureDefined) {
            texCoordBufs = new FloatBuffer[texCoords.length];
            for (int i = 0; i < texCoords.length; ++i) {
                texCoordBufs[i] = (FloatBuffer)texCoords[i];
            }
        }
        if (floatCoordDefined) {
            fverts = (FloatBuffer)vcoords;
        } else if (doubleCoordDefined) {
            dverts = (DoubleBuffer)vcoords;
        }
        if (fverts == null && dverts == null) {
            return;
        }
        int[] sarray = null;
        int strip_len = 0;
        if (geo_type == 12 || geo_type == 13 || geo_type == 14) {
            sarray = ((IndexedGeometryStripArrayRetained)geo).stripIndexCounts;
            strip_len = sarray.length;
        }
        if (floatColorsDefined) {
            fclrs = cfdata != null ? JoglPipeline.getColorArrayBuffer(cfdata) : (FloatBuffer)cdataBuffer;
        } else if (byteColorsDefined) {
            bclrs = cbdata != null ? JoglPipeline.getColorArrayBuffer(cbdata) : (ByteBuffer)cdataBuffer;
        }
        if (normalsDefined) {
            norms = ndata;
        }
        this.executeIndexedGeometryArrayVA(ctx, geo, geo_type, isNonUniformScale, ignoreVertexColors, initialIndexIndex, validIndexCount, vertexCount, vformat, vdefined, fverts, dverts, fclrs, bclrs, norms, vertexAttrCount, vertexAttrSizes, vertexAttrBufs, texCoordMapLength, texcoordoffset, numActiveTexUnitState, texStride, texCoordBufs, cdirty, indexCoord, sarray, strip_len);
    }

    @Override
    void buildIndexedGeometry(Context absCtx, GeometryArrayRetained geo, int geo_type, boolean isNonUniformScale, boolean updateAlpha, float alpha, boolean ignoreVertexColors, int initialIndexIndex, int validIndexCount, int vertexCount, int vformat, int vertexAttrCount, int[] vertexAttrSizes, int texCoordSetCount, int[] texCoordSetMap, int texCoordSetMapLen, int[] texCoordSetMapOffset, double[] xform, double[] nxform, float[] varray, int[] indexCoord) {
        int i;
        int off;
        JoglContext ctx = (JoglContext)absCtx;
        GL2 gl = this.context(ctx).getGL().getGL2();
        int iaFormat = 0;
        int primType = 0;
        int stride = 0;
        int coordoff = 0;
        int normoff = 0;
        int coloroff = 0;
        int texCoordoff = 0;
        int texSize = 0;
        int texStride = 0;
        int vAttrOff = 0;
        int vAttrStride = 0;
        int bstride = 0;
        boolean cbstride = false;
        FloatBuffer verts = null;
        Object clrs = null;
        int[] sarray = null;
        int strip_len = 0;
        boolean useAlpha = false;
        if ((vformat & 1) != 0) {
            gl.glEnableClientState(32884);
            stride += 3;
        } else {
            gl.glDisableClientState(32884);
        }
        if ((vformat & 2) != 0) {
            gl.glEnableClientState(32885);
            stride += 3;
            coordoff += 3;
        } else {
            gl.glDisableClientState(32885);
        }
        if ((vformat & 4) != 0) {
            gl.glEnableClientState(32886);
            stride += 4;
            normoff += 4;
            coordoff += 4;
        } else {
            gl.glDisableClientState(32886);
        }
        if ((vformat & 0x460) != 0) {
            if ((vformat & 0x20) != 0) {
                texSize = 2;
                texStride = 2 * texCoordSetCount;
            } else if ((vformat & 0x40) != 0) {
                texSize = 3;
                texStride = 3 * texCoordSetCount;
            } else if ((vformat & 0x400) != 0) {
                texSize = 4;
                texStride = 4 * texCoordSetCount;
            }
            stride += texStride;
            normoff += texStride;
            coloroff += texStride;
            coordoff += texStride;
        }
        if ((vformat & 0x1000) != 0) {
            for (int i2 = 0; i2 < vertexAttrCount; ++i2) {
                vAttrStride += vertexAttrSizes[i2];
            }
            stride += vAttrStride;
            normoff += vAttrStride;
            coloroff += vAttrStride;
            coordoff += vAttrStride;
            texCoordoff += vAttrStride;
        }
        bstride = stride * 4;
        if (updateAlpha && !ignoreVertexColors) {
            useAlpha = true;
        }
        if (geo_type == 12 || geo_type == 13 || geo_type == 14) {
            sarray = ((IndexedGeometryStripArrayRetained)geo).stripIndexCounts;
            strip_len = sarray.length;
        }
        verts = JoglPipeline.getVertexArrayBuffer(varray);
        if ((vformat & 2) != 0 && nxform != null) {
            off = normoff;
            for (i = 0; i < vertexCount * 3; i += 3) {
                verts.put(off, (float)(nxform[0] * (double)varray[off] + nxform[1] * (double)varray[off + 1] + nxform[2] * (double)varray[off + 2]));
                verts.put(off + 1, (float)(nxform[4] * (double)varray[off] + nxform[5] * (double)varray[off + 1] + nxform[6] * (double)varray[off + 2]));
                verts.put(off + 2, (float)(nxform[8] * (double)varray[off] + nxform[9] * (double)varray[off + 1] + nxform[10] * (double)varray[off + 2]));
                off += stride;
            }
        }
        if ((vformat & 1) != 0 && xform != null) {
            off = coordoff;
            for (i = 0; i < vertexCount * 3; i += 3) {
                verts.put(off, (float)(xform[0] * (double)varray[off] + xform[1] * (double)varray[off + 1] + xform[2] * (double)varray[off + 2]));
                verts.put(off + 1, (float)(xform[4] * (double)varray[off] + xform[5] * (double)varray[off + 1] + xform[6] * (double)varray[off + 2]));
                verts.put(off + 2, (float)(xform[8] * (double)varray[off] + xform[9] * (double)varray[off + 1] + xform[10] * (double)varray[off + 2]));
                off += stride;
            }
        }
        if (geo_type == 12 || geo_type == 13 || geo_type == 14) {
            boolean useInterleavedArrays;
            if (ignoreVertexColors || (vformat & 0x460) != 0 && (texCoordSetMapLen > 1 || texCoordSetCount > 1)) {
                useInterleavedArrays = false;
            } else {
                boolean[] tmp = new boolean[1];
                int[] tmp2 = new int[1];
                this.testForInterleavedArrays(vformat, tmp, tmp2);
                useInterleavedArrays = tmp[0];
                iaFormat = tmp2[0];
            }
            if (useInterleavedArrays) {
                verts.position(0);
                gl.glInterleavedArrays(iaFormat, bstride, (Buffer)verts);
            } else {
                if ((vformat & 2) != 0) {
                    verts.position(normoff);
                    gl.glNormalPointer(5126, bstride, (Buffer)verts);
                }
                if (!ignoreVertexColors && (vformat & 4) != 0) {
                    verts.position(coloroff);
                    if ((vformat & 8) != 0 || useAlpha) {
                        gl.glColorPointer(4, 5126, bstride, (Buffer)verts);
                    } else {
                        gl.glColorPointer(3, 5126, bstride, (Buffer)verts);
                    }
                }
                if ((vformat & 1) != 0) {
                    verts.position(coordoff);
                    gl.glVertexPointer(3, 5126, bstride, (Buffer)verts);
                }
                if ((vformat & 0x460) != 0) {
                    this.executeTexture(texCoordSetMapLen, texSize, bstride, texCoordoff, texCoordSetMapOffset, texCoordSetMapLen, verts, gl);
                }
                if ((vformat & 0x1000) != 0) {
                    int vAttrOffset = vAttrOff;
                    for (int i3 = 0; i3 < vertexAttrCount; ++i3) {
                        ctx.enableVertexAttrArray((GL)gl, i3);
                        verts.position(vAttrOffset);
                        ctx.vertexAttrPointer((GL)gl, i3, vertexAttrSizes[i3], 5126, bstride, verts);
                        vAttrOffset += vertexAttrSizes[i3];
                    }
                }
            }
            switch (geo_type) {
                case 12: {
                    primType = 5;
                    break;
                }
                case 13: {
                    primType = 6;
                    break;
                }
                case 14: {
                    primType = 3;
                }
            }
            this.lockArray(gl, vertexCount);
            int offset = initialIndexIndex;
            IntBuffer indicesBuffer = IntBuffer.wrap(indexCoord);
            for (int i4 = 0; i4 < strip_len; ++i4) {
                indicesBuffer.position(offset);
                int count = sarray[i4];
                gl.glDrawElements(primType, count, 5125, (Buffer)indicesBuffer);
                offset += count;
            }
        } else if (geo_type == 8 || geo_type == 9 || geo_type == 10 || geo_type == 11) {
            boolean useInterleavedArrays;
            if (ignoreVertexColors || (vformat & 0x460) != 0 && (texCoordSetMapLen > 1 || texCoordSetCount > 1)) {
                useInterleavedArrays = false;
            } else {
                boolean[] tmp = new boolean[1];
                int[] tmp2 = new int[1];
                this.testForInterleavedArrays(vformat, tmp, tmp2);
                useInterleavedArrays = tmp[0];
                iaFormat = tmp2[0];
            }
            if (useInterleavedArrays) {
                verts.position(0);
                gl.glInterleavedArrays(iaFormat, bstride, (Buffer)verts);
            } else {
                if ((vformat & 2) != 0) {
                    verts.position(normoff);
                    gl.glNormalPointer(5126, bstride, (Buffer)verts);
                }
                if (!ignoreVertexColors && (vformat & 4) != 0) {
                    verts.position(coloroff);
                    if ((vformat & 8) != 0 || useAlpha) {
                        gl.glColorPointer(4, 5126, bstride, (Buffer)verts);
                    } else {
                        gl.glColorPointer(3, 5126, bstride, (Buffer)verts);
                    }
                }
                if ((vformat & 1) != 0) {
                    verts.position(coordoff);
                    gl.glVertexPointer(3, 5126, bstride, (Buffer)verts);
                }
                if ((vformat & 0x460) != 0) {
                    this.executeTexture(texCoordSetMapLen, texSize, bstride, texCoordoff, texCoordSetMapOffset, texCoordSetMapLen, verts, gl);
                }
                if ((vformat & 0x1000) != 0) {
                    int vAttrOffset = vAttrOff;
                    for (int i5 = 0; i5 < vertexAttrCount; ++i5) {
                        ctx.enableVertexAttrArray((GL)gl, i5);
                        verts.position(vAttrOffset);
                        ctx.vertexAttrPointer((GL)gl, i5, vertexAttrSizes[i5], 5126, bstride, verts);
                        vAttrOffset += vertexAttrSizes[i5];
                    }
                }
                switch (geo_type) {
                    case 8: {
                        primType = 7;
                        break;
                    }
                    case 9: {
                        primType = 4;
                        break;
                    }
                    case 10: {
                        primType = 0;
                        break;
                    }
                    case 11: {
                        primType = 1;
                    }
                }
                this.lockArray(gl, vertexCount);
                IntBuffer indicesBuffer = IntBuffer.wrap(indexCoord);
                indicesBuffer.position(initialIndexIndex);
                gl.glDrawElements(primType, validIndexCount, 5125, (Buffer)indicesBuffer);
            }
        }
        this.unlockArray(gl);
        if ((vformat & 0x1000) != 0) {
            this.resetVertexAttrs((GL)gl, ctx, vertexAttrCount);
        }
        if ((vformat & 0x460) != 0) {
            this.resetTexture(gl, ctx);
        }
    }

    private void executeIndexedGeometryArray(Context absCtx, GeometryArrayRetained geo, int geo_type, boolean isNonUniformScale, boolean useAlpha, boolean ignoreVertexColors, int initialIndexIndex, int indexCount, int vertexCount, int vformat, int vertexAttrCount, int[] vertexAttrSizes, int texCoordSetCount, int[] texCoordSetMap, int texCoordSetMapLen, int[] texCoordSetOffset, int numActiveTexUnitState, float[] varray, FloatBuffer vdata, float[] carray, int cDirty, int[] indexCoord) {
        JoglContext ctx = (JoglContext)absCtx;
        GL2 gl = this.context(ctx).getGL().getGL2();
        int iaFormat = 0;
        int primType = 0;
        int stride = 0;
        int coordoff = 0;
        int normoff = 0;
        int coloroff = 0;
        int texCoordoff = 0;
        int texSize = 0;
        int texStride = 0;
        int vAttrOff = 0;
        int vAttrStride = 0;
        int bstride = 0;
        int cbstride = 0;
        FloatBuffer verts = null;
        FloatBuffer clrs = null;
        int[] sarray = null;
        int strip_len = 0;
        if ((vformat & 1) != 0) {
            stride += 3;
        }
        if ((vformat & 2) != 0) {
            stride += 3;
            coordoff += 3;
        }
        if ((vformat & 4) != 0) {
            if ((vformat & 8) != 0) {
                stride += 4;
                normoff += 4;
                coordoff += 4;
            } else {
                stride += 3;
                normoff += 3;
                coordoff += 3;
            }
        }
        if ((vformat & 0x460) != 0) {
            if ((vformat & 0x20) != 0) {
                texSize = 2;
                texStride = 2 * texCoordSetCount;
            } else if ((vformat & 0x40) != 0) {
                texSize = 3;
                texStride = 3 * texCoordSetCount;
            } else if ((vformat & 0x400) != 0) {
                texSize = 4;
                texStride = 4 * texCoordSetCount;
            }
            stride += texStride;
            normoff += texStride;
            coloroff += texStride;
            coordoff += texStride;
        }
        if ((vformat & 0x1000) != 0) {
            for (int i = 0; i < vertexAttrCount; ++i) {
                vAttrStride += vertexAttrSizes[i];
            }
            stride += vAttrStride;
            normoff += vAttrStride;
            coloroff += vAttrStride;
            coordoff += vAttrStride;
            texCoordoff += vAttrStride;
        }
        bstride = stride * 4;
        if (geo_type == 12 || geo_type == 13 || geo_type == 14) {
            sarray = ((IndexedGeometryStripArrayRetained)geo).stripIndexCounts;
            strip_len = sarray.length;
        }
        if (varray != null) {
            verts = JoglPipeline.getVertexArrayBuffer(varray);
        } else if (vdata != null) {
            verts = vdata;
        } else {
            throw new AssertionError((Object)"Unable to get vertex pointer");
        }
        int cstride = stride;
        if (carray != null) {
            clrs = JoglPipeline.getColorArrayBuffer(carray);
            cstride = 4;
        } else {
            clrs = verts;
        }
        cbstride = cstride * 4;
        if (isNonUniformScale) {
            gl.glEnable(2977);
        }
        if (geo_type == 12 || geo_type == 13 || geo_type == 14) {
            boolean useInterleavedArrays;
            if (ignoreVertexColors || carray != null || (vformat & 0x460) != 0 && (texCoordSetMapLen > 1 || texCoordSetCount > 1)) {
                useInterleavedArrays = false;
            } else {
                boolean[] tmp = new boolean[1];
                int[] tmp2 = new int[1];
                this.testForInterleavedArrays(vformat, tmp, tmp2);
                useInterleavedArrays = tmp[0];
                iaFormat = tmp2[0];
            }
            if (useInterleavedArrays) {
                verts.position(0);
                gl.glInterleavedArrays(iaFormat, bstride, (Buffer)verts);
            } else {
                if ((vformat & 2) != 0) {
                    verts.position(normoff);
                    gl.glNormalPointer(5126, bstride, (Buffer)verts);
                }
                if (!ignoreVertexColors && (vformat & 4) != 0) {
                    if (clrs == verts) {
                        clrs.position(coloroff);
                    }
                    if ((vformat & 8) != 0 || useAlpha) {
                        gl.glColorPointer(4, 5126, cbstride, (Buffer)clrs);
                    } else {
                        gl.glColorPointer(3, 5126, cbstride, (Buffer)clrs);
                    }
                }
                if ((vformat & 1) != 0) {
                    verts.position(coordoff);
                    gl.glVertexPointer(3, 5126, bstride, (Buffer)verts);
                }
                if ((vformat & 0x460) != 0) {
                    this.executeTexture(texCoordSetMapLen, texSize, bstride, texCoordoff, texCoordSetOffset, numActiveTexUnitState, verts, gl);
                }
                if ((vformat & 0x1000) != 0) {
                    int vAttrOffset = vAttrOff;
                    for (int i = 0; i < vertexAttrCount; ++i) {
                        ctx.enableVertexAttrArray((GL)gl, i);
                        verts.position(vAttrOffset);
                        ctx.vertexAttrPointer((GL)gl, i, vertexAttrSizes[i], 5126, bstride, verts);
                        vAttrOffset += vertexAttrSizes[i];
                    }
                }
            }
            switch (geo_type) {
                case 12: {
                    primType = 5;
                    break;
                }
                case 13: {
                    primType = 6;
                    break;
                }
                case 14: {
                    primType = 3;
                }
            }
            this.lockArray(gl, vertexCount);
            int offset = initialIndexIndex;
            IntBuffer indicesBuffer = IntBuffer.wrap(indexCoord);
            for (int i = 0; i < strip_len; ++i) {
                indicesBuffer.position(offset);
                int count = sarray[i];
                gl.glDrawElements(primType, count, 5125, (Buffer)indicesBuffer);
                offset += count;
            }
        } else if (geo_type == 8 || geo_type == 9 || geo_type == 10 || geo_type == 11) {
            boolean useInterleavedArrays;
            if (ignoreVertexColors || carray != null || (vformat & 0x460) != 0 && (texCoordSetMapLen > 1 || texCoordSetCount > 1)) {
                useInterleavedArrays = false;
            } else {
                boolean[] tmp = new boolean[1];
                int[] tmp2 = new int[1];
                this.testForInterleavedArrays(vformat, tmp, tmp2);
                useInterleavedArrays = tmp[0];
                iaFormat = tmp2[0];
            }
            if (useInterleavedArrays) {
                verts.position(0);
                gl.glInterleavedArrays(iaFormat, bstride, (Buffer)verts);
            } else {
                if ((vformat & 2) != 0) {
                    verts.position(normoff);
                    gl.glNormalPointer(5126, bstride, (Buffer)verts);
                }
                if (!ignoreVertexColors && (vformat & 4) != 0) {
                    if (clrs == verts) {
                        clrs.position(coloroff);
                    }
                    if ((vformat & 8) != 0 || useAlpha) {
                        gl.glColorPointer(4, 5126, cbstride, (Buffer)clrs);
                    } else {
                        gl.glColorPointer(3, 5126, cbstride, (Buffer)clrs);
                    }
                }
                if ((vformat & 1) != 0) {
                    verts.position(coordoff);
                    gl.glVertexPointer(3, 5126, bstride, (Buffer)verts);
                }
                if ((vformat & 0x460) != 0) {
                    this.executeTexture(texCoordSetMapLen, texSize, bstride, texCoordoff, texCoordSetOffset, numActiveTexUnitState, verts, gl);
                }
                if ((vformat & 0x1000) != 0) {
                    int vAttrOffset = vAttrOff;
                    for (int i = 0; i < vertexAttrCount; ++i) {
                        ctx.enableVertexAttrArray((GL)gl, i);
                        verts.position(vAttrOffset);
                        ctx.vertexAttrPointer((GL)gl, i, vertexAttrSizes[i], 5126, bstride, verts);
                        vAttrOffset += vertexAttrSizes[i];
                    }
                }
            }
            this.lockArray(gl, vertexCount);
            IntBuffer buf = IntBuffer.wrap(indexCoord);
            buf.position(initialIndexIndex);
            switch (geo_type) {
                case 8: {
                    gl.glDrawElements(7, indexCount, 5125, (Buffer)buf);
                    break;
                }
                case 9: {
                    gl.glDrawElements(4, indexCount, 5125, (Buffer)buf);
                    break;
                }
                case 10: {
                    gl.glDrawElements(0, indexCount, 5125, (Buffer)buf);
                    break;
                }
                case 11: {
                    gl.glDrawElements(1, indexCount, 5125, (Buffer)buf);
                }
            }
        }
        this.unlockArray(gl);
        if ((vformat & 0x1000) != 0) {
            this.resetVertexAttrs((GL)gl, ctx, vertexAttrCount);
        }
        if ((vformat & 0x460) != 0) {
            this.resetTexture(gl, ctx);
        }
        if (isNonUniformScale) {
            gl.glDisable(2977);
        }
    }

    private void executeIndexedGeometryArrayVA(Context absCtx, GeometryArrayRetained geo, int geo_type, boolean isNonUniformScale, boolean ignoreVertexColors, int initialIndexIndex, int validIndexCount, int vertexCount, int vformat, int vdefined, FloatBuffer fverts, DoubleBuffer dverts, FloatBuffer fclrs, ByteBuffer bclrs, FloatBuffer norms, int vertexAttrCount, int[] vertexAttrSizes, FloatBuffer[] vertexAttrBufs, int texCoordSetCount, int[] texCoordSetMap, int numActiveTexUnitState, int texStride, FloatBuffer[] texCoords, int cDirty, int[] indexCoord, int[] sarray, int strip_len) {
        boolean textureDefined;
        JoglContext ctx = (JoglContext)absCtx;
        GL2 gl = this.context(ctx).getGL().getGL2();
        boolean floatCoordDefined = (vdefined & 1) != 0;
        boolean doubleCoordDefined = (vdefined & 2) != 0;
        boolean floatColorsDefined = (vdefined & 4) != 0;
        boolean byteColorsDefined = (vdefined & 8) != 0;
        boolean normalsDefined = (vdefined & 0x10) != 0;
        boolean vattrDefined = (vdefined & 0x40) != 0;
        boolean bl = textureDefined = (vdefined & 0x20) != 0;
        if (isNonUniformScale) {
            gl.glEnable(2977);
        }
        if (floatCoordDefined) {
            fverts.position(0);
            gl.glVertexPointer(3, 5126, 0, (Buffer)fverts);
        } else if (doubleCoordDefined) {
            dverts.position(0);
            gl.glVertexPointer(3, 5130, 0, (Buffer)dverts);
        }
        if (floatColorsDefined) {
            fclrs.position(0);
            if ((vformat & 8) != 0) {
                gl.glColorPointer(4, 5126, 0, (Buffer)fclrs);
            } else {
                gl.glColorPointer(3, 5126, 0, (Buffer)fclrs);
            }
        } else if (byteColorsDefined) {
            bclrs.position(0);
            if ((vformat & 8) != 0) {
                gl.glColorPointer(4, 5121, 0, (Buffer)bclrs);
            } else {
                gl.glColorPointer(3, 5121, 0, (Buffer)bclrs);
            }
        }
        if (normalsDefined) {
            norms.position(0);
            gl.glNormalPointer(5126, 0, (Buffer)norms);
        }
        if (vattrDefined) {
            for (int i = 0; i < vertexAttrCount; ++i) {
                FloatBuffer vertexAttrs = vertexAttrBufs[i];
                int sz = vertexAttrSizes[i];
                ctx.enableVertexAttrArray((GL)gl, i);
                vertexAttrs.position(0);
                ctx.vertexAttrPointer((GL)gl, i, sz, 5126, 0, vertexAttrs);
            }
        }
        if (textureDefined) {
            int texSet = 0;
            for (int i = 0; i < numActiveTexUnitState; ++i) {
                if (i < texCoordSetCount && (texSet = texCoordSetMap[i]) != -1) {
                    FloatBuffer buf = texCoords[texSet];
                    buf.position(0);
                    this.enableTexCoordPointer(gl, i, texStride, 5126, 0, buf);
                    continue;
                }
                this.disableTexCoordPointer(gl, i);
            }
            this.clientActiveTextureUnit(gl, 0);
        }
        this.lockArray(gl, vertexCount);
        if (geo_type == 12 || geo_type == 13 || geo_type == 14) {
            int primType = 0;
            switch (geo_type) {
                case 12: {
                    primType = 5;
                    break;
                }
                case 13: {
                    primType = 6;
                    break;
                }
                case 14: {
                    primType = 3;
                }
            }
            int offset = initialIndexIndex;
            IntBuffer indicesBuffer = IntBuffer.wrap(indexCoord);
            for (int i = 0; i < strip_len; ++i) {
                indicesBuffer.position(offset);
                int count = sarray[i];
                gl.glDrawElements(primType, count, 5125, (Buffer)indicesBuffer);
                offset += count;
            }
        } else {
            IntBuffer buf = IntBuffer.wrap(indexCoord);
            buf.position(initialIndexIndex);
            switch (geo_type) {
                case 8: {
                    gl.glDrawElements(7, validIndexCount, 5125, (Buffer)buf);
                    break;
                }
                case 9: {
                    gl.glDrawElements(4, validIndexCount, 5125, (Buffer)buf);
                    break;
                }
                case 10: {
                    gl.glDrawElements(0, validIndexCount, 5125, (Buffer)buf);
                    break;
                }
                case 11: {
                    gl.glDrawElements(1, validIndexCount, 5125, (Buffer)buf);
                }
            }
        }
        this.unlockArray(gl);
        if (isNonUniformScale) {
            gl.glDisable(2977);
        }
        if (vattrDefined) {
            this.resetVertexAttrs((GL)gl, ctx, vertexAttrCount);
        }
        if (textureDefined) {
            this.resetTexture(gl, ctx);
        }
    }

    @Override
    void readRaster(Context ctx, int type, int xSrcOffset, int ySrcOffset, int width, int height, int hCanvas, int imageDataType, int imageFormat, Object imageBuffer, int depthFormat, Object depthBuffer) {
        GL2 gl = this.context(ctx).getGL().getGL2();
        gl.glPixelStorei(3330, width);
        gl.glPixelStorei(3333, 1);
        int yAdjusted = hCanvas - height - ySrcOffset;
        if ((type & 1) != 0) {
            int oglFormat = 0;
            if (imageDataType == 4096) {
                switch (imageFormat) {
                    case 1: {
                        oglFormat = 32992;
                        break;
                    }
                    case 2: {
                        oglFormat = 6407;
                        break;
                    }
                    case 4: {
                        if (gl.isExtensionAvailable("GL_EXT_abgr")) {
                            oglFormat = 32768;
                            break;
                        }
                        assert (false);
                        return;
                    }
                    case 8: {
                        oglFormat = 6408;
                        break;
                    }
                    case 16: {
                        oglFormat = 6410;
                        break;
                    }
                    default: {
                        assert (false);
                        return;
                    }
                }
                gl.glReadPixels(xSrcOffset, yAdjusted, width, height, oglFormat, 5121, (Buffer)ByteBuffer.wrap((byte[])imageBuffer));
            } else if (imageDataType == 8192) {
                int intType = 32821;
                boolean forceAlphaToOne = false;
                switch (imageFormat) {
                    case 128: {
                        oglFormat = 6408;
                        intType = 33639;
                        forceAlphaToOne = true;
                        break;
                    }
                    case 256: {
                        forceAlphaToOne = true;
                    }
                    case 512: {
                        oglFormat = 32993;
                        intType = 33639;
                        break;
                    }
                    default: {
                        assert (false);
                        return;
                    }
                }
                if (forceAlphaToOne) {
                    gl.glPixelTransferf(3356, 0.0f);
                    gl.glPixelTransferf(3357, 1.0f);
                }
                gl.glReadPixels(xSrcOffset, yAdjusted, width, height, oglFormat, intType, (Buffer)IntBuffer.wrap((int[])imageBuffer));
                if (forceAlphaToOne) {
                    gl.glPixelTransferf(3356, 1.0f);
                    gl.glPixelTransferf(3357, 0.0f);
                }
            } else assert (false);
        }
        if ((type & 2) != 0) {
            if (depthFormat == 1) {
                gl.glReadPixels(xSrcOffset, yAdjusted, width, height, 6402, 5125, (Buffer)IntBuffer.wrap((int[])depthBuffer));
            } else {
                gl.glReadPixels(xSrcOffset, yAdjusted, width, height, 6402, 5126, (Buffer)FloatBuffer.wrap((float[])depthBuffer));
            }
        }
    }

    @Override
    ShaderError setGLSLUniform1i(Context ctx, ShaderProgramId shaderProgramId, ShaderAttrLoc uniformLocation, int value) {
        GL2 gl = this.context(ctx).getGL().getGL2();
        gl.glUniform1iARB(this.unbox(uniformLocation), value);
        return null;
    }

    @Override
    ShaderError setGLSLUniform1f(Context ctx, ShaderProgramId shaderProgramId, ShaderAttrLoc uniformLocation, float value) {
        GL2 gl = this.context(ctx).getGL().getGL2();
        gl.glUniform1fARB(this.unbox(uniformLocation), value);
        return null;
    }

    @Override
    ShaderError setGLSLUniform2i(Context ctx, ShaderProgramId shaderProgramId, ShaderAttrLoc uniformLocation, int[] value) {
        GL2 gl = this.context(ctx).getGL().getGL2();
        gl.glUniform2iARB(this.unbox(uniformLocation), value[0], value[1]);
        return null;
    }

    @Override
    ShaderError setGLSLUniform2f(Context ctx, ShaderProgramId shaderProgramId, ShaderAttrLoc uniformLocation, float[] value) {
        GL2 gl = this.context(ctx).getGL().getGL2();
        gl.glUniform2fARB(this.unbox(uniformLocation), value[0], value[1]);
        return null;
    }

    @Override
    ShaderError setGLSLUniform3i(Context ctx, ShaderProgramId shaderProgramId, ShaderAttrLoc uniformLocation, int[] value) {
        GL2 gl = this.context(ctx).getGL().getGL2();
        gl.glUniform3iARB(this.unbox(uniformLocation), value[0], value[1], value[2]);
        return null;
    }

    @Override
    ShaderError setGLSLUniform3f(Context ctx, ShaderProgramId shaderProgramId, ShaderAttrLoc uniformLocation, float[] value) {
        GL2 gl = this.context(ctx).getGL().getGL2();
        gl.glUniform3fARB(this.unbox(uniformLocation), value[0], value[1], value[2]);
        return null;
    }

    @Override
    ShaderError setGLSLUniform4i(Context ctx, ShaderProgramId shaderProgramId, ShaderAttrLoc uniformLocation, int[] value) {
        GL2 gl = this.context(ctx).getGL().getGL2();
        gl.glUniform4iARB(this.unbox(uniformLocation), value[0], value[1], value[2], value[3]);
        return null;
    }

    @Override
    ShaderError setGLSLUniform4f(Context ctx, ShaderProgramId shaderProgramId, ShaderAttrLoc uniformLocation, float[] value) {
        GL2 gl = this.context(ctx).getGL().getGL2();
        gl.glUniform4fARB(this.unbox(uniformLocation), value[0], value[1], value[2], value[3]);
        return null;
    }

    @Override
    ShaderError setGLSLUniformMatrix3f(Context ctx, ShaderProgramId shaderProgramId, ShaderAttrLoc uniformLocation, float[] value) {
        GL2 gl = this.context(ctx).getGL().getGL2();
        gl.glUniformMatrix3fvARB(this.unbox(uniformLocation), 1, true, value, 0);
        return null;
    }

    @Override
    ShaderError setGLSLUniformMatrix4f(Context ctx, ShaderProgramId shaderProgramId, ShaderAttrLoc uniformLocation, float[] value) {
        GL2 gl = this.context(ctx).getGL().getGL2();
        gl.glUniformMatrix4fvARB(this.unbox(uniformLocation), 1, true, value, 0);
        return null;
    }

    @Override
    ShaderError setGLSLUniform1iArray(Context ctx, ShaderProgramId shaderProgramId, ShaderAttrLoc uniformLocation, int numElements, int[] value) {
        GL2 gl = this.context(ctx).getGL().getGL2();
        gl.glUniform1ivARB(this.unbox(uniformLocation), numElements, value, 0);
        return null;
    }

    @Override
    ShaderError setGLSLUniform1fArray(Context ctx, ShaderProgramId shaderProgramId, ShaderAttrLoc uniformLocation, int numElements, float[] value) {
        GL2 gl = this.context(ctx).getGL().getGL2();
        gl.glUniform1fvARB(this.unbox(uniformLocation), numElements, value, 0);
        return null;
    }

    @Override
    ShaderError setGLSLUniform2iArray(Context ctx, ShaderProgramId shaderProgramId, ShaderAttrLoc uniformLocation, int numElements, int[] value) {
        GL2 gl = this.context(ctx).getGL().getGL2();
        gl.glUniform2ivARB(this.unbox(uniformLocation), numElements, value, 0);
        return null;
    }

    @Override
    ShaderError setGLSLUniform2fArray(Context ctx, ShaderProgramId shaderProgramId, ShaderAttrLoc uniformLocation, int numElements, float[] value) {
        GL2 gl = this.context(ctx).getGL().getGL2();
        gl.glUniform2fvARB(this.unbox(uniformLocation), numElements, value, 0);
        return null;
    }

    @Override
    ShaderError setGLSLUniform3iArray(Context ctx, ShaderProgramId shaderProgramId, ShaderAttrLoc uniformLocation, int numElements, int[] value) {
        GL2 gl = this.context(ctx).getGL().getGL2();
        gl.glUniform3ivARB(this.unbox(uniformLocation), numElements, value, 0);
        return null;
    }

    @Override
    ShaderError setGLSLUniform3fArray(Context ctx, ShaderProgramId shaderProgramId, ShaderAttrLoc uniformLocation, int numElements, float[] value) {
        GL2 gl = this.context(ctx).getGL().getGL2();
        gl.glUniform3fvARB(this.unbox(uniformLocation), numElements, value, 0);
        return null;
    }

    @Override
    ShaderError setGLSLUniform4iArray(Context ctx, ShaderProgramId shaderProgramId, ShaderAttrLoc uniformLocation, int numElements, int[] value) {
        GL2 gl = this.context(ctx).getGL().getGL2();
        gl.glUniform4ivARB(this.unbox(uniformLocation), numElements, value, 0);
        return null;
    }

    @Override
    ShaderError setGLSLUniform4fArray(Context ctx, ShaderProgramId shaderProgramId, ShaderAttrLoc uniformLocation, int numElements, float[] value) {
        GL2 gl = this.context(ctx).getGL().getGL2();
        gl.glUniform4fvARB(this.unbox(uniformLocation), numElements, value, 0);
        return null;
    }

    @Override
    ShaderError setGLSLUniformMatrix3fArray(Context ctx, ShaderProgramId shaderProgramId, ShaderAttrLoc uniformLocation, int numElements, float[] value) {
        GL2 gl = this.context(ctx).getGL().getGL2();
        gl.glUniformMatrix3fvARB(this.unbox(uniformLocation), numElements, true, value, 0);
        return null;
    }

    @Override
    ShaderError setGLSLUniformMatrix4fArray(Context ctx, ShaderProgramId shaderProgramId, ShaderAttrLoc uniformLocation, int numElements, float[] value) {
        GL2 gl = this.context(ctx).getGL().getGL2();
        gl.glUniformMatrix4fvARB(this.unbox(uniformLocation), numElements, true, value, 0);
        return null;
    }

    @Override
    ShaderError createGLSLShader(Context ctx, int shaderType, ShaderId[] shaderId) {
        GL2 gl = this.context(ctx).getGL().getGL2();
        int shaderHandle = 0;
        if (shaderType == 1) {
            shaderHandle = (int)gl.glCreateShaderObjectARB(35633);
        } else if (shaderType == 2) {
            shaderHandle = (int)gl.glCreateShaderObjectARB(35632);
        }
        if (shaderHandle == 0) {
            return new ShaderError(1, "Unable to create native shader object");
        }
        shaderId[0] = new JoglShaderObject(shaderHandle);
        return null;
    }

    @Override
    ShaderError destroyGLSLShader(Context ctx, ShaderId shaderId) {
        GL2 gl = this.context(ctx).getGL().getGL2();
        gl.glDeleteObjectARB((long)this.unbox(shaderId));
        return null;
    }

    @Override
    ShaderError compileGLSLShader(Context ctx, ShaderId shaderId, String program) {
        int id = this.unbox(shaderId);
        if (id == 0) {
            throw new AssertionError((Object)"shaderId == 0");
        }
        if (program == null) {
            throw new AssertionError((Object)"shader program string is null");
        }
        GL2 gl = this.context(ctx).getGL().getGL2();
        gl.glShaderSourceARB((long)id, 1, new String[]{program}, null, 0);
        gl.glCompileShaderARB((long)id);
        int[] status = new int[1];
        gl.glGetObjectParameterivARB((long)id, 35713, status, 0);
        if (status[0] == 0) {
            String detailMsg = this.getInfoLog(gl, id);
            ShaderError res = new ShaderError(1, "GLSL shader compile error");
            res.setDetailMessage(detailMsg);
            return res;
        }
        return null;
    }

    @Override
    ShaderError createGLSLShaderProgram(Context ctx, ShaderProgramId[] shaderProgramId) {
        GL2 gl = this.context(ctx).getGL().getGL2();
        int shaderProgramHandle = (int)gl.glCreateProgramObjectARB();
        if (shaderProgramHandle == 0) {
            return new ShaderError(2, "Unable to create native shader program object");
        }
        shaderProgramId[0] = new JoglShaderObject(shaderProgramHandle);
        return null;
    }

    @Override
    ShaderError destroyGLSLShaderProgram(Context ctx, ShaderProgramId shaderProgramId) {
        GL2 gl = this.context(ctx).getGL().getGL2();
        gl.glDeleteObjectARB((long)this.unbox(shaderProgramId));
        return null;
    }

    @Override
    ShaderError linkGLSLShaderProgram(Context ctx, ShaderProgramId shaderProgramId, ShaderId[] shaderIds) {
        GL2 gl = this.context(ctx).getGL().getGL2();
        int id = this.unbox(shaderProgramId);
        for (int i = 0; i < shaderIds.length; ++i) {
            gl.glAttachObjectARB((long)id, (long)this.unbox(shaderIds[i]));
        }
        gl.glLinkProgramARB((long)id);
        int[] status = new int[1];
        gl.glGetObjectParameterivARB((long)id, 35714, status, 0);
        if (status[0] == 0) {
            String detailMsg = this.getInfoLog(gl, id);
            ShaderError res = new ShaderError(2, "GLSL shader program link error");
            res.setDetailMessage(detailMsg);
            return res;
        }
        return null;
    }

    @Override
    ShaderError bindGLSLVertexAttrName(Context ctx, ShaderProgramId shaderProgramId, String attrName, int attrIndex) {
        GL2 gl = this.context(ctx).getGL().getGL2();
        gl.glBindAttribLocation(this.unbox(shaderProgramId), attrIndex + VirtualUniverse.mc.glslVertexAttrOffset, attrName);
        return null;
    }

    @Override
    void lookupGLSLShaderAttrNames(Context ctx, ShaderProgramId shaderProgramId, int numAttrNames, String[] attrNames, ShaderAttrLoc[] locArr, int[] typeArr, int[] sizeArr, boolean[] isArrayArr) {
        int i;
        for (int i2 = 0; i2 < attrNames.length; ++i2) {
            locArr[i2] = null;
            typeArr[i2] = -1;
            sizeArr[i2] = -1;
        }
        int id = this.unbox(shaderProgramId);
        int[] tmp = new int[1];
        int[] tmp2 = new int[1];
        int[] tmp3 = new int[1];
        GL2 gl = this.context(ctx).getGL().getGL2();
        gl.glGetObjectParameterivARB((long)id, 35718, tmp, 0);
        int numActiveUniforms = tmp[0];
        gl.glGetObjectParameterivARB((long)id, 35719, tmp, 0);
        int maxStrLen = tmp[0];
        byte[] nameBuf = new byte[maxStrLen];
        block3: for (i = 0; i < numActiveUniforms; ++i) {
            gl.glGetActiveUniformARB((long)id, i, maxStrLen, tmp3, 0, tmp, 0, tmp2, 0, nameBuf, 0);
            int size = tmp[0];
            int type = tmp2[0];
            String name = null;
            try {
                name = new String(nameBuf, 0, tmp3[0], "US-ASCII");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            if (name.length() >= 3 && name.endsWith("]")) {
                if (!name.endsWith("[0]")) continue;
                name = name.substring(0, name.length() - 3);
            }
            for (int j = 0; j < numAttrNames; ++j) {
                if (!name.equals(attrNames[j])) continue;
                sizeArr[j] = size;
                isArrayArr[j] = size > 1;
                typeArr[j] = this.glslToJ3dType(type);
                continue block3;
            }
        }
        for (i = 0; i < numAttrNames; ++i) {
            int loc = gl.glGetUniformLocationARB((long)id, attrNames[i]);
            locArr[i] = new JoglShaderObject(loc);
        }
    }

    @Override
    ShaderError useGLSLShaderProgram(Context ctx, ShaderProgramId shaderProgramId) {
        GL2 gl = this.context(ctx).getGL().getGL2();
        gl.glUseProgramObjectARB((long)this.unbox(shaderProgramId));
        ((JoglContext)ctx).setShaderProgram((JoglShaderObject)shaderProgramId);
        return null;
    }

    private int unbox(ShaderAttrLoc loc) {
        if (loc == null) {
            return 0;
        }
        return ((JoglShaderObject)loc).getValue();
    }

    private int unbox(ShaderProgramId id) {
        if (id == null) {
            return 0;
        }
        return ((JoglShaderObject)id).getValue();
    }

    private int unbox(ShaderId id) {
        if (id == null) {
            return 0;
        }
        return ((JoglShaderObject)id).getValue();
    }

    private String getInfoLog(GL2 gl, int id) {
        int[] infoLogLength = new int[1];
        gl.glGetObjectParameterivARB((long)id, 35716, infoLogLength, 0);
        if (infoLogLength[0] > 0) {
            byte[] storage = new byte[infoLogLength[0]];
            int[] len = new int[1];
            gl.glGetInfoLogARB((long)id, infoLogLength[0], len, 0, storage, 0);
            try {
                return new String(storage, 0, len[0], "US-ASCII");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    private int glslToJ3dType(int type) {
        switch (type) {
            case 5124: 
            case 35670: 
            case 35678: 
            case 35679: 
            case 35680: {
                return 0;
            }
            case 5126: {
                return 1;
            }
            case 35667: 
            case 35671: {
                return 2;
            }
            case 35664: {
                return 3;
            }
            case 35668: 
            case 35672: {
                return 4;
            }
            case 35665: {
                return 5;
            }
            case 35669: 
            case 35673: {
                return 6;
            }
            case 35666: {
                return 7;
            }
            case 35675: {
                return 8;
            }
            case 35676: {
                return 9;
            }
        }
        return -1;
    }

    @Override
    void updateColoringAttributes(Context ctx, float dRed, float dGreen, float dBlue, float red, float green, float blue, float alpha, boolean lightEnable, int shadeModel) {
        float cb;
        float cg;
        float cr;
        GL2 gl = this.context(ctx).getGL().getGL2();
        if (lightEnable) {
            cr = dRed;
            cg = dGreen;
            cb = dBlue;
        } else {
            cr = red;
            cg = green;
            cb = blue;
        }
        gl.glColor4f(cr, cg, cb, alpha);
        if (shadeModel == 2) {
            gl.glShadeModel(7424);
        } else {
            gl.glShadeModel(7425);
        }
    }

    @Override
    void updateDirectionalLight(Context ctx, int lightSlot, float red, float green, float blue, float dirx, float diry, float dirz) {
        GL2 gl = this.context(ctx).getGL().getGL2();
        int lightNum = 16384 + lightSlot;
        float[] values = new float[]{red, green, blue, 1.0f};
        gl.glLightfv(lightNum, 4609, values, 0);
        gl.glLightfv(lightNum, 4610, values, 0);
        values[0] = -dirx;
        values[1] = -diry;
        values[2] = -dirz;
        values[3] = 0.0f;
        gl.glLightfv(lightNum, 4611, values, 0);
        gl.glLightfv(lightNum, 4608, black, 0);
        gl.glLightf(lightNum, 4615, 1.0f);
        gl.glLightf(lightNum, 4616, 0.0f);
        gl.glLightf(lightNum, 4617, 0.0f);
        gl.glLightf(lightNum, 4613, 0.0f);
        gl.glLightf(lightNum, 4614, 180.0f);
    }

    @Override
    void updatePointLight(Context ctx, int lightSlot, float red, float green, float blue, float attenx, float atteny, float attenz, float posx, float posy, float posz) {
        GL2 gl = this.context(ctx).getGL().getGL2();
        int lightNum = 16384 + lightSlot;
        float[] values = new float[]{red, green, blue, 1.0f};
        gl.glLightfv(lightNum, 4609, values, 0);
        gl.glLightfv(lightNum, 4610, values, 0);
        gl.glLightfv(lightNum, 4608, black, 0);
        values[0] = posx;
        values[1] = posy;
        values[2] = posz;
        gl.glLightfv(lightNum, 4611, values, 0);
        gl.glLightf(lightNum, 4615, attenx);
        gl.glLightf(lightNum, 4616, atteny);
        gl.glLightf(lightNum, 4617, attenz);
        gl.glLightf(lightNum, 4613, 0.0f);
        gl.glLightf(lightNum, 4614, 180.0f);
    }

    @Override
    void updateSpotLight(Context ctx, int lightSlot, float red, float green, float blue, float attenx, float atteny, float attenz, float posx, float posy, float posz, float spreadAngle, float concentration, float dirx, float diry, float dirz) {
        GL2 gl = this.context(ctx).getGL().getGL2();
        int lightNum = 16384 + lightSlot;
        float[] values = new float[]{red, green, blue, 1.0f};
        gl.glLightfv(lightNum, 4609, values, 0);
        gl.glLightfv(lightNum, 4610, values, 0);
        gl.glLightfv(lightNum, 4608, black, 0);
        values[0] = posx;
        values[1] = posy;
        values[2] = posz;
        gl.glLightfv(lightNum, 4611, values, 0);
        gl.glLightf(lightNum, 4615, attenx);
        gl.glLightf(lightNum, 4616, atteny);
        gl.glLightf(lightNum, 4617, attenz);
        values[0] = dirx;
        values[1] = diry;
        values[2] = dirz;
        gl.glLightfv(lightNum, 4612, values, 0);
        gl.glLightf(lightNum, 4613, concentration);
        gl.glLightf(lightNum, 4614, (float)((double)(spreadAngle * 180.0f) / Math.PI));
    }

    @Override
    void updateExponentialFog(Context ctx, float red, float green, float blue, float density) {
        GL2 gl = this.context(ctx).getGL().getGL2();
        float[] color = new float[]{red, green, blue};
        gl.glFogi(2917, 2048);
        gl.glFogfv(2918, color, 0);
        gl.glFogf(2914, density);
        gl.glEnable(2912);
    }

    @Override
    void updateLinearFog(Context ctx, float red, float green, float blue, double fdist, double bdist) {
        GL2 gl = this.context(ctx).getGL().getGL2();
        float[] color = new float[]{red, green, blue};
        gl.glFogi(2917, 9729);
        gl.glFogfv(2918, color, 0);
        gl.glFogf(2915, (float)fdist);
        gl.glFogf(2916, (float)bdist);
        gl.glEnable(2912);
    }

    @Override
    void updateLineAttributes(Context ctx, float lineWidth, int linePattern, int linePatternMask, int linePatternScaleFactor, boolean lineAntialiasing) {
        GL2 gl = this.context(ctx).getGL().getGL2();
        gl.glLineWidth(lineWidth);
        if (linePattern == 0) {
            gl.glDisable(2852);
        } else {
            if (linePattern == 1) {
                gl.glLineStipple(1, (short)255);
            } else if (linePattern == 2) {
                gl.glLineStipple(1, (short)257);
            } else if (linePattern == 3) {
                gl.glLineStipple(1, (short)2175);
            } else if (linePattern == 4) {
                gl.glLineStipple(linePatternScaleFactor, (short)linePatternMask);
            }
            gl.glEnable(2852);
        }
        if (lineAntialiasing) {
            gl.glEnable(2848);
        } else {
            gl.glDisable(2848);
        }
    }

    @Override
    void updateMaterial(Context ctx, float red, float green, float blue, float alpha, float aRed, float aGreen, float aBlue, float eRed, float eGreen, float eBlue, float dRed, float dGreen, float dBlue, float sRed, float sGreen, float sBlue, float shininess, int colorTarget, boolean lightEnable) {
        float[] color = new float[4];
        GL2 gl = this.context(ctx).getGL().getGL2();
        gl.glMaterialf(1032, 5633, shininess);
        switch (colorTarget) {
            case 2: {
                gl.glColorMaterial(1032, 4609);
                break;
            }
            case 0: {
                gl.glColorMaterial(1032, 4608);
                break;
            }
            case 1: {
                gl.glColorMaterial(1032, 5632);
                break;
            }
            case 3: {
                gl.glColorMaterial(1032, 4610);
                break;
            }
            case 4: {
                gl.glColorMaterial(1032, 5634);
            }
        }
        color[0] = eRed;
        color[1] = eGreen;
        color[2] = eBlue;
        gl.glMaterialfv(1032, 5632, color, 0);
        color[0] = aRed;
        color[1] = aGreen;
        color[2] = aBlue;
        gl.glMaterialfv(1032, 4608, color, 0);
        color[0] = sRed;
        color[1] = sGreen;
        color[2] = sBlue;
        gl.glMaterialfv(1032, 4610, color, 0);
        if (lightEnable) {
            color[0] = dRed;
            color[1] = dGreen;
            color[2] = dBlue;
        } else {
            color[0] = red;
            color[1] = green;
            color[2] = blue;
        }
        color[3] = alpha;
        gl.glMaterialfv(1032, 4609, color, 0);
        gl.glColor4f(color[0], color[1], color[2], color[3]);
        if (lightEnable) {
            gl.glEnable(2896);
        } else {
            gl.glDisable(2896);
        }
    }

    @Override
    void updateModelClip(Context ctx, int planeNum, boolean enableFlag, double A, double B, double C, double D) {
        GL2 gl = this.context(ctx).getGL().getGL2();
        double[] equation = new double[4];
        int pl = 12288 + planeNum;
        if (enableFlag) {
            equation[0] = -A;
            equation[1] = -B;
            equation[2] = -C;
            equation[3] = -D;
            gl.glClipPlane(pl, DoubleBuffer.wrap(equation));
            gl.glEnable(pl);
        } else {
            gl.glDisable(pl);
        }
    }

    @Override
    void updatePointAttributes(Context ctx, float pointSize, boolean pointAntialiasing) {
        GL2 gl = this.context(ctx).getGL().getGL2();
        gl.glPointSize(pointSize);
        if (pointAntialiasing) {
            gl.glEnable(2832);
        } else {
            gl.glDisable(2832);
        }
    }

    @Override
    void updatePolygonAttributes(Context ctx, int polygonMode, int cullFace, boolean backFaceNormalFlip, float polygonOffset, float polygonOffsetFactor) {
        GL2 gl = this.context(ctx).getGL().getGL2();
        if (cullFace == 0) {
            gl.glDisable(2884);
        } else {
            if (cullFace == 1) {
                gl.glCullFace(1029);
            } else {
                gl.glCullFace(1028);
            }
            gl.glEnable(2884);
        }
        if (backFaceNormalFlip && cullFace != 1) {
            gl.glLightModeli(2898, 1);
        } else {
            gl.glLightModeli(2898, 0);
        }
        if (polygonMode == 0) {
            gl.glPolygonMode(1032, 6912);
        } else if (polygonMode == 1) {
            gl.glPolygonMode(1032, 6913);
        } else {
            gl.glPolygonMode(1032, 6914);
        }
        gl.glPolygonOffset(polygonOffsetFactor, polygonOffset);
        if ((double)polygonOffsetFactor != 0.0 || (double)polygonOffset != 0.0) {
            switch (polygonMode) {
                case 0: {
                    gl.glEnable(10753);
                    gl.glDisable(10754);
                    gl.glDisable(32823);
                    break;
                }
                case 1: {
                    gl.glEnable(10754);
                    gl.glDisable(10753);
                    gl.glDisable(32823);
                    break;
                }
                case 2: {
                    gl.glEnable(32823);
                    gl.glDisable(10753);
                    gl.glDisable(10754);
                }
            }
        } else {
            gl.glDisable(10753);
            gl.glDisable(10754);
            gl.glDisable(32823);
        }
    }

    @Override
    void updateRenderingAttributes(Context ctx, boolean depthBufferWriteEnableOverride, boolean depthBufferEnableOverride, boolean depthBufferEnable, boolean depthBufferWriteEnable, int depthTestFunction, float alphaTestValue, int alphaTestFunction, boolean ignoreVertexColors, boolean rasterOpEnable, int rasterOp, boolean userStencilAvailable, boolean stencilEnable, int stencilFailOp, int stencilZFailOp, int stencilZPassOp, int stencilFunction, int stencilReferenceValue, int stencilCompareMask, int stencilWriteMask) {
        GL2 gl = this.context(ctx).getGL().getGL2();
        if (!depthBufferEnableOverride) {
            if (depthBufferEnable) {
                gl.glEnable(2929);
                gl.glDepthFunc(this.getFunctionValue(depthTestFunction));
            } else {
                gl.glDisable(2929);
            }
        }
        if (!depthBufferWriteEnableOverride) {
            if (depthBufferWriteEnable) {
                gl.glDepthMask(true);
            } else {
                gl.glDepthMask(false);
            }
        }
        if (alphaTestFunction == 0) {
            gl.glDisable(3008);
        } else {
            gl.glEnable(3008);
            gl.glAlphaFunc(this.getFunctionValue(alphaTestFunction), alphaTestValue);
        }
        if (ignoreVertexColors) {
            gl.glDisable(2903);
        } else {
            gl.glEnable(2903);
        }
        if (rasterOpEnable) {
            gl.glEnable(3058);
            switch (rasterOp) {
                case 0: {
                    gl.glLogicOp(5376);
                    break;
                }
                case 1: {
                    gl.glLogicOp(5377);
                    break;
                }
                case 2: {
                    gl.glLogicOp(5378);
                    break;
                }
                case 3: {
                    gl.glLogicOp(5379);
                    break;
                }
                case 4: {
                    gl.glLogicOp(5380);
                    break;
                }
                case 5: {
                    gl.glLogicOp(5381);
                    break;
                }
                case 6: {
                    gl.glLogicOp(5382);
                    break;
                }
                case 7: {
                    gl.glLogicOp(5383);
                    break;
                }
                case 8: {
                    gl.glLogicOp(5384);
                    break;
                }
                case 9: {
                    gl.glLogicOp(5385);
                    break;
                }
                case 10: {
                    gl.glLogicOp(5386);
                    break;
                }
                case 11: {
                    gl.glLogicOp(5387);
                    break;
                }
                case 12: {
                    gl.glLogicOp(5388);
                    break;
                }
                case 13: {
                    gl.glLogicOp(5389);
                    break;
                }
                case 14: {
                    gl.glLogicOp(5390);
                    break;
                }
                case 15: {
                    gl.glLogicOp(5391);
                }
            }
        } else {
            gl.glDisable(3058);
        }
        if (userStencilAvailable) {
            if (stencilEnable) {
                gl.glEnable(2960);
                gl.glStencilOp(this.getStencilOpValue(stencilFailOp), this.getStencilOpValue(stencilZFailOp), this.getStencilOpValue(stencilZPassOp));
                gl.glStencilFunc(this.getFunctionValue(stencilFunction), stencilReferenceValue, stencilCompareMask);
                gl.glStencilMask(stencilWriteMask);
            } else {
                gl.glDisable(2960);
            }
        }
    }

    private int getFunctionValue(int func) {
        switch (func) {
            case 0: {
                func = 519;
                break;
            }
            case 1: {
                func = 512;
                break;
            }
            case 2: {
                func = 514;
                break;
            }
            case 3: {
                func = 517;
                break;
            }
            case 4: {
                func = 513;
                break;
            }
            case 5: {
                func = 515;
                break;
            }
            case 6: {
                func = 516;
                break;
            }
            case 7: {
                func = 518;
            }
        }
        return func;
    }

    private int getStencilOpValue(int op) {
        switch (op) {
            case 1: {
                op = 7680;
                break;
            }
            case 2: {
                op = 0;
                break;
            }
            case 3: {
                op = 7681;
                break;
            }
            case 4: {
                op = 7682;
                break;
            }
            case 5: {
                op = 7683;
                break;
            }
            case 6: {
                op = 5386;
            }
        }
        return op;
    }

    @Override
    void updateTexCoordGeneration(Context ctx, boolean enable, int genMode, int format, float planeSx, float planeSy, float planeSz, float planeSw, float planeTx, float planeTy, float planeTz, float planeTw, float planeRx, float planeRy, float planeRz, float planeRw, float planeQx, float planeQy, float planeQz, float planeQw, double[] vworldToEc) {
        GL2 gl = this.context(ctx).getGL().getGL2();
        float[] planeS = new float[4];
        float[] planeT = new float[4];
        float[] planeR = new float[4];
        float[] planeQ = new float[4];
        if (enable) {
            gl.glEnable(3168);
            gl.glEnable(3169);
            if (format == 1) {
                gl.glEnable(3170);
                gl.glDisable(3171);
            } else if (format == 2) {
                gl.glEnable(3170);
                gl.glEnable(3171);
            } else {
                gl.glDisable(3170);
                gl.glDisable(3171);
            }
            if (genMode != 2) {
                planeS[0] = planeSx;
                planeS[1] = planeSy;
                planeS[2] = planeSz;
                planeS[3] = planeSw;
                planeT[0] = planeTx;
                planeT[1] = planeTy;
                planeT[2] = planeTz;
                planeT[3] = planeTw;
                if (format == 1) {
                    planeR[0] = planeRx;
                    planeR[1] = planeRy;
                    planeR[2] = planeRz;
                    planeR[3] = planeRw;
                } else if (format == 2) {
                    planeR[0] = planeRx;
                    planeR[1] = planeRy;
                    planeR[2] = planeRz;
                    planeR[3] = planeRw;
                    planeQ[0] = planeQx;
                    planeQ[1] = planeQy;
                    planeQ[2] = planeQz;
                    planeQ[3] = planeQw;
                }
            }
            switch (genMode) {
                case 0: {
                    gl.glTexGeni(8192, 9472, 9217);
                    gl.glTexGeni(8193, 9472, 9217);
                    gl.glTexGenfv(8192, 9473, planeS, 0);
                    gl.glTexGenfv(8193, 9473, planeT, 0);
                    if (format == 1) {
                        gl.glTexGeni(8194, 9472, 9217);
                        gl.glTexGenfv(8194, 9473, planeR, 0);
                        break;
                    }
                    if (format != 2) break;
                    gl.glTexGeni(8194, 9472, 9217);
                    gl.glTexGenfv(8194, 9473, planeR, 0);
                    gl.glTexGeni(8195, 9472, 9217);
                    gl.glTexGenfv(8195, 9473, planeQ, 0);
                    break;
                }
                case 1: {
                    gl.glMatrixMode(5888);
                    gl.glPushMatrix();
                    if (gl.isExtensionAvailable("GL_VERSION_1_3")) {
                        gl.glLoadTransposeMatrixd(vworldToEc, 0);
                    } else {
                        double[] v = new double[16];
                        this.copyTranspose(vworldToEc, v);
                        gl.glLoadMatrixd(v, 0);
                    }
                    gl.glTexGeni(8192, 9472, 9216);
                    gl.glTexGeni(8193, 9472, 9216);
                    gl.glTexGenfv(8192, 9474, planeS, 0);
                    gl.glTexGenfv(8193, 9474, planeT, 0);
                    if (format == 1) {
                        gl.glTexGeni(8194, 9472, 9216);
                        gl.glTexGenfv(8194, 9474, planeR, 0);
                    } else if (format == 2) {
                        gl.glTexGeni(8194, 9472, 9216);
                        gl.glTexGenfv(8194, 9474, planeR, 0);
                        gl.glTexGeni(8195, 9472, 9216);
                        gl.glTexGenfv(8195, 9474, planeQ, 0);
                    }
                    gl.glPopMatrix();
                    break;
                }
                case 2: {
                    gl.glTexGeni(8192, 9472, 9218);
                    gl.glTexGeni(8193, 9472, 9218);
                    if (format == 1) {
                        gl.glTexGeni(8194, 9472, 9218);
                        break;
                    }
                    if (format != 2) break;
                    gl.glTexGeni(8194, 9472, 9218);
                    gl.glTexGeni(8195, 9472, 9218);
                    break;
                }
                case 3: {
                    gl.glTexGeni(8192, 9472, 34065);
                    gl.glTexGeni(8193, 9472, 34065);
                    if (format == 1) {
                        gl.glTexGeni(8194, 9472, 34065);
                        break;
                    }
                    if (format != 2) break;
                    gl.glTexGeni(8194, 9472, 34065);
                    gl.glTexGeni(8195, 9472, 34065);
                    break;
                }
                case 4: {
                    gl.glTexGeni(8192, 9472, 34066);
                    gl.glTexGeni(8193, 9472, 34066);
                    if (format == 1) {
                        gl.glTexGeni(8194, 9472, 34066);
                        break;
                    }
                    if (format != 2) break;
                    gl.glTexGeni(8194, 9472, 34066);
                    gl.glTexGeni(8195, 9472, 34066);
                }
            }
        } else {
            gl.glDisable(3168);
            gl.glDisable(3169);
            gl.glDisable(3170);
            gl.glDisable(3171);
        }
    }

    @Override
    void updateTransparencyAttributes(Context ctx, float alpha, int geometryType, int polygonMode, boolean lineAA, boolean pointAA, int transparencyMode, int srcBlendFunction, int dstBlendFunction) {
        GL2 gl = this.context(ctx).getGL().getGL2();
        if (transparencyMode != 3) {
            gl.glDisable(2882);
        } else {
            gl.glEnable(2882);
            gl.glPolygonStipple(screen_door_table[(int)(alpha * 16.0f)]);
        }
        if (transparencyMode < 3 || ((geometryType & 2) != 0 || polygonMode == 1) && lineAA || ((geometryType & 1) != 0 || polygonMode == 0) && pointAA) {
            gl.glEnable(3042);
            gl.glBlendFunc(blendFunctionTable[srcBlendFunction], blendFunctionTable[dstBlendFunction]);
        } else {
            gl.glDisable(3042);
        }
    }

    @Override
    void updateTextureAttributes(Context ctx, double[] transform, boolean isIdentity, int textureMode, int perspCorrectionMode, float textureBlendColorRed, float textureBlendColorGreen, float textureBlendColorBlue, float textureBlendColorAlpha, int textureFormat) {
        GL2 gl = this.context(ctx).getGL().getGL2();
        gl.glHint(3152, perspCorrectionMode == 1 ? 4354 : 4353);
        gl.glPushAttrib(4096);
        gl.glMatrixMode(5890);
        if (isIdentity) {
            gl.glLoadIdentity();
        } else if (gl.isExtensionAvailable("GL_VERSION_1_3")) {
            gl.glLoadTransposeMatrixd(transform, 0);
        } else {
            double[] mx = new double[16];
            this.copyTranspose(transform, mx);
            gl.glLoadMatrixd(mx, 0);
        }
        gl.glPopAttrib();
        float[] color = new float[]{textureBlendColorRed, textureBlendColorGreen, textureBlendColorBlue, textureBlendColorAlpha};
        gl.glTexEnvfv(8960, 8705, color, 0);
        switch (textureMode) {
            case 2: {
                gl.glTexEnvi(8960, 8704, 8448);
                break;
            }
            case 3: {
                gl.glTexEnvi(8960, 8704, 8449);
                break;
            }
            case 4: {
                gl.glTexEnvi(8960, 8704, 3042);
                break;
            }
            case 5: {
                gl.glTexEnvi(8960, 8704, 7681);
                break;
            }
            case 6: {
                gl.glTexEnvi(8960, 8704, 34160);
            }
        }
    }

    @Override
    void updateRegisterCombiners(Context absCtx, double[] transform, boolean isIdentity, int textureMode, int perspCorrectionMode, float textureBlendColorRed, float textureBlendColorGreen, float textureBlendColorBlue, float textureBlendColorAlpha, int textureFormat, int combineRgbMode, int combineAlphaMode, int[] combineRgbSrc, int[] combineAlphaSrc, int[] combineRgbFcn, int[] combineAlphaFcn, int combineRgbScale, int combineAlphaScale) {
    }

    @Override
    void updateTextureColorTable(Context ctx, int numComponents, int colorTableSize, int[] textureColorTable) {
    }

    @Override
    void updateCombiner(Context ctx, int combineRgbMode, int combineAlphaMode, int[] combineRgbSrc, int[] combineAlphaSrc, int[] combineRgbFcn, int[] combineAlphaFcn, int combineRgbScale, int combineAlphaScale) {
        int i;
        GL2 gl = this.context(ctx).getGL().getGL2();
        int[] GLrgbMode = new int[1];
        int[] GLalphaMode = new int[1];
        this.getGLCombineMode((GL)gl, combineRgbMode, combineAlphaMode, GLrgbMode, GLalphaMode);
        gl.glTexEnvi(8960, 34161, GLrgbMode[0]);
        gl.glTexEnvi(8960, 34162, GLalphaMode[0]);
        int nargs = combineRgbMode == 0 ? 1 : (combineRgbMode == 5 ? 3 : 2);
        for (i = 0; i < nargs; ++i) {
            gl.glTexEnvi(8960, _gl_combineRgbSrcIndex[i], _gl_combineSrc[combineRgbSrc[i]]);
            gl.glTexEnvi(8960, _gl_combineRgbOpIndex[i], _gl_combineFcn[combineRgbFcn[i]]);
        }
        nargs = combineAlphaMode == 0 ? 1 : (combineAlphaMode == 5 ? 3 : 2);
        for (i = 0; i < nargs; ++i) {
            gl.glTexEnvi(8960, _gl_combineAlphaSrcIndex[i], _gl_combineSrc[combineAlphaSrc[i]]);
            gl.glTexEnvi(8960, _gl_combineAlphaOpIndex[i], _gl_combineFcn[combineAlphaFcn[i]]);
        }
        gl.glTexEnvi(8960, 34163, combineRgbScale);
        gl.glTexEnvi(8960, 3356, combineAlphaScale);
    }

    private void getGLCombineMode(GL gl, int combineRgbMode, int combineAlphaMode, int[] GLrgbMode, int[] GLalphaMode) {
        switch (combineRgbMode) {
            case 0: {
                GLrgbMode[0] = 7681;
                break;
            }
            case 1: {
                GLrgbMode[0] = 8448;
                break;
            }
            case 2: {
                GLrgbMode[0] = 260;
                break;
            }
            case 3: {
                GLrgbMode[0] = 34164;
                break;
            }
            case 4: {
                GLrgbMode[0] = 34023;
                break;
            }
            case 5: {
                GLrgbMode[0] = 34165;
                break;
            }
            case 6: {
                GLrgbMode[0] = 34478;
                break;
            }
        }
        switch (combineAlphaMode) {
            case 0: {
                GLalphaMode[0] = 7681;
                break;
            }
            case 1: {
                GLalphaMode[0] = 8448;
                break;
            }
            case 2: {
                GLalphaMode[0] = 260;
                break;
            }
            case 3: {
                GLalphaMode[0] = 34164;
                break;
            }
            case 4: {
                GLalphaMode[0] = 34023;
                break;
            }
            case 5: {
                GLalphaMode[0] = 34165;
                break;
            }
            case 6: {
                if (combineRgbMode == 6) {
                    GLrgbMode[0] = 34479;
                    break;
                }
                GLalphaMode[0] = 7681;
                break;
            }
        }
    }

    @Override
    void updateTextureUnitState(Context ctx, int index, boolean enable) {
        GL2 gl = this.context(ctx).getGL().getGL2();
        if (index >= 0 && gl.isExtensionAvailable("GL_VERSION_1_3")) {
            gl.glActiveTexture(index + 33984);
            gl.glClientActiveTexture(33984 + index);
        }
        if (!enable) {
            gl.glDisable(3552);
            gl.glDisable(3553);
            gl.glDisable(32879);
            gl.glDisable(34067);
        }
    }

    @Override
    void bindTexture2D(Context ctx, int objectId, boolean enable) {
        GL gl = this.context(ctx).getGL();
        gl.glDisable(34067);
        gl.glDisable(32879);
        if (!enable) {
            gl.glDisable(3553);
        } else {
            gl.glBindTexture(3553, objectId);
            gl.glEnable(3553);
        }
    }

    @Override
    void updateTexture2DImage(Context ctx, int numLevels, int level, int textureFormat, int imageFormat, int width, int height, int boundaryWidth, int dataType, Object data, boolean useAutoMipMap) {
        this.updateTexture2DImage(ctx, 3553, numLevels, level, textureFormat, imageFormat, width, height, boundaryWidth, dataType, data, useAutoMipMap);
    }

    @Override
    void updateTexture2DSubImage(Context ctx, int level, int xoffset, int yoffset, int textureFormat, int imageFormat, int imgXOffset, int imgYOffset, int tilew, int width, int height, int dataType, Object data, boolean useAutoMipMap) {
        this.updateTexture2DSubImage(ctx, 3553, level, xoffset, yoffset, textureFormat, imageFormat, imgXOffset, imgYOffset, tilew, width, height, dataType, data);
    }

    @Override
    void updateTexture2DLodRange(Context ctx, int baseLevel, int maximumLevel, float minimumLOD, float maximumLOD) {
        this.updateTextureLodRange(ctx, 3553, baseLevel, maximumLevel, minimumLOD, maximumLOD);
    }

    @Override
    void updateTexture2DLodOffset(Context ctx, float lodOffsetS, float lodOffsetT, float lodOffsetR) {
        this.updateTextureLodOffset(ctx, 3553, lodOffsetS, lodOffsetT, lodOffsetR);
    }

    @Override
    void updateTexture2DBoundary(Context ctx, int boundaryModeS, int boundaryModeT, float boundaryRed, float boundaryGreen, float boundaryBlue, float boundaryAlpha) {
        this.updateTextureBoundary(ctx, 3553, boundaryModeS, boundaryModeT, -1, boundaryRed, boundaryGreen, boundaryBlue, boundaryAlpha);
    }

    @Override
    void updateTexture2DFilterModes(Context ctx, int minFilter, int magFilter) {
        this.updateTextureFilterModes(ctx, 3553, minFilter, magFilter);
    }

    @Override
    void updateTexture2DSharpenFunc(Context ctx, int numSharpenTextureFuncPts, float[] sharpenTextureFuncPts) {
        this.updateTextureSharpenFunc(ctx, 3553, numSharpenTextureFuncPts, sharpenTextureFuncPts);
    }

    @Override
    void updateTexture2DFilter4Func(Context ctx, int numFilter4FuncPts, float[] filter4FuncPts) {
        this.updateTextureFilter4Func(ctx, 3553, numFilter4FuncPts, filter4FuncPts);
    }

    @Override
    void updateTexture2DAnisotropicFilter(Context ctx, float degree) {
        this.updateTextureAnisotropicFilter(ctx, 3553, degree);
    }

    private void updateTextureLodRange(Context ctx, int target, int baseLevel, int maximumLevel, float minimumLOD, float maximumLOD) {
        GL gl = this.context(ctx).getGL();
        gl.glTexParameteri(target, 33084, baseLevel);
        gl.glTexParameteri(target, 33085, maximumLevel);
        gl.glTexParameterf(target, 33082, minimumLOD);
        gl.glTexParameterf(target, 33083, maximumLOD);
    }

    private void updateTextureLodOffset(Context ctx, int target, float lodOffsetS, float lodOffsetT, float lodOffsetR) {
    }

    private void updateTextureAnisotropicFilter(Context ctx, int target, float degree) {
        GL gl = this.context(ctx).getGL();
        gl.glTexParameterf(target, 34046, degree);
    }

    @Override
    void bindTexture3D(Context ctx, int objectId, boolean enable) {
        GL gl = this.context(ctx).getGL();
        gl.glDisable(34067);
        if (!enable) {
            gl.glDisable(32879);
        } else {
            gl.glBindTexture(32879, objectId);
            gl.glEnable(32879);
        }
    }

    @Override
    void updateTexture3DImage(Context ctx, int numLevels, int level, int textureFormat, int imageFormat, int width, int height, int depth, int boundaryWidth, int dataType, Object data, boolean useAutoMipMap) {
        GL2 gl = this.context(ctx).getGL().getGL2();
        int format = 0;
        int internalFormat = 0;
        int type = 32821;
        boolean forceAlphaToOne = false;
        switch (textureFormat) {
            case 1: {
                internalFormat = 32841;
                break;
            }
            case 2: {
                internalFormat = 6409;
                break;
            }
            case 3: {
                internalFormat = 6406;
                break;
            }
            case 4: {
                internalFormat = 6410;
                break;
            }
            case 5: {
                internalFormat = 6407;
                break;
            }
            case 6: {
                internalFormat = 6408;
                break;
            }
            default: {
                assert (false);
                return;
            }
        }
        if (useAutoMipMap) {
            gl.glTexParameteri(32879, 33169, 1);
        } else {
            gl.glTexParameteri(32879, 33169, 0);
        }
        if (dataType == 4096 || dataType == 16384) {
            switch (imageFormat) {
                case 1: {
                    format = 32992;
                    break;
                }
                case 2: {
                    format = 6407;
                    break;
                }
                case 4: {
                    if (gl.isExtensionAvailable("GL_EXT_abgr")) {
                        format = 32768;
                        break;
                    }
                    assert (false);
                    return;
                }
                case 8: {
                    format = 6408;
                    break;
                }
                case 16: {
                    format = 6410;
                    break;
                }
                case 32: {
                    if (internalFormat == 6406) {
                        format = 6406;
                        break;
                    }
                    format = 6409;
                    break;
                }
                default: {
                    assert (false);
                    return;
                }
            }
            if (dataType == 4096) {
                gl.glTexImage3D(32879, level, internalFormat, width, height, depth, boundaryWidth, format, 5121, (Buffer)ByteBuffer.wrap((byte[])data));
            } else {
                gl.glTexImage3D(32879, level, internalFormat, width, height, depth, boundaryWidth, format, 5121, (Buffer)((ByteBuffer)data));
            }
        } else if (dataType == 8192 || dataType == 32768) {
            switch (imageFormat) {
                case 128: {
                    format = 6408;
                    type = 33639;
                    forceAlphaToOne = true;
                    break;
                }
                case 256: {
                    forceAlphaToOne = true;
                }
                case 512: {
                    format = 32993;
                    type = 33639;
                    break;
                }
                default: {
                    assert (false);
                    return;
                }
            }
            if (forceAlphaToOne) {
                gl.glPixelTransferf(3356, 0.0f);
                gl.glPixelTransferf(3357, 1.0f);
            }
            if (dataType == 8192) {
                gl.glTexImage3D(32879, level, internalFormat, width, height, depth, boundaryWidth, format, type, (Buffer)IntBuffer.wrap((int[])data));
            } else {
                gl.glTexImage3D(32879, level, internalFormat, width, height, depth, boundaryWidth, format, type, (Buffer)data);
            }
            if (forceAlphaToOne) {
                gl.glPixelTransferf(3356, 1.0f);
                gl.glPixelTransferf(3357, 0.0f);
            }
        } else assert (false);
    }

    @Override
    void updateTexture3DSubImage(Context ctx, int level, int xoffset, int yoffset, int zoffset, int textureFormat, int imageFormat, int imgXOffset, int imgYOffset, int imgZOffset, int tilew, int tileh, int width, int height, int depth, int dataType, Object data, boolean useAutoMipMap) {
        GL2 gl = this.context(ctx).getGL().getGL2();
        int format = 0;
        int internalFormat = 0;
        int type = 32821;
        int numBytes = 0;
        boolean forceAlphaToOne = false;
        boolean pixelStore = false;
        if (imgXOffset > 0 || width < tilew) {
            pixelStore = true;
            gl.glPixelStorei(3314, tilew);
        }
        switch (textureFormat) {
            case 1: {
                internalFormat = 32841;
                break;
            }
            case 2: {
                internalFormat = 6409;
                break;
            }
            case 3: {
                internalFormat = 6406;
                break;
            }
            case 4: {
                internalFormat = 6410;
                break;
            }
            case 5: {
                internalFormat = 6407;
                break;
            }
            case 6: {
                internalFormat = 6408;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        if (dataType == 4096 || dataType == 16384) {
            switch (imageFormat) {
                case 1: {
                    format = 32992;
                    numBytes = 3;
                    break;
                }
                case 2: {
                    format = 6407;
                    numBytes = 3;
                    break;
                }
                case 4: {
                    if (gl.isExtensionAvailable("GL_EXT_abgr")) {
                        format = 32768;
                        numBytes = 4;
                        break;
                    }
                    assert (false);
                    return;
                }
                case 8: {
                    format = 6408;
                    numBytes = 4;
                    break;
                }
                case 16: {
                    format = 6410;
                    numBytes = 2;
                    break;
                }
                case 32: {
                    if (internalFormat == 6406) {
                        format = 6406;
                        numBytes = 1;
                        break;
                    }
                    format = 6409;
                    numBytes = 1;
                    break;
                }
                default: {
                    assert (false);
                    return;
                }
            }
            ByteBuffer buf = null;
            buf = dataType == 4096 ? ByteBuffer.wrap((byte[])data) : (ByteBuffer)data;
            int offset = (tilew * tileh * imgZOffset + tilew * imgYOffset + imgXOffset) * numBytes;
            buf.position(offset);
            gl.glTexSubImage3D(32879, level, xoffset, yoffset, zoffset, width, height, depth, format, 5121, (Buffer)buf);
        } else if (dataType == 8192 || dataType == 32768) {
            switch (imageFormat) {
                case 128: {
                    format = 6408;
                    type = 33639;
                    forceAlphaToOne = true;
                    break;
                }
                case 256: {
                    forceAlphaToOne = true;
                }
                case 512: {
                    format = 32993;
                    type = 33639;
                    break;
                }
                default: {
                    assert (false);
                    return;
                }
            }
            if (forceAlphaToOne) {
                gl.glPixelTransferf(3356, 0.0f);
                gl.glPixelTransferf(3357, 1.0f);
            }
            IntBuffer buf = null;
            buf = dataType == 8192 ? IntBuffer.wrap((int[])data) : (IntBuffer)data;
            int offset = tilew * tileh * imgZOffset + tilew * imgYOffset + imgXOffset;
            buf.position(offset);
            gl.glTexSubImage3D(32879, level, xoffset, yoffset, zoffset, width, height, depth, format, type, (Buffer)buf);
            if (forceAlphaToOne) {
                gl.glPixelTransferf(3356, 1.0f);
                gl.glPixelTransferf(3357, 0.0f);
            }
        } else {
            assert (false);
            return;
        }
        if (pixelStore) {
            gl.glPixelStorei(3314, 0);
        }
    }

    @Override
    void updateTexture3DLodRange(Context ctx, int baseLevel, int maximumLevel, float minimumLod, float maximumLod) {
        this.updateTextureLodRange(ctx, 32879, baseLevel, maximumLevel, minimumLod, maximumLod);
    }

    @Override
    void updateTexture3DLodOffset(Context ctx, float lodOffsetS, float lodOffsetT, float lodOffsetR) {
        this.updateTextureLodOffset(ctx, 32879, lodOffsetS, lodOffsetT, lodOffsetR);
    }

    @Override
    void updateTexture3DBoundary(Context ctx, int boundaryModeS, int boundaryModeT, int boundaryModeR, float boundaryRed, float boundaryGreen, float boundaryBlue, float boundaryAlpha) {
        this.updateTextureBoundary(ctx, 32879, boundaryModeS, boundaryModeT, boundaryModeR, boundaryRed, boundaryGreen, boundaryBlue, boundaryAlpha);
    }

    @Override
    void updateTexture3DFilterModes(Context ctx, int minFilter, int magFilter) {
        this.updateTextureFilterModes(ctx, 32879, minFilter, magFilter);
    }

    @Override
    void updateTexture3DSharpenFunc(Context ctx, int numSharpenTextureFuncPts, float[] sharpenTextureFuncPts) {
        this.updateTextureSharpenFunc(ctx, 32879, numSharpenTextureFuncPts, sharpenTextureFuncPts);
    }

    @Override
    void updateTexture3DFilter4Func(Context ctx, int numFilter4FuncPts, float[] filter4FuncPts) {
        this.updateTextureFilter4Func(ctx, 32879, numFilter4FuncPts, filter4FuncPts);
    }

    @Override
    void updateTexture3DAnisotropicFilter(Context ctx, float degree) {
        this.updateTextureAnisotropicFilter(ctx, 32879, degree);
    }

    @Override
    void bindTextureCubeMap(Context ctx, int objectId, boolean enable) {
        GL gl = this.context(ctx).getGL();
        if (!enable) {
            gl.glDisable(34067);
        } else {
            gl.glBindTexture(34067, objectId);
            gl.glEnable(34067);
        }
    }

    @Override
    void updateTextureCubeMapImage(Context ctx, int face, int numLevels, int level, int textureFormat, int imageFormat, int width, int height, int boundaryWidth, int dataType, Object data, boolean useAutoMipMap) {
        this.updateTexture2DImage(ctx, _gl_textureCubeMapFace[face], numLevels, level, textureFormat, imageFormat, width, height, boundaryWidth, dataType, data, useAutoMipMap);
    }

    @Override
    void updateTextureCubeMapSubImage(Context ctx, int face, int level, int xoffset, int yoffset, int textureFormat, int imageFormat, int imgXOffset, int imgYOffset, int tilew, int width, int height, int dataType, Object data, boolean useAutoMipMap) {
        this.updateTexture2DSubImage(ctx, _gl_textureCubeMapFace[face], level, xoffset, yoffset, textureFormat, imageFormat, imgXOffset, imgYOffset, tilew, width, height, dataType, data);
    }

    @Override
    void updateTextureCubeMapLodRange(Context ctx, int baseLevel, int maximumLevel, float minimumLod, float maximumLod) {
        this.updateTextureLodRange(ctx, 34067, baseLevel, maximumLevel, minimumLod, maximumLod);
    }

    @Override
    void updateTextureCubeMapLodOffset(Context ctx, float lodOffsetS, float lodOffsetT, float lodOffsetR) {
        this.updateTextureLodOffset(ctx, 34067, lodOffsetS, lodOffsetT, lodOffsetR);
    }

    @Override
    void updateTextureCubeMapBoundary(Context ctx, int boundaryModeS, int boundaryModeT, float boundaryRed, float boundaryGreen, float boundaryBlue, float boundaryAlpha) {
        this.updateTextureBoundary(ctx, 34067, boundaryModeS, boundaryModeT, -1, boundaryRed, boundaryGreen, boundaryBlue, boundaryAlpha);
    }

    @Override
    void updateTextureCubeMapFilterModes(Context ctx, int minFilter, int magFilter) {
        this.updateTextureFilterModes(ctx, 34067, minFilter, magFilter);
    }

    @Override
    void updateTextureCubeMapSharpenFunc(Context ctx, int numSharpenTextureFuncPts, float[] sharpenTextureFuncPts) {
        this.updateTextureSharpenFunc(ctx, 34067, numSharpenTextureFuncPts, sharpenTextureFuncPts);
    }

    @Override
    void updateTextureCubeMapFilter4Func(Context ctx, int numFilter4FuncPts, float[] filter4FuncPts) {
        this.updateTextureFilter4Func(ctx, 34067, numFilter4FuncPts, filter4FuncPts);
    }

    @Override
    void updateTextureCubeMapAnisotropicFilter(Context ctx, float degree) {
        this.updateTextureAnisotropicFilter(ctx, 34067, degree);
    }

    private void updateTexture2DImage(Context ctx, int target, int numLevels, int level, int textureFormat, int imageFormat, int width, int height, int boundaryWidth, int dataType, Object data, boolean useAutoMipMap) {
        GL2 gl = this.context(ctx).getGL().getGL2();
        int format = 0;
        int internalFormat = 0;
        int type = 32821;
        boolean forceAlphaToOne = false;
        switch (textureFormat) {
            case 1: {
                internalFormat = 32841;
                break;
            }
            case 2: {
                internalFormat = 6409;
                break;
            }
            case 3: {
                internalFormat = 6406;
                break;
            }
            case 4: {
                internalFormat = 6410;
                break;
            }
            case 5: {
                internalFormat = 6407;
                break;
            }
            case 6: {
                internalFormat = 6408;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        if (useAutoMipMap) {
            gl.glTexParameteri(target, 33169, 1);
        } else {
            gl.glTexParameteri(target, 33169, 0);
        }
        if (dataType == 4096 || dataType == 16384) {
            switch (imageFormat) {
                case 1: {
                    format = 32992;
                    break;
                }
                case 2: {
                    format = 6407;
                    break;
                }
                case 4: {
                    if (gl.isExtensionAvailable("GL_EXT_abgr")) {
                        format = 32768;
                        break;
                    }
                    assert (false);
                    return;
                }
                case 8: {
                    format = 6408;
                    break;
                }
                case 16: {
                    format = 6410;
                    break;
                }
                case 32: {
                    if (internalFormat == 6406) {
                        format = 6406;
                        break;
                    }
                    format = 6409;
                    break;
                }
                default: {
                    assert (false);
                    return;
                }
            }
            if (dataType == 4096) {
                gl.glTexImage2D(target, level, internalFormat, width, height, boundaryWidth, format, 5121, (Buffer)ByteBuffer.wrap((byte[])data));
            } else {
                gl.glTexImage2D(target, level, internalFormat, width, height, boundaryWidth, format, 5121, (Buffer)data);
            }
        } else if (dataType == 8192 || dataType == 32768) {
            switch (imageFormat) {
                case 128: {
                    format = 6408;
                    type = 33639;
                    forceAlphaToOne = true;
                    break;
                }
                case 256: {
                    forceAlphaToOne = true;
                }
                case 512: {
                    format = 32993;
                    type = 33639;
                    break;
                }
                default: {
                    assert (false);
                    return;
                }
            }
            if (forceAlphaToOne) {
                gl.glPixelTransferf(3356, 0.0f);
                gl.glPixelTransferf(3357, 1.0f);
            }
            if (dataType == 8192) {
                gl.glTexImage2D(target, level, internalFormat, width, height, boundaryWidth, format, type, (Buffer)IntBuffer.wrap((int[])data));
            } else {
                gl.glTexImage2D(target, level, internalFormat, width, height, boundaryWidth, format, type, (Buffer)data);
            }
            if (forceAlphaToOne) {
                gl.glPixelTransferf(3356, 1.0f);
                gl.glPixelTransferf(3357, 0.0f);
            }
        } else assert (false);
    }

    private void updateTexture2DSubImage(Context ctx, int target, int level, int xoffset, int yoffset, int textureFormat, int imageFormat, int imgXOffset, int imgYOffset, int tilew, int width, int height, int dataType, Object data) {
        GL2 gl = this.context(ctx).getGL().getGL2();
        int format = 0;
        int internalFormat = 0;
        int numBytes = 0;
        int type = 32821;
        boolean forceAlphaToOne = false;
        boolean pixelStore = false;
        if (imgXOffset > 0 || width < tilew) {
            pixelStore = true;
            gl.glPixelStorei(3314, tilew);
        }
        switch (textureFormat) {
            case 1: {
                internalFormat = 32841;
                break;
            }
            case 2: {
                internalFormat = 6409;
                break;
            }
            case 3: {
                internalFormat = 6406;
                break;
            }
            case 4: {
                internalFormat = 6410;
                break;
            }
            case 5: {
                internalFormat = 6407;
                break;
            }
            case 6: {
                internalFormat = 6408;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        if (dataType == 4096 || dataType == 16384) {
            switch (imageFormat) {
                case 1: {
                    format = 32992;
                    numBytes = 3;
                    break;
                }
                case 2: {
                    format = 6407;
                    numBytes = 3;
                    break;
                }
                case 4: {
                    if (gl.isExtensionAvailable("GL_EXT_abgr")) {
                        format = 32768;
                        numBytes = 4;
                        break;
                    }
                    assert (false);
                    return;
                }
                case 8: {
                    format = 6408;
                    numBytes = 4;
                    break;
                }
                case 16: {
                    format = 6410;
                    numBytes = 2;
                    break;
                }
                case 32: {
                    if (internalFormat == 6406) {
                        format = 6406;
                        numBytes = 1;
                        break;
                    }
                    format = 6409;
                    numBytes = 1;
                    break;
                }
                default: {
                    assert (false);
                    return;
                }
            }
            ByteBuffer buf = null;
            buf = dataType == 4096 ? ByteBuffer.wrap((byte[])data) : (ByteBuffer)data;
            buf.position((tilew * imgYOffset + imgXOffset) * numBytes);
            gl.glTexSubImage2D(target, level, xoffset, yoffset, width, height, format, 5121, (Buffer)buf);
        } else if (dataType == 8192 || dataType == 32768) {
            switch (imageFormat) {
                case 128: {
                    format = 6408;
                    type = 33639;
                    forceAlphaToOne = true;
                    break;
                }
                case 256: {
                    forceAlphaToOne = true;
                }
                case 512: {
                    format = 32993;
                    type = 33639;
                    break;
                }
                default: {
                    assert (false);
                    return;
                }
            }
            if (forceAlphaToOne) {
                gl.glPixelTransferf(3356, 0.0f);
                gl.glPixelTransferf(3357, 1.0f);
            }
            IntBuffer buf = null;
            buf = dataType == 8192 ? IntBuffer.wrap((int[])data) : (IntBuffer)data;
            buf.position(tilew * imgYOffset + imgXOffset);
            gl.glTexSubImage2D(target, level, xoffset, yoffset, width, height, format, type, (Buffer)buf);
            if (forceAlphaToOne) {
                gl.glPixelTransferf(3356, 1.0f);
                gl.glPixelTransferf(3357, 0.0f);
            }
        } else {
            assert (false);
            return;
        }
        if (pixelStore) {
            gl.glPixelStorei(3314, 0);
        }
    }

    void updateTextureFilterModes(Context ctx, int target, int minFilter, int magFilter) {
        GL gl = this.context(ctx).getGL();
        switch (minFilter) {
            case 0: 
            case 2: {
                gl.glTexParameteri(target, 10241, 9728);
                break;
            }
            case 3: {
                gl.glTexParameteri(target, 10241, 9729);
                break;
            }
            case 4: {
                gl.glTexParameteri(target, 10241, 9984);
                break;
            }
            case 1: 
            case 5: {
                gl.glTexParameteri(target, 10241, 9987);
                break;
            }
        }
        switch (magFilter) {
            case 0: 
            case 2: {
                gl.glTexParameteri(target, 10240, 9728);
                break;
            }
            case 1: 
            case 3: {
                gl.glTexParameteri(target, 10240, 9729);
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                break;
            }
            case 11: {
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                break;
            }
        }
    }

    void updateTextureBoundary(Context ctx, int target, int boundaryModeS, int boundaryModeT, int boundaryModeR, float boundaryRed, float boundaryGreen, float boundaryBlue, float boundaryAlpha) {
        GL gl = this.context(ctx).getGL();
        switch (boundaryModeS) {
            case 3: {
                gl.glTexParameteri(target, 10242, 10497);
                break;
            }
            case 2: {
                gl.glTexParameteri(target, 10242, 10496);
                break;
            }
            case 4: {
                gl.glTexParameteri(target, 10242, 33071);
                break;
            }
            case 5: {
                gl.glTexParameteri(target, 10242, 33069);
            }
        }
        switch (boundaryModeT) {
            case 3: {
                gl.glTexParameteri(target, 10243, 10497);
                break;
            }
            case 2: {
                gl.glTexParameteri(target, 10243, 10496);
                break;
            }
            case 4: {
                gl.glTexParameteri(target, 10243, 33071);
                break;
            }
            case 5: {
                gl.glTexParameteri(target, 10243, 33069);
            }
        }
        if (boundaryModeR != -1) {
            switch (boundaryModeR) {
                case 3: {
                    gl.glTexParameteri(target, 32882, 10497);
                    break;
                }
                case 2: {
                    gl.glTexParameteri(target, 32882, 10496);
                    break;
                }
                case 4: {
                    gl.glTexParameteri(target, 32882, 33071);
                    break;
                }
                case 5: {
                    gl.glTexParameteri(target, 32882, 33069);
                }
            }
        }
        if (boundaryModeS == 2 || boundaryModeT == 2 || boundaryModeR == 2) {
            float[] color = new float[]{boundaryRed, boundaryGreen, boundaryBlue, boundaryAlpha};
            gl.glTexParameterfv(target, 4100, color, 0);
        }
    }

    private static final String getFilterName(int filter) {
        switch (filter) {
            case 0: {
                return "Texture.FASTEST";
            }
            case 1: {
                return "Texture.NICEST";
            }
            case 2: {
                return "Texture.BASE_LEVEL_POINT";
            }
            case 3: {
                return "Texture.BASE_LEVEL_LINEAR";
            }
            case 4: {
                return "Texture.MULTI_LEVEL_POINT";
            }
            case 5: {
                return "Texture.MULTI_LEVEL_LINEAR";
            }
            case 12: {
                return "Texture.FILTER4";
            }
            case 9: {
                return "Texture.LINEAR_SHARPEN";
            }
            case 10: {
                return "Texture.LINEAR_SHARPEN_RGB";
            }
            case 11: {
                return "Texture.LINEAR_SHARPEN_ALPHA";
            }
            case 6: {
                return "Texture.LINEAR_DETAIL";
            }
            case 7: {
                return "Texture.LINEAR_DETAIL_RGB";
            }
            case 8: {
                return "Texture.LINEAR_DETAIL_ALPHA";
            }
        }
        return "(unknown)";
    }

    private void updateTextureSharpenFunc(Context ctx, int target, int numPts, float[] pts) {
    }

    private void updateTextureFilter4Func(Context ctx, int target, int numPts, float[] pts) {
    }

    @Override
    int getMaximumLights() {
        return 8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void resizeOffscreenLayer(Canvas3D cv, int cvWidth, int cvHeight) {
        block14: {
            if (!JoglPipeline.isOffscreenLayerSurfaceEnabled(cv)) {
                return;
            }
            JoglDrawable joglDrawable = (JoglDrawable)cv.drawable;
            if (!JoglPipeline.hasFBObjectSizeChanged(joglDrawable, cvWidth, cvHeight)) {
                return;
            }
            int newWidth = Math.max(1, cvWidth);
            int newHeight = Math.max(1, cvHeight);
            GLDrawable glDrawble = joglDrawable.getGLDrawable();
            GLContext glContext = this.context(cv.ctx);
            NativeSurface surface = glDrawble.getNativeSurface();
            ProxySurface proxySurface = surface instanceof ProxySurface ? (ProxySurface)surface : null;
            int lockRes = surface.lockSurface();
            try {
                UpstreamSurfaceHook ush;
                if (proxySurface != null && (ush = proxySurface.getUpstreamSurfaceHook()) instanceof UpstreamSurfaceHook.MutableSize) {
                    ((UpstreamSurfaceHook.MutableSize)ush).setSurfaceSize(newWidth, newHeight);
                }
                GL2 gl = glContext.getGL().getGL2();
                if (glDrawble instanceof GLFBODrawable) {
                    int numSamples = ((GLFBODrawable)glDrawble).getChosenGLCapabilities().getNumSamples();
                    FBObject fboObjectBack = ((GLFBODrawable)glDrawble).getFBObject(1029);
                    fboObjectBack.reset((GL)gl, newWidth, newHeight, numSamples);
                    fboObjectBack.bind((GL)gl);
                    break block14;
                }
                GLContext currentContext = GLContext.getCurrent();
                GLDrawableFactory factory = glDrawble.getFactory();
                if (currentContext != glContext) {
                    glContext.makeCurrent();
                }
                gl.glFinish();
                glContext.release();
                if (proxySurface != null) {
                    proxySurface.enableUpstreamSurfaceHookLifecycle(false);
                }
                try {
                    glDrawble.setRealized(false);
                    glDrawble = factory.createGLDrawable(surface);
                    glDrawble.setRealized(true);
                    joglDrawable.setGLDrawable(glDrawble);
                }
                finally {
                    if (proxySurface != null) {
                        proxySurface.enableUpstreamSurfaceHookLifecycle(true);
                    }
                }
                glContext.setGLDrawable(glDrawble, true);
                if (currentContext != null) {
                    currentContext.makeCurrent();
                }
            }
            finally {
                surface.unlockSurface();
            }
        }
    }

    private void checkAppContext() {
        if (this.mainThreadContext == null) {
            return;
        }
        try {
            Class<?> appContextClass = Class.forName("sun.awt.AppContext");
            if (appContextClass.getMethod("getAppContext", new Class[0]).invoke(null, new Object[0]) == null) {
                Field field = appContextClass.getDeclaredField("threadGroup2appContext");
                field.setAccessible(true);
                Map threadGroup2appContext = (Map)field.get(null);
                ThreadGroup currentThreadGroup = Thread.currentThread().getThreadGroup();
                threadGroup2appContext.put(currentThreadGroup, this.mainThreadContext);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.mainThreadContext = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Context createNewContext(Canvas3D cv, Drawable drawable, Context shareCtx, boolean isSharedCtx, boolean offScreen) {
        this.checkAppContext();
        GLDrawable glDrawable = null;
        GLContext glContext = null;
        if (offScreen) {
            glDrawable = this.drawable(cv.drawable);
            glContext = glDrawable.createContext(this.context(shareCtx));
        } else {
            GraphicsConfigInfo gcInf0 = Canvas3D.graphicsConfigTable.get(cv.graphicsConfiguration);
            AWTGraphicsConfiguration awtConfig = (AWTGraphicsConfiguration)gcInf0.getPrivateData();
            JAWTWindow nativeWindow = (JAWTWindow)NativeWindowFactory.getNativeWindow((Object)cv, (AbstractGraphicsConfiguration)awtConfig);
            nativeWindow.lockSurface();
            try {
                glDrawable = GLDrawableFactory.getFactory((GLProfile)this.profile).createGLDrawable((NativeSurface)nativeWindow);
                glContext = glDrawable.createContext(this.context(shareCtx));
            }
            finally {
                nativeWindow.unlockSurface();
            }
            cv.drawable = new JoglDrawable(glDrawable, (NativeWindow)nativeWindow);
        }
        glDrawable.setRealized(true);
        boolean failed = false;
        int failCount = 0;
        int MAX_FAIL_COUNT = 5;
        do {
            failed = false;
            int res = glContext.makeCurrent();
            if (res != 0) continue;
            failed = true;
            ++failCount;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        } while (failed && failCount < MAX_FAIL_COUNT);
        if (failCount == MAX_FAIL_COUNT) {
            throw new IllegalRenderingStateException("Unable to make new context current after " + failCount + "tries");
        }
        GL2 gl = glContext.getGL().getGL2();
        JoglContext ctx = new JoglContext(glContext);
        try {
            if (!this.getPropertiesFromCurrentContext(ctx, gl)) {
                throw new IllegalRenderingStateException("Unable to fetch properties from current OpenGL context");
            }
            if (!isSharedCtx) {
                this.setupCanvasProperties(cv, ctx, (GL)gl);
            }
            gl.glEnable(32826);
            gl.glColorMaterial(1032, 4609);
            gl.glDepthFunc(515);
            gl.glEnable(2903);
            gl.glPixelStorei(3317, 1);
            gl.glLightModeli(33272, 33274);
            if (!offScreen && glDrawable instanceof GLFBODrawable) {
                GLFBODrawable fboDrawable = (GLFBODrawable)glDrawable;
                fboDrawable.getFBObject(1029).bind((GL)gl);
            }
            if (offScreen) {
                GLCapabilitiesImmutable chosenCaps = glDrawable.getChosenGLCapabilities();
                if (glDrawable instanceof GLFBODrawable) {
                    GLFBODrawable fboDrawable = (GLFBODrawable)glDrawable;
                    fboDrawable.getFBObject(1029).bind((GL)gl);
                } else if (chosenCaps.getDoubleBuffered()) {
                    gl.glReadBuffer(1029);
                } else {
                    gl.glReadBuffer(1028);
                }
            }
        }
        finally {
            glContext.release();
        }
        return ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void createQueryContext(Canvas3D cv, Drawable drawable, boolean offScreen, int width, int height) {
        if (offScreen) {
            Drawable offDrawable = this.createOffScreenBuffer(cv, null, width, height);
            GLDrawable glDrawable = this.drawable(offDrawable);
            glDrawable.setRealized(true);
            GLContext glContext = glDrawable.createContext(null);
            glContext.makeCurrent();
            JoglContext ctx = new JoglContext(glContext);
            GL2 gl = glContext.getGL().getGL2();
            this.getPropertiesFromCurrentContext(ctx, gl);
            this.setupCanvasProperties(cv, ctx, (GL)gl);
            glContext.release();
            glContext.destroy();
            glDrawable.setRealized(false);
        } else {
            ContextQuerier querier = new ContextQuerier(cv);
            AWTGraphicsConfiguration awtConfig = (AWTGraphicsConfiguration)Canvas3D.graphicsConfigTable.get(cv.graphicsConfiguration).getPrivateData();
            QueryCanvas canvas = new QueryCanvas(awtConfig, querier);
            Frame f = new Frame(canvas.getGraphicsConfiguration());
            Dialog d = new Dialog(f);
            d.setUndecorated(true);
            d.setLayout(new BorderLayout());
            d.add((Component)canvas, "Center");
            d.setSize(1, 1);
            d.setVisible(true);
            canvas.doQuery();
            if (!EventQueue.isDispatchThread()) {
                ContextQuerier contextQuerier = querier;
                synchronized (contextQuerier) {
                    if (!querier.done()) {
                        try {
                            querier.wait(1000L);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                    }
                }
            }
            JoglPipeline.disposeOnEDT(d);
            JoglPipeline.disposeOnEDT(f);
        }
    }

    @Override
    Drawable createOffScreenBuffer(Canvas3D cv, Context ctx, int width, int height) {
        JoglGraphicsConfiguration jgc = (JoglGraphicsConfiguration)cv.graphicsConfiguration;
        GraphicsConfigInfo gcInf0 = Canvas3D.graphicsConfigTable.get(jgc);
        AWTGraphicsConfiguration awtConfig = (AWTGraphicsConfiguration)gcInf0.getPrivateData();
        AbstractGraphicsDevice device = GLDrawableFactory.getDesktopFactory().getDefaultDevice();
        GLCapabilities canvasCaps = (GLCapabilities)awtConfig.getChosenCapabilities();
        GraphicsConfigTemplate3D gct3D = gcInf0.getGraphicsConfigTemplate3D();
        GLCapabilities offCaps = new GLCapabilities(this.profile);
        offCaps.copyFrom((GLCapabilitiesImmutable)canvasCaps);
        if (!offCaps.getSampleBuffers()) {
            offCaps.setDoubleBuffered(false);
            offCaps.setNumSamples(0);
        }
        offCaps.setStereo(false);
        offCaps.setFBO(true);
        GLDrawable offDrawable = GLDrawableFactory.getFactory((GLProfile)this.profile).createOffscreenDrawable(device, (GLCapabilitiesImmutable)offCaps, null, width, height);
        return new JoglDrawable(offDrawable, null);
    }

    @Override
    void destroyOffScreenBuffer(Canvas3D cv, Context ctx, Drawable drawable) {
    }

    @Override
    void readOffScreenBuffer(Canvas3D cv, Context ctx, int format, int dataType, Object data, int width, int height) {
        GLDrawable glDrawable = ((JoglDrawable)cv.drawable).getGLDrawable();
        GLCapabilitiesImmutable chosenCaps = glDrawable.getChosenGLCapabilities();
        GLFBODrawable fboDrawable = null;
        GL2 gl = this.context(ctx).getGL().getGL2();
        if (chosenCaps.isFBO()) {
            fboDrawable = (GLFBODrawable)glDrawable;
            if (chosenCaps.getDoubleBuffered()) {
                fboDrawable.swapBuffers();
                gl.glBindTexture(3553, 0);
            }
            fboDrawable.getFBObject(1028).bind((GL)gl);
        }
        gl.glPixelStorei(3330, width);
        gl.glPixelStorei(3333, 1);
        int type = 0;
        if (dataType == 4096 || dataType == 16384) {
            switch (format) {
                case 1: {
                    type = 32992;
                    break;
                }
                case 2: {
                    type = 6407;
                    break;
                }
                case 4: {
                    if (gl.isExtensionAvailable("GL_EXT_abgr")) {
                        type = 32768;
                        break;
                    }
                    assert (false);
                    return;
                }
                case 8: {
                    type = 6408;
                    break;
                }
                default: {
                    throw new AssertionError((Object)("illegal format " + format));
                }
            }
            gl.glReadPixels(0, 0, width, height, type, 5121, (Buffer)ByteBuffer.wrap((byte[])data));
        } else if (dataType == 8192 || dataType == 32768) {
            int intType = 32821;
            boolean forceAlphaToOne = false;
            switch (format) {
                case 128: {
                    type = 6408;
                    intType = 33639;
                    forceAlphaToOne = true;
                    break;
                }
                case 256: {
                    forceAlphaToOne = true;
                }
                case 512: {
                    type = 32993;
                    intType = 33639;
                    break;
                }
                default: {
                    throw new AssertionError((Object)("illegal format " + format));
                }
            }
            if (forceAlphaToOne) {
                gl.glPixelTransferf(3356, 0.0f);
                gl.glPixelTransferf(3357, 1.0f);
            }
            gl.glReadPixels(0, 0, width, height, type, intType, (Buffer)IntBuffer.wrap((int[])data));
            if (forceAlphaToOne) {
                gl.glPixelTransferf(3356, 1.0f);
                gl.glPixelTransferf(3357, 0.0f);
            }
        } else {
            throw new AssertionError((Object)("illegal image data type " + dataType));
        }
        if (chosenCaps.isFBO()) {
            fboDrawable.getFBObject(1029).bind((GL)gl);
        }
    }

    @Override
    void swapBuffers(Canvas3D cv, Context ctx, Drawable drawable) {
        GLDrawable draw = this.drawable(drawable);
        draw.swapBuffers();
    }

    @Override
    void updateMaterialColor(Context ctx, float r, float g, float b, float a) {
        GL2 gl = this.context(ctx).getGL().getGL2();
        gl.glDisable(2896);
    }

    @Override
    void destroyContext(Drawable drawable, Context ctx) {
        JoglDrawable joglDrawable = (JoglDrawable)drawable;
        GLContext context = this.context(ctx);
        if (GLContext.getCurrent() == context) {
            context.release();
        }
        context.destroy();
        joglDrawable.getGLDrawable().setRealized(false);
        joglDrawable.destroyNativeWindow();
    }

    @Override
    void accum(Context ctx, float value) {
        GL2 gl = this.context(ctx).getGL().getGL2();
        gl.glReadBuffer(1029);
        gl.glAccum(256, value);
        gl.glReadBuffer(1028);
    }

    @Override
    void accumReturn(Context ctx) {
        GL2 gl = this.context(ctx).getGL().getGL2();
        gl.glAccum(258, 1.0f);
    }

    @Override
    void clearAccum(Context ctx) {
        GL gl = this.context(ctx).getGL();
        gl.glClear(512);
    }

    @Override
    int getNumCtxLights(Context ctx) {
        GL gl = this.context(ctx).getGL();
        int[] res = new int[1];
        gl.glGetIntegerv(3377, res, 0);
        return res[0];
    }

    @Override
    boolean decal1stChildSetup(Context ctx) {
        GL gl = this.context(ctx).getGL();
        gl.glEnable(2960);
        gl.glClearStencil(0);
        gl.glClear(1024);
        gl.glStencilFunc(519, 1, 1);
        gl.glStencilOp(7680, 7680, 7681);
        return gl.glIsEnabled(2929);
    }

    @Override
    void decalNthChildSetup(Context ctx) {
        GL gl = this.context(ctx).getGL();
        gl.glDisable(2929);
        gl.glStencilFunc(514, 1, 1);
        gl.glStencilOp(7680, 7680, 7680);
    }

    @Override
    void decalReset(Context ctx, boolean depthBufferEnable) {
        GL gl = this.context(ctx).getGL();
        gl.glDisable(2960);
        if (depthBufferEnable) {
            gl.glEnable(2929);
        }
    }

    @Override
    void ctxUpdateEyeLightingEnable(Context ctx, boolean localEyeLightingEnable) {
        GL2 gl = this.context(ctx).getGL().getGL2();
        if (localEyeLightingEnable) {
            gl.glLightModeli(2897, 1);
        } else {
            gl.glLightModeli(2897, 0);
        }
    }

    @Override
    void setBlendColor(Context ctx, float red, float green, float blue, float alpha) {
        GL2 gl = this.context(ctx).getGL().getGL2();
        if (gl.isExtensionAvailable("GL_ARB_imaging")) {
            gl.glBlendColor(red, green, blue, alpha);
        }
    }

    @Override
    void setBlendFunc(Context ctx, int srcBlendFunction, int dstBlendFunction) {
        GL gl = this.context(ctx).getGL();
        gl.glEnable(3042);
        gl.glBlendFunc(blendFunctionTable[srcBlendFunction], blendFunctionTable[dstBlendFunction]);
    }

    @Override
    void setFogEnableFlag(Context ctx, boolean enable) {
        GL gl = this.context(ctx).getGL();
        if (enable) {
            gl.glEnable(2912);
        } else {
            gl.glDisable(2912);
        }
    }

    @Override
    void setFullSceneAntialiasing(Context absCtx, boolean enable) {
        JoglContext ctx = (JoglContext)absCtx;
        GL gl = this.context(ctx).getGL();
        if (ctx.getHasMultisample() && !VirtualUniverse.mc.implicitAntialiasing) {
            if (enable) {
                gl.glEnable(32925);
            } else {
                gl.glDisable(32925);
            }
        }
    }

    @Override
    void updateSeparateSpecularColorEnable(Context ctx, boolean enable) {
        GL2 gl = this.context(ctx).getGL().getGL2();
        if (enable) {
            gl.glLightModeli(33272, 33274);
        } else {
            gl.glLightModeli(33272, 33273);
        }
    }

    @Override
    boolean validGraphicsMode() {
        DisplayMode currentMode = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDisplayMode();
        return currentMode.getBitDepth() < 0 || currentMode.getBitDepth() > 8;
    }

    @Override
    void setLightEnables(Context ctx, long enableMask, int maxLights) {
        GL gl = this.context(ctx).getGL();
        for (int i = 0; i < maxLights; ++i) {
            if ((enableMask & (long)(1 << i)) != 0L) {
                gl.glEnable(16384 + i);
                continue;
            }
            gl.glDisable(16384 + i);
        }
    }

    @Override
    void setSceneAmbient(Context ctx, float red, float green, float blue) {
        GL2 gl = this.context(ctx).getGL().getGL2();
        float[] color = new float[]{red, green, blue, 1.0f};
        gl.glLightModelfv(2899, color, 0);
    }

    @Override
    void disableFog(Context ctx) {
        GL gl = this.context(ctx).getGL();
        gl.glDisable(2912);
    }

    @Override
    void disableModelClip(Context ctx) {
        GL gl = this.context(ctx).getGL();
        gl.glDisable(12288);
        gl.glDisable(12289);
        gl.glDisable(12290);
        gl.glDisable(12291);
        gl.glDisable(12292);
        gl.glDisable(12293);
    }

    @Override
    void resetRenderingAttributes(Context ctx, boolean depthBufferWriteEnableOverride, boolean depthBufferEnableOverride) {
        GL2 gl = this.context(ctx).getGL().getGL2();
        if (!depthBufferWriteEnableOverride) {
            gl.glDepthMask(true);
        }
        if (!depthBufferEnableOverride) {
            gl.glEnable(2929);
        }
        gl.glAlphaFunc(519, 0.0f);
        gl.glDepthFunc(515);
        gl.glEnable(2903);
        gl.glDisable(3058);
        gl.glDisable(2960);
    }

    @Override
    void resetTextureNative(Context ctx, int texUnitIndex) {
        GL2 gl = this.context(ctx).getGL().getGL2();
        if (texUnitIndex >= 0 && gl.isExtensionAvailable("GL_VERSION_1_3")) {
            gl.glActiveTexture(texUnitIndex + 33984);
            gl.glClientActiveTexture(texUnitIndex + 33984);
        }
        gl.glDisable(3552);
        gl.glDisable(3553);
        gl.glDisable(32879);
        gl.glDisable(34067);
    }

    @Override
    void activeTextureUnit(Context ctx, int texUnitIndex) {
        GL2 gl = this.context(ctx).getGL().getGL2();
        if (gl.isExtensionAvailable("GL_VERSION_1_3")) {
            gl.glActiveTexture(texUnitIndex + 33984);
            gl.glClientActiveTexture(texUnitIndex + 33984);
        }
    }

    @Override
    void resetTexCoordGeneration(Context ctx) {
        GL gl = this.context(ctx).getGL();
        gl.glDisable(3168);
        gl.glDisable(3169);
        gl.glDisable(3170);
        gl.glDisable(3171);
    }

    @Override
    void resetTextureAttributes(Context ctx) {
        GL2 gl = this.context(ctx).getGL().getGL2();
        float[] color = new float[4];
        gl.glPushAttrib(4096);
        gl.glMatrixMode(5890);
        gl.glLoadIdentity();
        gl.glPopAttrib();
        gl.glTexEnvfv(8960, 8705, color, 0);
        gl.glTexEnvi(8960, 8704, 7681);
        gl.glHint(3152, 4354);
    }

    @Override
    void resetPolygonAttributes(Context ctx) {
        GL2 gl = this.context(ctx).getGL().getGL2();
        gl.glCullFace(1029);
        gl.glEnable(2884);
        gl.glLightModeli(2898, 0);
        gl.glPolygonMode(1032, 6914);
        gl.glPolygonOffset(0.0f, 0.0f);
        gl.glDisable(10753);
        gl.glDisable(10754);
        gl.glDisable(32823);
    }

    @Override
    void resetLineAttributes(Context ctx) {
        GL gl = this.context(ctx).getGL();
        gl.glLineWidth(1.0f);
        gl.glDisable(2852);
        gl.glDisable(2848);
    }

    @Override
    void resetPointAttributes(Context ctx) {
        GL2 gl = this.context(ctx).getGL().getGL2();
        gl.glPointSize(1.0f);
        gl.glDisable(2832);
    }

    @Override
    void resetTransparency(Context ctx, int geometryType, int polygonMode, boolean lineAA, boolean pointAA) {
        GL gl = this.context(ctx).getGL();
        if (((geometryType & 2) != 0 || polygonMode == 1) && lineAA || ((geometryType & 1) != 0 || polygonMode == 0) && pointAA) {
            gl.glEnable(3042);
            gl.glBlendFunc(770, 771);
        } else {
            gl.glDisable(3042);
        }
        gl.glDisable(2882);
    }

    @Override
    void resetColoringAttributes(Context ctx, float r, float g, float b, float a, boolean enableLight) {
        GL2 gl = this.context(ctx).getGL().getGL2();
        if (!enableLight) {
            // empty if block
        }
        gl.glShadeModel(7425);
    }

    @Override
    void syncRender(Context ctx, boolean wait) {
        GL gl = this.context(ctx).getGL();
        if (wait) {
            gl.glFinish();
        } else {
            gl.glFlush();
        }
    }

    @Override
    boolean useCtx(Context ctx, Drawable drawable) {
        GLContext context = this.context(ctx);
        int res = context.makeCurrent();
        return res != 0;
    }

    @Override
    boolean releaseCtx(Context ctx) {
        GLContext context = this.context(ctx);
        if (context.isCurrent()) {
            context.release();
        }
        return true;
    }

    @Override
    void clear(Context ctx, float r, float g, float b, boolean clearStencil) {
        JoglContext jctx = (JoglContext)ctx;
        GLContext context = this.context(ctx);
        GL2 gl = context.getGL().getGL2();
        int clearMask = 16640;
        if (clearStencil) {
            gl.glPushAttrib(1280);
            gl.glClearStencil(0);
            gl.glStencilMask(-1);
            clearMask |= 0x400;
        } else {
            gl.glPushAttrib(256);
        }
        gl.glDepthMask(true);
        gl.glClearColor(r, g, b, jctx.getAlphaClearValue());
        gl.glClear(clearMask);
        gl.glPopAttrib();
    }

    @Override
    void textureFillBackground(Context ctx, float texMinU, float texMaxU, float texMinV, float texMaxV, float mapMinX, float mapMaxX, float mapMinY, float mapMaxY, boolean useBilinearFilter) {
        GLContext context = this.context(ctx);
        GL2 gl = context.getGL().getGL2();
        gl.glPushAttrib(270344);
        this.disableAttribFor2D((GL)gl);
        gl.glDepthMask(false);
        gl.glEnable(3553);
        if (useBilinearFilter) {
            gl.glTexParameteri(3553, 10241, 9729);
            gl.glTexParameteri(3553, 10240, 9729);
        }
        gl.glPolygonMode(1032, 6914);
        gl.glPixelStorei(3317, 1);
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        gl.glOrtho(-1.0, 1.0, -1.0, 1.0, -1.0, 1.0);
        gl.glMatrixMode(5888);
        gl.glLoadIdentity();
        gl.glMatrixMode(5890);
        gl.glPushMatrix();
        gl.glLoadIdentity();
        gl.glBegin(7);
        gl.glTexCoord2f(texMinU, texMinV);
        gl.glVertex2f(mapMinX, mapMinY);
        gl.glTexCoord2f(texMaxU, texMinV);
        gl.glVertex2f(mapMaxX, mapMinY);
        gl.glTexCoord2f(texMaxU, texMaxV);
        gl.glVertex2f(mapMaxX, mapMaxY);
        gl.glTexCoord2f(texMinU, texMaxV);
        gl.glVertex2f(mapMinX, mapMaxY);
        gl.glEnd();
        gl.glPopMatrix();
        gl.glMatrixMode(5888);
        gl.glPopAttrib();
    }

    @Override
    void textureFillRaster(Context ctx, float texMinU, float texMaxU, float texMinV, float texMaxV, float mapMinX, float mapMaxX, float mapMinY, float mapMaxY, float mapZ, float alpha, boolean useBilinearFilter) {
        GLContext context = this.context(ctx);
        GL2 gl = context.getGL().getGL2();
        gl.glPushAttrib(270345);
        this.disableAttribForRaster((GL)gl);
        if (useBilinearFilter) {
            gl.glTexParameteri(3553, 10241, 9729);
            gl.glTexParameteri(3553, 10240, 9729);
        }
        gl.glTexEnvi(8960, 8704, 8448);
        gl.glColor4f(1.0f, 1.0f, 1.0f, alpha);
        gl.glPolygonMode(1032, 6914);
        gl.glPixelStorei(3317, 1);
        gl.glMatrixMode(5888);
        gl.glPushMatrix();
        gl.glLoadIdentity();
        gl.glMatrixMode(5889);
        gl.glPushMatrix();
        gl.glLoadIdentity();
        gl.glOrtho(0.0, 1.0, 0.0, 1.0, 0.0, 1.0);
        gl.glBegin(7);
        gl.glTexCoord2f(texMinU, texMinV);
        gl.glVertex3f(mapMinX, mapMinY, mapZ);
        gl.glTexCoord2f(texMaxU, texMinV);
        gl.glVertex3f(mapMaxX, mapMinY, mapZ);
        gl.glTexCoord2f(texMaxU, texMaxV);
        gl.glVertex3f(mapMaxX, mapMaxY, mapZ);
        gl.glTexCoord2f(texMinU, texMaxV);
        gl.glVertex3f(mapMinX, mapMaxY, mapZ);
        gl.glEnd();
        gl.glPopMatrix();
        gl.glMatrixMode(5888);
        gl.glPopMatrix();
        gl.glPopAttrib();
    }

    @Override
    void executeRasterDepth(Context ctx, float posX, float posY, float posZ, int srcOffsetX, int srcOffsetY, int rasterWidth, int rasterHeight, int depthWidth, int depthHeight, int depthFormat, Object depthData) {
        GLContext context = this.context(ctx);
        GL2 gl = context.getGL().getGL2();
        gl.glRasterPos3f(posX, posY, posZ);
        int[] drawBuf = new int[1];
        gl.glGetIntegerv(3073, drawBuf, 0);
        gl.glDrawBuffer(0);
        gl.glPixelZoom(1.0f, -1.0f);
        gl.glPixelStorei(3314, depthWidth);
        if (srcOffsetX >= 0) {
            gl.glPixelStorei(3316, srcOffsetX);
            if (srcOffsetX + rasterWidth > depthWidth) {
                rasterWidth = depthWidth - srcOffsetX;
            }
        } else if ((rasterWidth += srcOffsetX) > depthWidth) {
            rasterWidth = depthWidth;
        }
        if (srcOffsetY >= 0) {
            gl.glPixelStorei(3315, srcOffsetY);
            if (srcOffsetY + rasterHeight > depthHeight) {
                rasterHeight = depthHeight - srcOffsetY;
            }
        } else if ((rasterHeight += srcOffsetY) > depthHeight) {
            rasterHeight = depthHeight;
        }
        if (depthFormat == 1) {
            gl.glDrawPixels(rasterWidth, rasterHeight, 6402, 5125, (Buffer)IntBuffer.wrap((int[])depthData));
        } else {
            gl.glDrawPixels(rasterWidth, rasterHeight, 6402, 5126, (Buffer)FloatBuffer.wrap((float[])depthData));
        }
        gl.glDrawBuffer(drawBuf[0]);
        gl.glPixelStorei(3314, 0);
        gl.glPixelStorei(3316, 0);
        gl.glPixelStorei(3315, 0);
    }

    @Override
    void setModelViewMatrix(Context ctx, double[] viewMatrix, double[] modelMatrix) {
        GLContext context = this.context(ctx);
        GL2 gl = context.getGL().getGL2();
        gl.glMatrixMode(5888);
        if (gl.isExtensionAvailable("GL_VERSION_1_3")) {
            gl.glLoadTransposeMatrixd(viewMatrix, 0);
            gl.glMultTransposeMatrixd(modelMatrix, 0);
        } else {
            double[] v = new double[16];
            double[] m = new double[16];
            this.copyTranspose(viewMatrix, v);
            this.copyTranspose(modelMatrix, m);
            gl.glLoadMatrixd(v, 0);
            gl.glMultMatrixd(m, 0);
        }
    }

    @Override
    void setProjectionMatrix(Context ctx, double[] projMatrix) {
        GLContext context = this.context(ctx);
        GL2 gl = context.getGL().getGL2();
        gl.glMatrixMode(5889);
        if (gl.isExtensionAvailable("GL_VERSION_1_3")) {
            projMatrix[8] = projMatrix[8] * -1.0;
            projMatrix[9] = projMatrix[9] * -1.0;
            projMatrix[10] = projMatrix[10] * -1.0;
            projMatrix[11] = projMatrix[11] * -1.0;
            gl.glLoadTransposeMatrixd(projMatrix, 0);
            projMatrix[8] = projMatrix[8] * -1.0;
            projMatrix[9] = projMatrix[9] * -1.0;
            projMatrix[10] = projMatrix[10] * -1.0;
            projMatrix[11] = projMatrix[11] * -1.0;
        } else {
            double[] p = new double[16];
            this.copyTranspose(projMatrix, p);
            p[2] = p[2] * -1.0;
            p[6] = p[6] * -1.0;
            p[10] = p[10] * -1.0;
            p[14] = p[14] * -1.0;
            gl.glLoadMatrixd(p, 0);
        }
    }

    static boolean isOffscreenLayerSurfaceEnabled(Canvas3D cv) {
        if (cv.drawable == null || cv.offScreen) {
            return false;
        }
        JoglDrawable joglDrawble = (JoglDrawable)cv.drawable;
        JAWTWindow jawtwindow = (JAWTWindow)joglDrawble.getNativeWindow();
        if (jawtwindow == null) {
            return false;
        }
        return jawtwindow.isOffscreenLayerSurfaceEnabled();
    }

    static boolean hasFBObjectSizeChanged(JoglDrawable jdraw, int width, int height) {
        if (!(jdraw.getGLDrawable() instanceof GLFBODrawable)) {
            return false;
        }
        FBObject fboBack = ((GLFBODrawable)jdraw.getGLDrawable()).getFBObject(1029);
        if (fboBack == null) {
            return false;
        }
        return width != fboBack.getWidth() || height != fboBack.getHeight();
    }

    @Override
    void setViewport(Context ctx, int x, int y, int width, int height) {
        GL gl = this.context(ctx).getGL();
        gl.glViewport(x, y, width, height);
    }

    @Override
    void newDisplayList(Context ctx, int displayListId) {
        if (displayListId <= 0) {
            System.err.println("JAVA 3D ERROR : glNewList(" + displayListId + ") -- IGNORED");
        }
        GL2 gl = this.context(ctx).getGL().getGL2();
        gl.glNewList(displayListId, 4864);
    }

    @Override
    void endDisplayList(Context ctx) {
        GL2 gl = this.context(ctx).getGL().getGL2();
        gl.glEndList();
    }

    @Override
    void callDisplayList(Context ctx, int id, boolean isNonUniformScale) {
        if (id <= 0) {
            if (this.numInvalidLists < 3) {
                ++this.numInvalidLists;
                System.err.println("JAVA 3D ERROR : glCallList(" + id + ") -- IGNORED");
            } else if (this.numInvalidLists == 3) {
                ++this.numInvalidLists;
                System.err.println("JAVA 3D : further glCallList error messages discarded");
            }
            return;
        }
        GL2 gl = this.context(ctx).getGL().getGL2();
        if (isNonUniformScale) {
            gl.glEnable(2977);
        }
        gl.glCallList(id);
        if (isNonUniformScale) {
            gl.glDisable(2977);
        }
    }

    @Override
    void freeDisplayList(Context ctx, int id) {
        if (id <= 0) {
            System.err.println("JAVA 3D ERROR : glDeleteLists(" + id + ",1) -- IGNORED");
        }
        GL2 gl = this.context(ctx).getGL().getGL2();
        gl.glDeleteLists(id, 1);
    }

    @Override
    void freeTexture(Context ctx, int id) {
        GL gl = this.context(ctx).getGL();
        if (id > 0) {
            int[] tmp = new int[]{id};
            gl.glDeleteTextures(1, tmp, 0);
        } else {
            System.err.println("tried to delete tex with texid <= 0");
        }
    }

    @Override
    int generateTexID(Context ctx) {
        GL gl = this.context(ctx).getGL();
        int[] tmp = new int[]{-1};
        gl.glGenTextures(1, tmp, 0);
        if (tmp[0] < 1) {
            return -1;
        }
        return tmp[0];
    }

    @Override
    void texturemapping(Context ctx, int px, int py, int minX, int minY, int maxX, int maxY, int texWidth, int texHeight, int rasWidth, int format, int objectId, byte[] imageYdown, int winWidth, int winHeight) {
        GL2 gl = this.context(ctx).getGL().getGL2();
        int glType = 6408;
        gl.glPushAttrib(270600);
        this.disableAttribFor2D((GL)gl);
        gl.glPolygonMode(1032, 6914);
        gl.glDepthMask(false);
        gl.glPixelStorei(3317, 1);
        gl.glBindTexture(3553, objectId);
        gl.glTexParameteri(3553, 10240, 9729);
        gl.glTexParameteri(3553, 10241, 9729);
        gl.glTexParameteri(3553, 10242, 10497);
        gl.glTexParameteri(3553, 10243, 10497);
        gl.glTexEnvf(8960, 8704, 7681.0f);
        gl.glEnable(3042);
        gl.glBlendFunc(770, 771);
        gl.glEnable(3553);
        gl.glPushAttrib(4096);
        gl.glMatrixMode(5890);
        gl.glLoadIdentity();
        gl.glPopAttrib();
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        gl.glOrtho(0.0, (double)winWidth, 0.0, (double)winHeight, 0.0, 0.0);
        gl.glMatrixMode(5888);
        gl.glLoadIdentity();
        if (gl.isExtensionAvailable("GL_EXT_abgr")) {
            glType = 32768;
        } else {
            switch (format) {
                case 8: {
                    glType = 6408;
                    break;
                }
                case 2: {
                    glType = 6407;
                }
            }
        }
        gl.glPixelStorei(3314, rasWidth);
        gl.glPixelStorei(3316, minX);
        gl.glPixelStorei(3315, minY);
        gl.glTexSubImage2D(3553, 0, minX, minY, maxX - minX, maxY - minY, glType, 5121, (Buffer)ByteBuffer.wrap(imageYdown));
        gl.glPixelStorei(3314, 0);
        gl.glPixelStorei(3316, 0);
        gl.glPixelStorei(3315, 0);
        float texMinU = (float)minX / (float)texWidth;
        float texMinV = (float)minY / (float)texHeight;
        float texMaxU = (float)maxX / (float)texWidth;
        float texMaxV = (float)maxY / (float)texHeight;
        float halfWidth = (float)winWidth / 2.0f;
        float halfHeight = (float)winHeight / 2.0f;
        float mapMinX = ((float)(px + minX) - halfWidth) / halfWidth;
        float mapMinY = (halfHeight - (float)(py + maxY)) / halfHeight;
        float mapMaxX = ((float)(px + maxX) - halfWidth) / halfWidth;
        float mapMaxY = (halfHeight - (float)(py + minY)) / halfHeight;
        gl.glBegin(7);
        gl.glTexCoord2f(texMinU, texMaxV);
        gl.glVertex2f(mapMinX, mapMinY);
        gl.glTexCoord2f(texMaxU, texMaxV);
        gl.glVertex2f(mapMaxX, mapMinY);
        gl.glTexCoord2f(texMaxU, texMinV);
        gl.glVertex2f(mapMaxX, mapMaxY);
        gl.glTexCoord2f(texMinU, texMinV);
        gl.glVertex2f(mapMinX, mapMaxY);
        gl.glEnd();
        gl.glDepthMask(true);
        gl.glClear(256);
        gl.glPopAttrib();
    }

    @Override
    boolean initTexturemapping(Context ctx, int texWidth, int texHeight, int objectId) {
        GL2 gl = this.context(ctx).getGL().getGL2();
        int glType = gl.isExtensionAvailable("GL_EXT_abgr") ? 32768 : 6408;
        gl.glBindTexture(3553, objectId);
        gl.glTexImage2D(32868, 0, 6408, texWidth, texHeight, 0, glType, 5121, null);
        int[] width = new int[1];
        gl.glGetTexLevelParameteriv(32868, 0, 4096, width, 0);
        if (width[0] <= 0) {
            return false;
        }
        gl.glTexImage2D(3553, 0, 6408, texWidth, texHeight, 0, glType, 5121, null);
        return true;
    }

    @Override
    void setRenderMode(Context ctx, int mode, boolean doubleBuffer) {
        GL2 gl = this.context(ctx).getGL().getGL2();
        int drawBuf = 0;
        if (doubleBuffer) {
            drawBuf = 1029;
            switch (mode) {
                case 0: {
                    drawBuf = 1026;
                    break;
                }
                case 1: {
                    drawBuf = 1027;
                    break;
                }
                case 2: {
                    drawBuf = 1029;
                }
            }
        } else {
            drawBuf = 1028;
            switch (mode) {
                case 0: {
                    drawBuf = 1024;
                    break;
                }
                case 1: {
                    drawBuf = 1025;
                    break;
                }
                case 2: {
                    drawBuf = 1028;
                }
            }
        }
        gl.glDrawBuffer(drawBuf);
    }

    @Override
    void setDepthBufferWriteEnable(Context ctx, boolean mode) {
        GL gl = this.context(ctx).getGL();
        if (mode) {
            gl.glDepthMask(true);
        } else {
            gl.glDepthMask(false);
        }
    }

    private boolean getPropertiesFromCurrentContext(JoglContext ctx, GL2 gl) {
        int[] tmp = new int[1];
        gl.glGetIntegerv(34018, tmp, 0);
        ctx.setMaxTexCoordSets(tmp[0]);
        if (VirtualUniverse.mc.transparentOffScreen) {
            ctx.setAlphaClearValue(0.0f);
        } else {
            ctx.setAlphaClearValue(1.0f);
        }
        if (gl.isExtensionAvailable("GL_ARB_vertex_shader")) {
            gl.glGetIntegerv(34929, tmp, 0);
            ctx.setMaxTexCoordSets(tmp[0]);
        }
        return true;
    }

    private int[] extractVersionInfo(String versionString) {
        StringTokenizer tok = new StringTokenizer(versionString, ". ");
        int major = Integer.valueOf(tok.nextToken());
        int minor = Integer.valueOf(tok.nextToken());
        tok = new StringTokenizer(versionString, " ");
        if (tok.hasMoreTokens()) {
            Pattern p;
            Matcher m;
            tok.nextToken();
            if (tok.hasMoreTokens() && (m = (p = Pattern.compile("\\D*(\\d+)\\.(\\d+)\\.?(\\d*).*")).matcher(tok.nextToken())).matches()) {
                int altMajor = Integer.valueOf(m.group(1));
                int altMinor = Integer.valueOf(m.group(2));
                if (altMajor == major && altMinor > minor) {
                    minor = altMinor;
                }
            }
        }
        return new int[]{major, minor};
    }

    private void checkTextureExtensions(Canvas3D cv, JoglContext ctx, GL gl, boolean gl13) {
        Object[] tmp;
        if (gl13) {
            cv.textureExtendedFeatures |= 4;
            cv.multiTexAccelerated = true;
            tmp = new int[1];
            gl.glGetIntegerv(34018, tmp, 0);
            cv.maxTexCoordSets = cv.maxTextureUnits = tmp[0];
            if (gl.isExtensionAvailable("GL_ARB_vertex_shader")) {
                gl.glGetIntegerv(34929, tmp, 0);
                cv.maxTexCoordSets = tmp[0];
            }
        }
        if (gl.isExtensionAvailable("GL_ARB_texture_env_combine")) {
            cv.textureExtendedFeatures |= 8;
            cv.textureExtendedFeatures |= 0x20;
        } else if (gl.isExtensionAvailable("GL_EXT_texture_env_combine")) {
            cv.textureExtendedFeatures |= 8;
        }
        if (gl.isExtensionAvailable("GL_ARB_texture_env_dot3") || gl.isExtensionAvailable("GL_EXT_texture_env_dot3")) {
            cv.textureExtendedFeatures |= 0x10;
        }
        if (gl13) {
            cv.textureExtendedFeatures |= 0x80;
        }
        if (gl.isExtensionAvailable("GL_EXT_texture_filter_anisotropic")) {
            cv.textureExtendedFeatures |= 0x800;
            tmp = new float[1];
            gl.glGetFloatv(34047, (float[])tmp, 0);
            cv.anisotropicDegreeMax = tmp[0];
        }
        if (!VirtualUniverse.mc.enforcePowerOfTwo && gl.isExtensionAvailable("GL_ARB_texture_non_power_of_two")) {
            cv.textureExtendedFeatures |= 0x8000;
        }
        if (gl.isExtensionAvailable("GL_SGIS_generate_mipmap")) {
            cv.textureExtendedFeatures |= 0x10000;
        }
    }

    private void checkGLSLShaderExtensions(Canvas3D cv, JoglContext ctx, GL gl, boolean hasgl13) {
        if (!hasgl13) {
            return;
        }
        if (gl.isExtensionAvailable("GL_ARB_shader_objects") && gl.isExtensionAvailable("GL_ARB_shading_language_100")) {
            int[] tmp = new int[1];
            gl.glGetIntegerv(34930, tmp, 0);
            cv.maxTextureImageUnits = tmp[0];
            gl.glGetIntegerv(35660, tmp, 0);
            cv.maxVertexTextureImageUnits = tmp[0];
            gl.glGetIntegerv(35661, tmp, 0);
            cv.maxCombinedTextureImageUnits = tmp[0];
            int vertexAttrOffset = VirtualUniverse.mc.glslVertexAttrOffset;
            ctx.setGLSLVertexAttrOffset(vertexAttrOffset);
            gl.glGetIntegerv(34921, tmp, 0);
            cv.maxVertexAttrs = tmp[0];
            cv.maxVertexAttrs -= vertexAttrOffset;
            if (cv.maxVertexAttrs < 0) {
                cv.maxVertexAttrs = 0;
            }
            cv.shadingLanguageGLSL = true;
        }
    }

    private void setupCanvasProperties(Canvas3D cv, JoglContext ctx, GL gl) {
        cv.multiTexAccelerated = false;
        cv.maxTextureUnits = 1;
        cv.maxTexCoordSets = 1;
        cv.maxTextureImageUnits = 0;
        cv.maxVertexTextureImageUnits = 0;
        cv.maxCombinedTextureImageUnits = 0;
        cv.maxVertexAttrs = 0;
        cv.extensionsSupported = 0;
        cv.textureExtendedFeatures = 0;
        cv.textureColorTableSize = 0;
        cv.anisotropicDegreeMax = 0.0f;
        cv.textureBoundaryWidthMax = 0;
        cv.textureWidthMax = 0;
        cv.textureHeightMax = 0;
        cv.texture3DWidthMax = 0;
        cv.texture3DHeightMax = 0;
        cv.texture3DDepthMax = 0;
        cv.shadingLanguageGLSL = false;
        String glVersion = gl.glGetString(7938);
        String glVendor = gl.glGetString(7936);
        String glRenderer = gl.glGetString(7937);
        cv.nativeGraphicsVersion = glVersion;
        cv.nativeGraphicsVendor = glVendor;
        cv.nativeGraphicsRenderer = glRenderer;
        int[] versionNumbers = this.extractVersionInfo(glVersion);
        int major = versionNumbers[0];
        int minor = versionNumbers[1];
        if (major < 1 || major == 1 && minor < 2) {
            if (glVendor.equalsIgnoreCase("Microsoft Corporation") && glRenderer.equalsIgnoreCase("GDI Generic") && glVersion.equalsIgnoreCase("1.1.0")) {
                System.err.println("Java3D - GDI Generic Driver use detected.");
                System.err.println("This may be caused by any of the following issues.");
                if (System.getProperty("sun.java2d.noddraw", "false").equals("true") || System.getProperty("sun.java2d.d3d", "true").equals("false")) {
                    System.err.println("Issue: Use of System.setProperty(\"sun.java2d.noddraw\", \"true\");");
                    System.err.println("or System.setProperty(\"sun.java2d.d3d\", \"false\");");
                    System.err.println("If either of these are being used please try either reversing or removing them,");
                    System.err.println("or if they are required else where try adding System.setProperty(\"sun.awt.nopixfmt\", \"true\");");
                }
                if (Platform.getOSName().equalsIgnoreCase("Windows 10") && Platform.JAVA_VERSION_NUMBER.compareTo(Platform.Version18) > 0 || Platform.JAVA_VERSION_NUMBER.compareTo(Platform.Version18) == 0 && Platform.JAVA_VERSION_UPDATE > 51 && Platform.getJavaVMName().toLowerCase().startsWith("java hotspot(tm)")) {
                    System.err.println("Issue: The use of an Intel HD2000/3000 driver in combination with Windows 10 and");
                    System.err.println("a JRE greater than 1.8 update 51. Please downgrade the JRE in use to JRE 1.8u51 or lower.");
                    System.err.println("For more information please see https://jogamp.org/bugzilla/show_bug.cgi?id=1278.");
                }
                System.err.println("If this software has been supplied to you and you are unable to modify it's configuration");
                System.err.println("please contact the suppler of this software with this entire message.");
            }
            throw new IllegalRenderingStateException("Java 3D ERROR : OpenGL 1.2 or better is required (GL_VERSION=" + major + "." + minor + ")");
        }
        boolean gl20 = false;
        boolean gl14 = false;
        boolean gl13 = false;
        if (major == 1) {
            if (minor == 2) {
                System.err.println("JAVA 3D: OpenGL 1.2 detected; will run with reduced functionality");
            }
            if (minor >= 3) {
                gl13 = true;
            }
            if (minor >= 4) {
                gl14 = true;
            }
        } else {
            gl13 = true;
            gl14 = true;
            gl20 = true;
        }
        if (gl20) {
            assert (gl13);
            assert (gl14);
            assert (gl.isExtensionAvailable("GL_VERSION_2_0"));
        }
        if (gl14) {
            assert (gl13);
            assert (gl.isExtensionAvailable("GL_VERSION_1_4"));
        }
        if (gl13) assert (gl.isExtensionAvailable("GL_VERSION_1_3"));
        cv.textureExtendedFeatures |= 1;
        cv.textureExtendedFeatures |= 0x1000;
        if (gl14) {
            cv.textureExtendedFeatures |= 0x10000;
        }
        if (gl.isExtensionAvailable("GL_EXT_abgr")) {
            cv.extensionsSupported |= 2;
        }
        cv.extensionsSupported |= 4;
        if (gl13) {
            cv.extensionsSupported |= 8;
            ctx.setHasMultisample(true);
        }
        if ((cv.extensionsSupported & 8) != 0 && !VirtualUniverse.mc.implicitAntialiasing) {
            gl.glDisable(32925);
        }
        this.checkTextureExtensions(cv, ctx, gl, gl13);
        this.checkGLSLShaderExtensions(cv, ctx, gl, gl13);
        cv.textureBoundaryWidthMax = 1;
        int[] tmp = new int[1];
        gl.glGetIntegerv(3379, tmp, 0);
        cv.textureWidthMax = tmp[0];
        cv.textureHeightMax = tmp[0];
        tmp[0] = -1;
        gl.glGetIntegerv(32883, tmp, 0);
        cv.texture3DWidthMax = tmp[0];
        cv.texture3DHeightMax = tmp[0];
        cv.texture3DDepthMax = tmp[0];
    }

    private void disableAttribFor2D(GL gl) {
        gl.glDisable(3008);
        gl.glDisable(3042);
        gl.glDisable(3058);
        gl.glDisable(2903);
        gl.glDisable(2884);
        gl.glDisable(2929);
        gl.glDisable(2912);
        gl.glDisable(2896);
        gl.glDisable(32823);
        gl.glDisable(2882);
        gl.glDisable(2960);
        gl.glDisable(3553);
        gl.glDisable(3171);
        gl.glDisable(3170);
        gl.glDisable(3168);
        gl.glDisable(3169);
        for (int i = 0; i < 6; ++i) {
            gl.glDisable(12288 + i);
        }
        gl.glDisable(32879);
        gl.glDisable(34067);
    }

    private void disableAttribForRaster(GL gl) {
        gl.glDisable(2903);
        gl.glDisable(2884);
        gl.glDisable(2896);
        gl.glDisable(32823);
        gl.glDisable(2882);
    }

    private void copyTranspose(double[] src, double[] dst) {
        dst[0] = src[0];
        dst[1] = src[4];
        dst[2] = src[8];
        dst[3] = src[12];
        dst[4] = src[1];
        dst[5] = src[5];
        dst[6] = src[9];
        dst[7] = src[13];
        dst[8] = src[2];
        dst[9] = src[6];
        dst[10] = src[10];
        dst[11] = src[14];
        dst[12] = src[3];
        dst[13] = src[7];
        dst[14] = src[11];
        dst[15] = src[15];
    }

    @Override
    GraphicsConfiguration getGraphicsConfig(GraphicsConfiguration gconfig) {
        GraphicsConfigInfo gcInf0 = Canvas3D.graphicsConfigTable.get(gconfig);
        AWTGraphicsConfiguration awtConfig = (AWTGraphicsConfiguration)gcInf0.getPrivateData();
        return awtConfig.getAWTGraphicsConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    GraphicsConfiguration getBestConfiguration(GraphicsConfigTemplate3D gct, GraphicsConfiguration[] gc) {
        GraphicsDevice device;
        this.checkAppContext();
        GLCapabilities caps = new GLCapabilities(this.profile);
        caps.setDoubleBuffered(gct.getDoubleBuffer() != 3);
        caps.setStereo(gct.getStereo() != 3);
        if (gct.getSceneAntialiasing() != 3 && gct.getDoubleBuffer() != 3) {
            caps.setSampleBuffers(true);
            int numSamples = MasterControl.getIntegerProperty("j3d.numSamples", 2);
            caps.setNumSamples(numSamples);
        } else {
            caps.setSampleBuffers(false);
            caps.setNumSamples(0);
        }
        caps.setDepthBits(gct.getDepthSize());
        caps.setStencilBits(gct.getStencilSize());
        caps.setRedBits(Math.max(5, gct.getRedSize()));
        caps.setGreenBits(Math.max(5, gct.getGreenSize()));
        caps.setBlueBits(Math.max(5, gct.getBlueSize()));
        if (VirtualUniverse.mc.transparentOffScreen) {
            caps.setAlphaBits(1);
        }
        ArrayList<DisabledCaps> capsToDisable = new ArrayList<DisabledCaps>();
        if (gct.getStereo() == 2) {
            capsToDisable.add(DisabledCaps.STEREO);
        }
        if (gct.getSceneAntialiasing() == 2) {
            capsToDisable.add(DisabledCaps.AA);
        }
        if (gct.getSceneAntialiasing() != 1 && gct.getDoubleBuffer() == 2) {
            capsToDisable.add(DisabledCaps.DOUBLE_BUFFER);
        }
        AbstractGraphicsScreen screen = (device = gc[0].getDevice()) != null ? AWTGraphicsScreen.createScreenDevice((GraphicsDevice)device, (int)0) : AWTGraphicsScreen.createDefault();
        boolean tryAgain = true;
        CapabilitiesCapturer capturer = null;
        AWTGraphicsConfiguration awtConfig = null;
        while (tryAgain) {
            Frame f = new Frame();
            Dialog d = new Dialog(f, null, false, device.getDefaultConfiguration());
            d.setUndecorated(true);
            d.setLayout(new BorderLayout());
            capturer = new CapabilitiesCapturer();
            try {
                awtConfig = JoglPipeline.createAwtGraphicsConfiguration(caps, (CapabilitiesChooser)capturer, screen);
                QueryCanvas canvas = new QueryCanvas(awtConfig, capturer);
                d.add((Component)canvas, "Center");
                d.setSize(1, 1);
                d.setVisible(true);
                canvas.doQuery();
                if (!EventQueue.isDispatchThread()) {
                    CapabilitiesCapturer capabilitiesCapturer = capturer;
                    synchronized (capabilitiesCapturer) {
                        if (!capturer.done()) {
                            try {
                                capturer.wait(1000L);
                            }
                            catch (InterruptedException e) {
                                // empty catch block
                            }
                        }
                    }
                }
                JoglPipeline.disposeOnEDT(d);
                JoglPipeline.disposeOnEDT(f);
                tryAgain = false;
            }
            catch (GLException e) {
                if (capsToDisable.size() == 0) {
                    tryAgain = false;
                    continue;
                }
                switch ((DisabledCaps)((Object)capsToDisable.remove(0))) {
                    case STEREO: {
                        caps.setStereo(false);
                        break;
                    }
                    case AA: {
                        caps.setSampleBuffers(false);
                        break;
                    }
                    case DOUBLE_BUFFER: {
                        caps.setDoubleBuffered(false);
                    }
                }
                awtConfig = null;
            }
        }
        int chosenIndex = capturer.getChosenIndex();
        GLCapabilities chosenCaps = null;
        chosenCaps = chosenIndex < 0 ? caps : capturer.getCapabilities();
        JoglGraphicsConfiguration config = new JoglGraphicsConfiguration(chosenCaps, chosenIndex, device);
        GraphicsConfigInfo gcInf0 = new GraphicsConfigInfo(gct);
        gcInf0.setPrivateData(awtConfig);
        Hashtable<GraphicsConfiguration, GraphicsConfigInfo> hashtable = Canvas3D.graphicsConfigTable;
        synchronized (hashtable) {
            Canvas3D.graphicsConfigTable.put(config, gcInf0);
        }
        return config;
    }

    @Override
    boolean isGraphicsConfigSupported(GraphicsConfigTemplate3D gct, GraphicsConfiguration gc) {
        return true;
    }

    @Override
    boolean hasDoubleBuffer(Canvas3D cv) {
        return this.caps(cv).getDoubleBuffered();
    }

    @Override
    boolean hasStereo(Canvas3D cv) {
        return this.caps(cv).getStereo();
    }

    @Override
    int getStencilSize(Canvas3D cv) {
        return this.caps(cv).getStencilBits();
    }

    @Override
    boolean hasSceneAntialiasingMultisample(Canvas3D cv) {
        return this.caps(cv).getSampleBuffers();
    }

    @Override
    boolean hasSceneAntialiasingAccum(Canvas3D cv) {
        GLCapabilities caps = this.caps(cv);
        return caps.getAccumRedBits() > 0 && caps.getAccumGreenBits() > 0 && caps.getAccumBlueBits() > 0;
    }

    @Override
    int getScreen(final GraphicsDevice graphicsDevice) {
        if (!this.checkedForGetScreenMethod) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    try {
                        JoglPipeline.this.getScreenMethod = graphicsDevice.getClass().getDeclaredMethod("getScreen", new Class[0]);
                        JoglPipeline.this.getScreenMethod.setAccessible(true);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    JoglPipeline.this.checkedForGetScreenMethod = true;
                    return null;
                }
            });
        }
        if (this.getScreenMethod != null) {
            try {
                return (Integer)this.getScreenMethod.invoke((Object)graphicsDevice, (Object[])null);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return 0;
    }

    private static AWTGraphicsConfiguration createAwtGraphicsConfiguration(GLCapabilities capabilities, CapabilitiesChooser chooser, AbstractGraphicsScreen screen) {
        GraphicsConfigurationFactory factory = GraphicsConfigurationFactory.getFactory(AWTGraphicsDevice.class, GLCapabilities.class);
        AWTGraphicsConfiguration awtGraphicsConfiguration = (AWTGraphicsConfiguration)factory.chooseGraphicsConfiguration((CapabilitiesImmutable)capabilities, (CapabilitiesImmutable)capabilities, chooser, screen, 0);
        return awtGraphicsConfiguration;
    }

    private static void disposeOnEDT(final Window f) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                f.setVisible(false);
                f.dispose();
            }
        };
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(r);
        } else {
            r.run();
        }
    }

    @Override
    DrawingSurfaceObject createDrawingSurfaceObject(Canvas3D cv) {
        return new JoglDrawingSurfaceObject(cv);
    }

    @Override
    void freeDrawingSurface(Canvas3D cv, DrawingSurfaceObject drawingSurfaceObject) {
    }

    @Override
    void freeDrawingSurfaceNative(Object o) {
    }

    GLContext context(Context ctx) {
        if (ctx == null) {
            return null;
        }
        return ((JoglContext)ctx).getGLContext();
    }

    GLDrawable drawable(Drawable drawable) {
        if (drawable == null) {
            return null;
        }
        return ((JoglDrawable)drawable).getGLDrawable();
    }

    GLCapabilities caps(Canvas3D ctx) {
        if (ctx.drawable != null) {
            return (GLCapabilities)this.drawable(ctx.drawable).getChosenGLCapabilities();
        }
        return ((JoglGraphicsConfiguration)ctx.graphicsConfiguration).getGLCapabilities();
    }

    private static FloatBuffer getVertexArrayBuffer(float[] vertexArray) {
        return JoglPipeline.getVertexArrayBuffer(vertexArray, true);
    }

    private static FloatBuffer getVertexArrayBuffer(float[] vertexArray, boolean copyData) {
        return JoglPipeline.getNIOBuffer(vertexArray, nioVertexTemp, copyData);
    }

    private static DoubleBuffer getVertexArrayBuffer(double[] vertexArray) {
        return JoglPipeline.getVertexArrayBuffer(vertexArray, true);
    }

    private static DoubleBuffer getVertexArrayBuffer(double[] vertexArray, boolean copyData) {
        return JoglPipeline.getNIOBuffer(vertexArray, nioVertexDoubleTemp, true);
    }

    private static FloatBuffer getColorArrayBuffer(float[] colorArray) {
        return JoglPipeline.getColorArrayBuffer(colorArray, true);
    }

    private static FloatBuffer getColorArrayBuffer(float[] colorArray, boolean copyData) {
        return JoglPipeline.getNIOBuffer(colorArray, nioColorTemp, true);
    }

    private static ByteBuffer getColorArrayBuffer(byte[] colorArray) {
        return JoglPipeline.getColorArrayBuffer(colorArray, true);
    }

    private static ByteBuffer getColorArrayBuffer(byte[] colorArray, boolean copyData) {
        return JoglPipeline.getNIOBuffer(colorArray, nioColorByteTemp, true);
    }

    private static FloatBuffer getNormalArrayBuffer(float[] normalArray) {
        return JoglPipeline.getNormalArrayBuffer(normalArray, true);
    }

    private static FloatBuffer getNormalArrayBuffer(float[] normalArray, boolean copyData) {
        return JoglPipeline.getNIOBuffer(normalArray, nioNormalTemp, true);
    }

    private static FloatBuffer[] getTexCoordSetBuffer(Object[] texCoordSet) {
        return JoglPipeline.getNIOBuffer(texCoordSet, nioTexCoordSetTemp);
    }

    private static FloatBuffer[] getVertexAttrSetBuffer(Object[] vertexAttrSet) {
        return JoglPipeline.getNIOBuffer(vertexAttrSet, nioVertexAttrSetTemp);
    }

    private static FloatBuffer getNIOBuffer(float[] array, ThreadLocal<FloatBuffer> threadLocal, boolean copyData) {
        if (array == null) {
            return null;
        }
        FloatBuffer buf = threadLocal.get();
        if (buf == null) {
            buf = Buffers.newDirectFloatBuffer((int)array.length);
            threadLocal.set(buf);
        } else {
            buf.rewind();
            if (buf.remaining() < array.length) {
                int newSize = Math.max(2 * buf.remaining(), array.length);
                buf = Buffers.newDirectFloatBuffer((int)newSize);
                threadLocal.set(buf);
            }
        }
        if (copyData) {
            buf.put(array);
            buf.rewind();
        }
        return buf;
    }

    private static DoubleBuffer getNIOBuffer(double[] array, ThreadLocal<DoubleBuffer> threadLocal, boolean copyData) {
        if (array == null) {
            return null;
        }
        DoubleBuffer buf = threadLocal.get();
        if (buf == null) {
            buf = Buffers.newDirectDoubleBuffer((int)array.length);
            threadLocal.set(buf);
        } else {
            buf.rewind();
            if (buf.remaining() < array.length) {
                int newSize = Math.max(2 * buf.remaining(), array.length);
                buf = Buffers.newDirectDoubleBuffer((int)newSize);
                threadLocal.set(buf);
            }
        }
        if (copyData) {
            buf.put(array);
            buf.rewind();
        }
        return buf;
    }

    private static ByteBuffer getNIOBuffer(byte[] array, ThreadLocal<ByteBuffer> threadLocal, boolean copyData) {
        if (array == null) {
            return null;
        }
        ByteBuffer buf = threadLocal.get();
        if (buf == null) {
            buf = Buffers.newDirectByteBuffer((int)array.length);
            threadLocal.set(buf);
        } else {
            buf.rewind();
            if (buf.remaining() < array.length) {
                int newSize = Math.max(2 * buf.remaining(), array.length);
                buf = Buffers.newDirectByteBuffer((int)newSize);
                threadLocal.set(buf);
            }
        }
        if (copyData) {
            buf.put(array);
            buf.rewind();
        }
        return buf;
    }

    private static FloatBuffer[] getNIOBuffer(Object[] array, ThreadLocal<FloatBuffer[]> threadLocal) {
        if (array == null) {
            return null;
        }
        FloatBuffer[] bufs = threadLocal.get();
        if (bufs == null) {
            bufs = new FloatBuffer[array.length];
            threadLocal.set(bufs);
        } else if (bufs.length < array.length) {
            FloatBuffer[] newBufs = new FloatBuffer[array.length];
            System.arraycopy(bufs, 0, newBufs, 0, bufs.length);
            bufs = newBufs;
            threadLocal.set(bufs);
        }
        for (int i = 0; i < array.length; ++i) {
            float[] cur = (float[])array[i];
            FloatBuffer buf = bufs[i];
            if (buf == null) {
                bufs[i] = buf = Buffers.newDirectFloatBuffer((int)cur.length);
            } else {
                buf.rewind();
                if (buf.remaining() < cur.length) {
                    int newSize = Math.max(2 * buf.remaining(), cur.length);
                    bufs[i] = buf = Buffers.newDirectFloatBuffer((int)newSize);
                }
            }
            buf.put(cur);
            buf.rewind();
        }
        return bufs;
    }

    private static int getVersion() {
        String version = System.getProperty("java.version");
        if (version.startsWith("1.")) {
            version = version.substring(2, 3);
        } else {
            int dot = version.indexOf(".");
            if (dot != -1) {
                version = version.substring(0, dot);
            }
        }
        return Integer.parseInt(version);
    }

    static {
        int i;
        black = new float[4];
        screen_door = new int[][]{{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0x22222222, 0, 0, 0, 0x22222222, 0, 0, 0, 0x22222222, 0, 0, 0, 0x22222222, 0, 0, 0, 0x22222222, 0, 0, 0, 0x22222222, 0, 0, 0, 0x22222222, 0, 0, 0, 0x22222222, 0, 0}, {0, 0x22222222, 0, -2004318072, 0, 0x22222222, 0, -2004318072, 0, 0x22222222, 0, -2004318072, 0, 0x22222222, 0, -2004318072, 0, 0x22222222, 0, -2004318072, 0, 0x22222222, 0, -2004318072, 0, 0x22222222, 0, -2004318072, 0, 0x22222222, 0, -2004318072}, {0, -1431655766, 0, -2004318072, 0, -1431655766, 0, -2004318072, 0, -1431655766, 0, -2004318072, 0, -1431655766, 0, -2004318072, 0, -1431655766, 0, -2004318072, 0, -1431655766, 0, -2004318072, 0, -1431655766, 0, -2004318072, 0, -1431655766, 0, -2004318072}, {0, -1431655766, 0, -1431655766, 0, -1431655766, 0, -1431655766, 0, -1431655766, 0, -1431655766, 0, -1431655766, 0, -1431655766, 0, -1431655766, 0, -1431655766, 0, -1431655766, 0, -1431655766, 0, -1431655766, 0, -1431655766, 0, -1431655766, 0, -1431655766}, {0x11111111, -1431655766, 0, -1431655766, 0x11111111, -1431655766, 0, -1431655766, 0x11111111, -1431655766, 0, -1431655766, 0x11111111, -1431655766, 0, -1431655766, 0x11111111, -1431655766, 0, -1431655766, 0x11111111, -1431655766, 0, -1431655766, 0x11111111, -1431655766, 0, -1431655766, 0x11111111, -1431655766, 0, -1431655766}, {0x11111111, -1431655766, 0x44444444, -1431655766, 0x11111111, -1431655766, 0x44444444, -1431655766, 0x11111111, -1431655766, 0x44444444, -1431655766, 0x11111111, -1431655766, 0x44444444, -1431655766, 0x11111111, -1431655766, 0x44444444, -1431655766, 0x11111111, -1431655766, 0x44444444, -1431655766, 0x11111111, -1431655766, 0x44444444, -1431655766, 0x11111111, -1431655766, 0x44444444, -1431655766}, {0x55555555, -1431655766, 0x44444444, -1431655766, 0x55555555, -1431655766, 0x44444444, -1431655766, 0x55555555, -1431655766, 0x44444444, -1431655766, 0x55555555, -1431655766, 0x44444444, -1431655766, 0x55555555, -1431655766, 0x44444444, -1431655766, 0x55555555, -1431655766, 0x44444444, -1431655766, 0x55555555, -1431655766, 0x44444444, -1431655766, 0x55555555, -1431655766, 0x44444444, -1431655766}, {0x55555555, -1431655766, 0x55555555, -1431655766, 0x55555555, -1431655766, 0x55555555, -1431655766, 0x55555555, -1431655766, 0x55555555, -1431655766, 0x55555555, -1431655766, 0x55555555, -1431655766, 0x55555555, -1431655766, 0x55555555, -1431655766, 0x55555555, -1431655766, 0x55555555, -1431655766, 0x55555555, -1431655766, 0x55555555, -1431655766, 0x55555555, -1431655766, 0x55555555, -1431655766}, {0x77777777, -1431655766, 0x55555555, -1431655766, 0x77777777, -1431655766, 0x55555555, -1431655766, 0x77777777, -1431655766, 0x55555555, -1431655766, 0x77777777, -1431655766, 0x55555555, -1431655766, 0x77777777, -1431655766, 0x55555555, -1431655766, 0x77777777, -1431655766, 0x55555555, -1431655766, 0x77777777, -1431655766, 0x55555555, -1431655766, 0x77777777, -1431655766, 0x55555555, -1431655766}, {0x77777777, -1431655766, -572662307, -1431655766, 0x77777777, -1431655766, -572662307, -1431655766, 0x77777777, -1431655766, -572662307, -1431655766, 0x77777777, -1431655766, -572662307, -1431655766, 0x77777777, -1431655766, -572662307, -1431655766, 0x77777777, -1431655766, -572662307, -1431655766, 0x77777777, -1431655766, -572662307, -1431655766, 0x77777777, -1431655766, -572662307, -1431655766}, {-1, -1431655766, -572662307, -1431655766, -1, -1431655766, -572662307, -1431655766, -1, -1431655766, -572662307, -1431655766, -1, -1431655766, -572662307, -1431655766, -1, -1431655766, -572662307, -1431655766, -1, -1431655766, -572662307, -1431655766, -1, -1431655766, -572662307, -1431655766, -1, -1431655766, -572662307, -1431655766}, {-1, -1431655766, -1, -1431655766, -1, -1431655766, -1, -1431655766, -1, -1431655766, -1, -1431655766, -1, -1431655766, -1, -1431655766, -1, -1431655766, -1, -1431655766, -1, -1431655766, -1, -1431655766, -1, -1431655766, -1, -1431655766, -1, -1431655766, -1, -1431655766}, {-1, -1145324613, -1, -1431655766, -1, -1145324613, -1, -1431655766, -1, -1145324613, -1, -1431655766, -1, -1145324613, -1, -1431655766, -1, -1145324613, -1, -1431655766, -1, -1145324613, -1, -1431655766, -1, -1145324613, -1, -1431655766, -1, -1145324613, -1, -1431655766}, {-1, -1145324613, -1, -286331154, -1, -1145324613, -1, -286331154, -1, -1145324613, -1, -286331154, -1, -1145324613, -1, -286331154, -1, -1145324613, -1, -286331154, -1, -1145324613, -1, -286331154, -1, -1145324613, -1, -286331154, -1, -1145324613, -1, -286331154}, {-1, -1, -1, -286331154, -1, -1, -1, -286331154, -1, -1, -1, -286331154, -1, -1, -1, -286331154, -1, -1, -1, -286331154, -1, -1, -1, -286331154, -1, -1, -1, -286331154, -1, -1, -1, -286331154}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}};
        screen_door_table = new ByteBuffer[screen_door.length];
        int eachLen = screen_door[0].length * 4;
        ByteBuffer buf = Buffers.newDirectByteBuffer((int)(screen_door.length * eachLen));
        IntBuffer intBuf = buf.asIntBuffer();
        for (i = 0; i < screen_door.length; ++i) {
            intBuf.put(screen_door[i]);
        }
        buf.rewind();
        for (i = 0; i < screen_door.length; ++i) {
            buf.position(i * eachLen);
            buf.limit((i + 1) * eachLen);
            JoglPipeline.screen_door_table[i] = buf.slice();
        }
        blendFunctionTable = new int[9];
        JoglPipeline.blendFunctionTable[0] = 0;
        JoglPipeline.blendFunctionTable[1] = 1;
        JoglPipeline.blendFunctionTable[2] = 770;
        JoglPipeline.blendFunctionTable[3] = 771;
        JoglPipeline.blendFunctionTable[4] = 774;
        JoglPipeline.blendFunctionTable[5] = 775;
        JoglPipeline.blendFunctionTable[6] = 768;
        JoglPipeline.blendFunctionTable[7] = 769;
        JoglPipeline.blendFunctionTable[8] = 32769;
        _gl_combineRgbSrcIndex = new int[]{34176, 34177, 34178};
        _gl_combineAlphaSrcIndex = new int[]{34184, 34185, 34186};
        _gl_combineRgbOpIndex = new int[]{34192, 34193, 34194};
        _gl_combineAlphaOpIndex = new int[]{34200, 34201, 34202};
        _gl_combineSrc = new int[]{34167, 5890, 34166, 34168};
        _gl_combineFcn = new int[]{768, 769, 770, 771};
        _gl_textureCubeMapFace = new int[]{34069, 34070, 34071, 34072, 34073, 34074};
        nioVertexTemp = new ThreadLocal();
        nioVertexDoubleTemp = new ThreadLocal();
        nioColorTemp = new ThreadLocal();
        nioColorByteTemp = new ThreadLocal();
        nioNormalTemp = new ThreadLocal();
        nioTexCoordSetTemp = new ThreadLocal();
        nioVertexAttrSetTemp = new ThreadLocal();
    }

    private final class ContextQuerier
    extends DefaultGLCapabilitiesChooser
    implements ExtendedCapabilitiesChooser {
        private Canvas3D canvas;
        private boolean done;

        public ContextQuerier(Canvas3D canvas) {
            this.canvas = canvas;
        }

        public boolean done() {
            return this.done;
        }

        @Override
        public void init(GLContext context) {
            JoglContext jctx = new JoglContext(context);
            GL2 gl = context.getGL().getGL2();
            if (JoglPipeline.this.getPropertiesFromCurrentContext(jctx, gl)) {
                JoglPipeline.this.setupCanvasProperties(this.canvas, jctx, (GL)gl);
            }
            this.markDone();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void markDone() {
            ContextQuerier contextQuerier = this;
            synchronized (contextQuerier) {
                this.done = true;
                this.notifyAll();
            }
        }
    }

    static class CapabilitiesCapturer
    extends DefaultGLCapabilitiesChooser
    implements ExtendedCapabilitiesChooser {
        private boolean done;
        private GLCapabilities capabilities;
        private int chosenIndex = -1;

        CapabilitiesCapturer() {
        }

        public boolean done() {
            return this.done;
        }

        public GLCapabilities getCapabilities() {
            return this.capabilities;
        }

        public int getChosenIndex() {
            return this.chosenIndex;
        }

        public int chooseCapabilities(GLCapabilities desired, GLCapabilities[] available, int windowSystemRecommendedChoice) {
            int res = super.chooseCapabilities((CapabilitiesImmutable)desired, Arrays.asList(available), windowSystemRecommendedChoice);
            this.capabilities = available[res];
            this.chosenIndex = res;
            this.markDone();
            return res;
        }

        @Override
        public void init(GLContext context) {
            this.kick();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void markDone() {
            CapabilitiesCapturer capabilitiesCapturer = this;
            synchronized (capabilitiesCapturer) {
                this.done = true;
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void kick() {
            CapabilitiesCapturer capabilitiesCapturer = this;
            synchronized (capabilitiesCapturer) {
                this.notifyAll();
            }
        }
    }

    private final class QueryCanvas
    extends Canvas {
        private GLDrawable glDrawable;
        private ExtendedCapabilitiesChooser chooser;
        private boolean alreadyRan;
        private AWTGraphicsConfiguration awtConfig;
        private JAWTWindow nativeWindow;

        private QueryCanvas(AWTGraphicsConfiguration awtConfig, ExtendedCapabilitiesChooser chooser) {
            super(awtConfig.getAWTGraphicsConfiguration());
            this.awtConfig = null;
            this.nativeWindow = null;
            this.awtConfig = awtConfig;
            this.chooser = chooser;
        }

        @Override
        public void addNotify() {
            super.addNotify();
            this.nativeWindow = (JAWTWindow)NativeWindowFactory.getNativeWindow((Object)this, (AbstractGraphicsConfiguration)this.awtConfig);
            this.nativeWindow.lockSurface();
            try {
                this.glDrawable = GLDrawableFactory.getFactory((GLProfile)JoglPipeline.this.profile).createGLDrawable((NativeSurface)this.nativeWindow);
            }
            finally {
                this.nativeWindow.unlockSurface();
            }
            this.glDrawable.setRealized(true);
        }

        private void doQuery() {
            if (this.alreadyRan) {
                return;
            }
            GLContext context = this.glDrawable.createContext(null);
            int res = context.makeCurrent();
            if (res != 0) {
                try {
                    this.chooser.init(context);
                }
                finally {
                    context.release();
                }
            }
            context.destroy();
            this.alreadyRan = true;
            this.glDrawable.setRealized(false);
            this.nativeWindow.destroy();
        }
    }

    static interface ExtendedCapabilitiesChooser
    extends GLCapabilitiesChooser {
        public void init(GLContext var1);
    }

    private static enum DisabledCaps {
        STEREO,
        AA,
        DOUBLE_BUFFER;

    }
}

