/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.toolbar.title;

import bibliothek.gui.Dockable;
import bibliothek.gui.ToolbarExtension;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.themes.basic.action.BasicTitleViewItem;
import bibliothek.gui.dock.title.AbstractDockTitle;
import bibliothek.gui.dock.title.DockTitleFactory;
import bibliothek.gui.dock.title.DockTitleRequest;
import bibliothek.gui.dock.title.DockTitleVersion;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.UIManager;

public class ToolbarDockTitlePoint
extends AbstractDockTitle {
    private Color backgroundColor = UIManager.getColor("Button.background");
    private Color pointColor = this.backgroundColor.darker();
    private static final int POINT_DISTANCE = 2;

    public static DockTitleFactory createFactory(final Color color, final Color color2) {
        return new DockTitleFactory(){

            @Override
            public void uninstall(DockTitleRequest dockTitleRequest) {
            }

            @Override
            public void request(DockTitleRequest dockTitleRequest) {
                dockTitleRequest.answer(new ToolbarDockTitlePoint(dockTitleRequest.getVersion(), dockTitleRequest.getTarget(), color, color2));
            }

            @Override
            public void install(DockTitleRequest dockTitleRequest) {
            }
        };
    }

    public static DockTitleFactory createFactory() {
        return new DockTitleFactory(){

            @Override
            public void uninstall(DockTitleRequest dockTitleRequest) {
            }

            @Override
            public void request(DockTitleRequest dockTitleRequest) {
                dockTitleRequest.answer(new ToolbarDockTitlePoint(dockTitleRequest.getVersion(), dockTitleRequest.getTarget()));
            }

            @Override
            public void install(DockTitleRequest dockTitleRequest) {
            }
        };
    }

    public ToolbarDockTitlePoint(DockTitleVersion dockTitleVersion, Dockable dockable, Color color, Color color2) {
        super(dockable, dockTitleVersion, true);
        this.backgroundColor = color;
        this.pointColor = color2;
    }

    public ToolbarDockTitlePoint(DockTitleVersion dockTitleVersion, Dockable dockable) {
        super(dockable, dockTitleVersion, true);
    }

    @Override
    protected BasicTitleViewItem<JComponent> createItemFor(DockAction dockAction, Dockable dockable) {
        return dockable.getController().getActionViewConverter().createView(dockAction, ToolbarExtension.TOOLBAR_TITLE, dockable);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        return new Dimension(Math.max(5, dimension.width), Math.max(5, dimension.height));
    }

    @Override
    public void setActive(boolean bl) {
        super.setActive(bl);
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        graphics.setColor(this.backgroundColor);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        graphics.setColor(this.pointColor);
        if (this.getOrientation().isHorizontal()) {
            int n = this.getHeight() / 2;
            for (int i = this.getWidth() / 6; i <= this.getWidth() - this.getWidth() / 6; i += 2) {
                graphics.drawLine(i, n - 1, i, n - 1);
                graphics.drawLine(i, n + 1, i, n + 1);
            }
        } else {
            int n = this.getWidth() / 2;
            for (int i = this.getHeight() / 6; i < this.getHeight() - this.getHeight() / 6; i += 2) {
                graphics.drawLine(n - 1, i, n - 1, i);
                graphics.drawLine(n + 1, i, n + 1, i);
            }
        }
    }
}

