/*Some notes about OpenCL.
 * Many GPU's (Quadro included) use little-Endian byte ordering, and Java uses Big-Endian by default, luckily the
 * Jogamp library already converts the CLBuffers whenever necessary; however, sending custom raw byte data requires
 * paying attention to this.
 */

#ifndef __OPENCL_VERSION__ //This should fail during an actual openCL compile, used only to trick Eclipse into syntax highlighting this file as "C" code.
#define __kernel
#define __global
#define kernel
#define global
#define constant
#define local
#define float2 float
#define int3 int
#define float3 float
#define float4 float
#define uchar4 char
#endif

kernel void unitTestCartesianSystem(global const float4 *dirAndOffsetBuffer, global float *clResultBufferCartesian, const int numTasks) 
{
	const int iWorker = get_global_id(0); //The worker ID
	// bound check (equivalent to the limit on a 'for' loop for standard/serial C code
	if (iWorker >= numTasks)  
		return;
		
	const float3 dir = (float3)(dirAndOffsetBuffer[iWorker].x, dirAndOffsetBuffer[iWorker].y, dirAndOffsetBuffer[iWorker].z);
	float offsetZ = dirAndOffsetBuffer[iWorker].w;
		
	float cartesianSystem[12] = {0};
	if (!setVerticalAxis(dir, cartesianSystem, true))
		return;
		
	float3 origin = (float3)(offsetZ * dir.x, offsetZ * dir.y, offsetZ * dir.z);
	setOrigin(origin, cartesianSystem);

	for (int k=0; k<12; k++)
		clResultBufferCartesian[12*iWorker+k] = cartesianSystem[k];
}
