/*
 * Decompiled with CFR 0.152.
 */
package cadex.Collections;

import cadex.CadExMTKJNI;
import java.util.AbstractList;
import java.util.RandomAccess;

public class ByteList
extends AbstractList<Short>
implements RandomAccess {
    private transient long swigCPtr;
    public transient boolean swigCMemOwn;

    public ByteList(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    public static long getCPtr(ByteList obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    public static long swigRelease(ByteList obj) {
        long ptr = 0L;
        if (obj != null) {
            if (!obj.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            ptr = obj.swigCPtr;
            obj.swigCMemOwn = false;
            obj.delete();
        }
        return ptr;
    }

    public void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                CadExMTKJNI.delete_std_ByteList(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public ByteList(short[] initialElements) {
        this();
        this.reserve(initialElements.length);
        for (short element : initialElements) {
            this.add(element);
        }
    }

    public ByteList(Iterable<Short> initialElements) {
        this();
        for (short element : initialElements) {
            this.add(element);
        }
    }

    @Override
    public Short get(int index) {
        return this.doGet(index);
    }

    @Override
    public Short set(int index, Short e) {
        return this.doSet(index, e);
    }

    @Override
    public boolean add(Short e) {
        ++this.modCount;
        this.doAdd(e);
        return true;
    }

    @Override
    public void add(int index, Short e) {
        ++this.modCount;
        this.doAdd(index, e);
    }

    @Override
    public Short remove(int index) {
        ++this.modCount;
        return this.doRemove(index);
    }

    @Override
    public void removeRange(int fromIndex, int toIndex) {
        ++this.modCount;
        this.doRemoveRange(fromIndex, toIndex);
    }

    @Override
    public int size() {
        return this.doSize();
    }

    public int capacity() {
        return this.doCapacity();
    }

    public void reserve(int n) {
        this.doReserve(n);
    }

    public ByteList() {
        this(CadExMTKJNI.new_std_ByteList__SWIG_0(), true);
    }

    public ByteList(ByteList other) {
        this(CadExMTKJNI.new_std_ByteList__SWIG_1(ByteList.getCPtr(other), other), true);
    }

    @Override
    public boolean isEmpty() {
        return CadExMTKJNI.std_ByteList_isEmpty(this.swigCPtr, this);
    }

    @Override
    public void clear() {
        CadExMTKJNI.std_ByteList_clear(this.swigCPtr, this);
    }

    public ByteList(int count, short value) {
        this(CadExMTKJNI.new_std_ByteList__SWIG_2(count, value), true);
    }

    private int doCapacity() {
        return CadExMTKJNI.std_ByteList_doCapacity(this.swigCPtr, this);
    }

    private void doReserve(int n) {
        CadExMTKJNI.std_ByteList_doReserve(this.swigCPtr, this, n);
    }

    private int doSize() {
        return CadExMTKJNI.std_ByteList_doSize(this.swigCPtr, this);
    }

    private void doAdd(short x) {
        CadExMTKJNI.std_ByteList_doAdd__SWIG_0(this.swigCPtr, this, x);
    }

    private void doAdd(int index, short x) {
        CadExMTKJNI.std_ByteList_doAdd__SWIG_1(this.swigCPtr, this, index, x);
    }

    private short doRemove(int index) {
        return CadExMTKJNI.std_ByteList_doRemove(this.swigCPtr, this, index);
    }

    private short doGet(int index) {
        return CadExMTKJNI.std_ByteList_doGet(this.swigCPtr, this, index);
    }

    private short doSet(int index, short val) {
        return CadExMTKJNI.std_ByteList_doSet(this.swigCPtr, this, index, val);
    }

    private void doRemoveRange(int fromIndex, int toIndex) {
        CadExMTKJNI.std_ByteList_doRemoveRange(this.swigCPtr, this, fromIndex, toIndex);
    }
}

