/*
 * Decompiled with CFR 0.152.
 */
package cadex.Collections;

import cadex.CadExMTKJNI;
import cadex.Geom.Point;
import java.util.AbstractList;
import java.util.RandomAccess;

public class PointList
extends AbstractList<Point>
implements RandomAccess {
    private transient long swigCPtr;
    public transient boolean swigCMemOwn;

    public PointList(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    public static long getCPtr(PointList obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    public static long swigRelease(PointList obj) {
        long ptr = 0L;
        if (obj != null) {
            if (!obj.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            ptr = obj.swigCPtr;
            obj.swigCMemOwn = false;
            obj.delete();
        }
        return ptr;
    }

    public void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                CadExMTKJNI.delete_std_PointList(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public PointList(Point[] initialElements) {
        this();
        this.reserve(initialElements.length);
        for (Point element : initialElements) {
            this.add(element);
        }
    }

    public PointList(Iterable<Point> initialElements) {
        this();
        for (Point element : initialElements) {
            this.add(element);
        }
    }

    @Override
    public Point get(int index) {
        return this.doGet(index);
    }

    @Override
    public Point set(int index, Point e) {
        return this.doSet(index, e);
    }

    @Override
    public boolean add(Point e) {
        ++this.modCount;
        this.doAdd(e);
        return true;
    }

    @Override
    public void add(int index, Point e) {
        ++this.modCount;
        this.doAdd(index, e);
    }

    @Override
    public Point remove(int index) {
        ++this.modCount;
        return this.doRemove(index);
    }

    @Override
    public void removeRange(int fromIndex, int toIndex) {
        ++this.modCount;
        this.doRemoveRange(fromIndex, toIndex);
    }

    @Override
    public int size() {
        return this.doSize();
    }

    public int capacity() {
        return this.doCapacity();
    }

    public void reserve(int n) {
        this.doReserve(n);
    }

    public PointList() {
        this(CadExMTKJNI.new_std_PointList__SWIG_0(), true);
    }

    public PointList(PointList other) {
        this(CadExMTKJNI.new_std_PointList__SWIG_1(PointList.getCPtr(other), other), true);
    }

    @Override
    public boolean isEmpty() {
        return CadExMTKJNI.std_PointList_isEmpty(this.swigCPtr, this);
    }

    @Override
    public void clear() {
        CadExMTKJNI.std_PointList_clear(this.swigCPtr, this);
    }

    public PointList(int count, Point value) {
        this(CadExMTKJNI.new_std_PointList__SWIG_2(count, Point.getCPtr(value), value), true);
    }

    private int doCapacity() {
        return CadExMTKJNI.std_PointList_doCapacity(this.swigCPtr, this);
    }

    private void doReserve(int n) {
        CadExMTKJNI.std_PointList_doReserve(this.swigCPtr, this, n);
    }

    private int doSize() {
        return CadExMTKJNI.std_PointList_doSize(this.swigCPtr, this);
    }

    private void doAdd(Point x) {
        CadExMTKJNI.std_PointList_doAdd__SWIG_0(this.swigCPtr, this, Point.getCPtr(x), x);
    }

    private void doAdd(int index, Point x) {
        CadExMTKJNI.std_PointList_doAdd__SWIG_1(this.swigCPtr, this, index, Point.getCPtr(x), x);
    }

    private Point doRemove(int index) {
        return new Point(CadExMTKJNI.std_PointList_doRemove(this.swigCPtr, this, index), true);
    }

    private Point doGet(int index) {
        long cPtr = CadExMTKJNI.std_PointList_doGet(this.swigCPtr, this, index);
        return new Point(cPtr, true);
    }

    private Point doSet(int index, Point val) {
        return new Point(CadExMTKJNI.std_PointList_doSet(this.swigCPtr, this, index, Point.getCPtr(val), val), true);
    }

    private void doRemoveRange(int fromIndex, int toIndex) {
        CadExMTKJNI.std_PointList_doRemoveRange(this.swigCPtr, this, fromIndex, toIndex);
    }
}

