/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.gluegen.cgram.types;

import com.jogamp.gluegen.ASTLocusTag;
import com.jogamp.gluegen.cgram.types.FunctionType;
import com.jogamp.gluegen.cgram.types.SizeThunk;
import com.jogamp.gluegen.cgram.types.Type;
import com.jogamp.gluegen.cgram.types.TypeVisitor;

public class PointerType
extends Type
implements Cloneable {
    private final Type targetType;

    public PointerType(SizeThunk sizeThunk, Type type, int n) {
        this(sizeThunk, type, n, null);
    }

    public PointerType(SizeThunk sizeThunk, Type type, int n, ASTLocusTag aSTLocusTag) {
        super(type.getName() + " *", sizeThunk, n, aSTLocusTag);
        this.targetType = type;
    }

    private PointerType(PointerType pointerType, int n, ASTLocusTag aSTLocusTag) {
        super(pointerType, n, aSTLocusTag);
        this.targetType = pointerType.targetType;
    }

    @Override
    Type newVariantImpl(boolean bl, int n, ASTLocusTag aSTLocusTag) {
        return new PointerType(this, n, aSTLocusTag);
    }

    @Override
    protected int hashCodeImpl() {
        return this.targetType.hashCode();
    }

    @Override
    protected boolean equalsImpl(Type type) {
        PointerType pointerType = (PointerType)type;
        return this.targetType.equals(pointerType.targetType);
    }

    @Override
    protected int hashCodeSemanticsImpl() {
        return this.targetType.hashCodeSemantics();
    }

    @Override
    protected boolean equalSemanticsImpl(Type type) {
        PointerType pointerType = (PointerType)type;
        return this.targetType.equalSemantics(pointerType.targetType);
    }

    @Override
    public boolean isAnon() {
        if (this.isTypedef()) {
            return super.isAnon();
        }
        return this.targetType.isAnon();
    }

    @Override
    public String getName(boolean bl) {
        if (this.isTypedef()) {
            return super.getName(bl);
        }
        if (!bl) {
            return this.targetType.getName(bl) + " *";
        }
        return this.targetType.getName(bl) + " * " + this.getCVAttributesString();
    }

    @Override
    public String getCName(boolean bl) {
        if (this.isTypedef()) {
            return super.getCName(bl);
        }
        if (!bl) {
            return this.targetType.getCName(bl) + " *";
        }
        return this.targetType.getCName(bl) + " * " + this.getCVAttributesString();
    }

    @Override
    public final PointerType asPointer() {
        return this;
    }

    @Override
    public final Type getTargetType() {
        return this.targetType;
    }

    @Override
    public final Type getBaseElementType() {
        return this.targetType.getBaseElementType();
    }

    @Override
    public final boolean isFunctionPointer() {
        return this.targetType.isFunction();
    }

    @Override
    public final int pointerDepth() {
        return 1 + this.targetType.pointerDepth();
    }

    @Override
    public String toString() {
        if (this.isTypedef()) {
            return super.getCName(true);
        }
        return this.toStringInt();
    }

    private String toStringInt() {
        if (!this.targetType.isFunction()) {
            return this.targetType.getCName(true) + " * " + this.getCVAttributesString();
        }
        return ((FunctionType)this.targetType).toString(null, null, false, true);
    }

    public String toString(String string, String string2) {
        if (!this.targetType.isFunction()) {
            throw new RuntimeException("<Internal error or misuse> This method is only for use when printing function pointers");
        }
        return ((FunctionType)this.targetType).toString(string, string2, false, true);
    }

    @Override
    public void visit(TypeVisitor typeVisitor) {
        super.visit(typeVisitor);
        this.targetType.visit(typeVisitor);
    }
}

