/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.gluegen.jcpp;

import com.jogamp.gluegen.jcpp.Feature;
import com.jogamp.gluegen.jcpp.LexerException;
import com.jogamp.gluegen.jcpp.LexerSource;
import com.jogamp.gluegen.jcpp.Preprocessor;
import com.jogamp.gluegen.jcpp.PreprocessorListener;
import com.jogamp.gluegen.jcpp.Warning;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;

class JoinReader
implements Closeable {
    private final Reader in;
    private PreprocessorListener listener;
    private LexerSource source;
    private boolean trigraphs;
    private boolean warnings;
    private int newlines;
    private boolean flushnl;
    private int[] unget;
    private int uptr;

    public JoinReader(Reader reader, boolean bl) {
        this.in = reader;
        this.trigraphs = bl;
        this.newlines = 0;
        this.flushnl = false;
        this.unget = new int[2];
        this.uptr = 0;
    }

    public JoinReader(Reader reader) {
        this(reader, false);
    }

    public void setTrigraphs(boolean bl, boolean bl2) {
        this.trigraphs = bl;
        this.warnings = bl2;
    }

    void init(Preprocessor preprocessor, LexerSource lexerSource) {
        this.listener = preprocessor.getListener();
        this.source = lexerSource;
        this.setTrigraphs(preprocessor.getFeature(Feature.TRIGRAPHS), preprocessor.getWarning(Warning.TRIGRAPHS));
    }

    private int __read() throws IOException {
        if (this.uptr > 0) {
            return this.unget[--this.uptr];
        }
        return this.in.read();
    }

    private void _unread(int n) {
        if (n != -1) {
            this.unget[this.uptr++] = n;
        }
        assert (this.uptr <= this.unget.length) : "JoinReader ungets too many characters";
    }

    protected void warning(String string) throws LexerException {
        if (this.source == null) {
            throw new LexerException(string);
        }
        this.source.warning(string);
    }

    private char trigraph(char c, char c2) throws IOException, LexerException {
        if (this.trigraphs) {
            if (this.warnings) {
                this.warning("trigraph ??" + c + " converted to " + c2);
            }
            return c2;
        }
        if (this.warnings) {
            this.warning("trigraph ??" + c + " ignored");
        }
        this._unread(c);
        this._unread(63);
        return '?';
    }

    private int _read() throws IOException, LexerException {
        int n = this.__read();
        if (n == 63 && (this.trigraphs || this.warnings)) {
            int n2 = this.__read();
            if (n2 == 63) {
                int n3 = this.__read();
                switch (n3) {
                    case 40: {
                        return this.trigraph('(', '[');
                    }
                    case 41: {
                        return this.trigraph(')', ']');
                    }
                    case 60: {
                        return this.trigraph('<', '{');
                    }
                    case 62: {
                        return this.trigraph('>', '}');
                    }
                    case 61: {
                        return this.trigraph('=', '#');
                    }
                    case 47: {
                        return this.trigraph('/', '\\');
                    }
                    case 39: {
                        return this.trigraph('\'', '^');
                    }
                    case 33: {
                        return this.trigraph('!', '|');
                    }
                    case 45: {
                        return this.trigraph('-', '~');
                    }
                }
                this._unread(n3);
            }
            this._unread(n2);
        }
        return n;
    }

    public int read() throws IOException, LexerException {
        int n;
        if (this.flushnl) {
            if (this.newlines > 0) {
                --this.newlines;
                return 10;
            }
            this.flushnl = false;
        }
        block9: while (true) {
            n = this._read();
            switch (n) {
                case 92: {
                    int n2 = this._read();
                    switch (n2) {
                        case 10: {
                            ++this.newlines;
                            continue block9;
                        }
                        case 13: {
                            ++this.newlines;
                            int n3 = this._read();
                            if (n3 == 10) continue block9;
                            this._unread(n3);
                            continue block9;
                        }
                    }
                    this._unread(n2);
                    return n;
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 133: 
                case 8232: 
                case 8233: {
                    this.flushnl = true;
                    return n;
                }
                case -1: {
                    if (this.newlines <= 0) break block9;
                    --this.newlines;
                    return 10;
                }
            }
            break;
        }
        return n;
    }

    public int read(char[] cArray, int n, int n2) throws IOException, LexerException {
        for (int i = 0; i < n2; ++i) {
            int n3 = this.read();
            if (n3 == -1) {
                return i;
            }
            cArray[n + i] = (char)n3;
        }
        return n2;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    public String toString() {
        return "JoinReader(nl=" + this.newlines + ")";
    }
}

