/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.nio.CachedBufferFactory;
import com.jogamp.common.nio.PointerBuffer;
import com.jogamp.common.os.Platform;
import com.jogamp.opencl.CLContext;
import com.jogamp.opencl.CLDevice;
import com.jogamp.opencl.CLException;
import com.jogamp.opencl.CLKernel;
import com.jogamp.opencl.CLObjectResource;
import com.jogamp.opencl.CLProgramBuilder;
import com.jogamp.opencl.InternalBufferUtil;
import com.jogamp.opencl.llb.CL;
import com.jogamp.opencl.llb.impl.BuildProgramCallback;
import com.jogamp.opencl.util.CLBuildListener;
import com.jogamp.opencl.util.CLProgramConfiguration;
import com.jogamp.opencl.util.CLUtil;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Semaphore;

public class CLProgram
extends CLObjectResource {
    private static final Semaphore buildLock = new Semaphore(1, true);
    private final CL binding;
    private final Set<CLKernel> kernels = new HashSet<CLKernel>();
    private Map<CLDevice, Status> buildStatusMap;
    private boolean executable;
    private boolean released;
    private boolean noSource;

    private CLProgram(CLContext context, long id) {
        super(context, id);
        this.binding = context.getPlatform().getCLBinding();
    }

    static CLProgram create(CLContext context, String src) {
        IntBuffer status = Buffers.newDirectIntBuffer((int)1);
        PointerBuffer length = PointerBuffer.allocateDirect((int)1).put(0, (long)src.length());
        String[] srcArray = new String[]{src};
        CL binding = context.getPlatform().getCLBinding();
        long id = binding.clCreateProgramWithSource(context.ID, 1, srcArray, length, status);
        int err = status.get();
        if (err != 0) {
            throw CLException.newException(err, "can not create program with source on " + context);
        }
        return new CLProgram(context, id);
    }

    static CLProgram create(CLContext context, Map<CLDevice, byte[]> binaries) {
        Set<Map.Entry<CLDevice, byte[]>> entries = binaries.entrySet();
        int binarySize = 0;
        for (Map.Entry<CLDevice, byte[]> entry : entries) {
            binarySize += entry.getValue().length;
        }
        int pbSize = PointerBuffer.ELEMENT_SIZE;
        int deviceCount = binaries.size();
        CachedBufferFactory bf = CachedBufferFactory.create((int)(binarySize + pbSize * deviceCount * 3 + 4), (boolean)true);
        PointerBuffer devices = PointerBuffer.wrap((ByteBuffer)bf.newDirectByteBuffer(deviceCount * pbSize));
        PointerBuffer codeBuffers = PointerBuffer.wrap((ByteBuffer)bf.newDirectByteBuffer(deviceCount * pbSize));
        PointerBuffer lengths = PointerBuffer.wrap((ByteBuffer)bf.newDirectByteBuffer(deviceCount * pbSize));
        int i = 0;
        for (Map.Entry<CLDevice, byte[]> entry : entries) {
            byte[] bytes = entry.getValue();
            CLDevice device = entry.getKey();
            devices.put(device.ID);
            lengths.put((long)bytes.length);
            codeBuffers.referenceBuffer(i, (Buffer)bf.newDirectByteBuffer(bytes));
            ++i;
        }
        devices.rewind();
        lengths.rewind();
        IntBuffer errBuffer = bf.newDirectIntBuffer(1);
        CL binding = context.getPlatform().getCLBinding();
        long id = binding.clCreateProgramWithBinary(context.ID, devices.capacity(), devices, lengths, codeBuffers, null, errBuffer);
        int err = errBuffer.get();
        if (err != 0) {
            throw CLException.newException(err, "can not create program on " + context + " with binaries " + binaries);
        }
        return new CLProgram(context, id);
    }

    private void initBuildStatus() {
        if (this.buildStatusMap == null) {
            CLDevice[] devices;
            HashMap<CLDevice, Status> map = new HashMap<CLDevice, Status>();
            for (CLDevice device : devices = this.getCLDevices()) {
                Status status = this.getBuildStatus(device);
                if (status == Status.BUILD_SUCCESS) {
                    this.executable = true;
                }
                map.put(device, status);
            }
            this.buildStatusMap = Collections.unmodifiableMap(map);
        }
    }

    private String getBuildInfoString(CLDevice device, int flag) {
        if (this.released) {
            return "";
        }
        PointerBuffer size = PointerBuffer.allocateDirect((int)1);
        int ret = this.binding.clGetProgramBuildInfo(this.ID, device.ID, flag, 0L, null, size);
        if (ret != 0) {
            throw CLException.newException(ret, "on clGetProgramBuildInfo with " + device);
        }
        ByteBuffer buffer = Buffers.newDirectByteBuffer((int)((int)size.get(0)));
        ret = this.binding.clGetProgramBuildInfo(this.ID, device.ID, flag, buffer.capacity(), buffer, null);
        if (ret != 0) {
            throw CLException.newException(ret, "on clGetProgramBuildInfo with " + device);
        }
        return CLUtil.clString2JavaString(buffer, (int)size.get(0));
    }

    private String getProgramInfoString(int flag) {
        if (this.released) {
            return "";
        }
        PointerBuffer size = PointerBuffer.allocateDirect((int)1);
        int ret = this.binding.clGetProgramInfo(this.ID, flag, 0L, null, size);
        CLException.checkForError(ret, "on clGetProgramInfo");
        ByteBuffer buffer = Buffers.newDirectByteBuffer((int)((int)size.get(0)));
        ret = this.binding.clGetProgramInfo(this.ID, flag, buffer.capacity(), buffer, null);
        CLException.checkForError(ret, "on clGetProgramInfo");
        return CLUtil.clString2JavaString(buffer, (int)size.get(0));
    }

    private int getBuildInfoInt(CLDevice device, int flag) {
        ByteBuffer buffer = Buffers.newDirectByteBuffer((int)4);
        int ret = this.binding.clGetProgramBuildInfo(this.ID, device.ID, flag, buffer.capacity(), buffer, null);
        CLException.checkForError(ret, "error on clGetProgramBuildInfo");
        return buffer.getInt();
    }

    public CLProgram build() {
        this.build(null, (String)null, (CLDevice[])null);
        return this;
    }

    public CLProgram build(CLBuildListener listener) {
        this.build(listener, (String)null, (CLDevice[])null);
        return this;
    }

    public CLProgram build(CLDevice ... devices) {
        this.build(null, (String)null, devices);
        return this;
    }

    public CLProgram build(CLBuildListener listener, CLDevice ... devices) {
        this.build(listener, (String)null, devices);
        return this;
    }

    public CLProgram build(String options) {
        this.build(null, options, (CLDevice[])null);
        return this;
    }

    public CLProgram build(CLBuildListener listener, String options) {
        this.build(listener, options, (CLDevice[])null);
        return this;
    }

    public CLProgram build(String ... options) {
        this.build(null, CLProgram.optionsOf(options), (CLDevice[])null);
        return this;
    }

    public CLProgram build(CLBuildListener listener, String ... options) {
        this.build(listener, CLProgram.optionsOf(options), (CLDevice[])null);
        return this;
    }

    public CLProgram build(String options, CLDevice ... devices) {
        this.build(null, options, devices);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CLProgram build(final CLBuildListener listener, String options, CLDevice ... devices) {
        if (this.released) {
            throw new CLException("can not build a released program");
        }
        if (!this.kernels.isEmpty()) {
            this.releaseKernels();
        }
        PointerBuffer deviceIDs = null;
        int count = 0;
        if (devices != null && devices.length != 0) {
            deviceIDs = PointerBuffer.allocateDirect((int)devices.length);
            for (int i = 0; i < devices.length; ++i) {
                deviceIDs.put(i, devices[i].ID);
            }
            deviceIDs.rewind();
            count = devices.length;
        }
        if (options != null && options.trim().isEmpty()) {
            options = null;
        }
        this.buildStatusMap = null;
        this.executable = false;
        BuildProgramCallback callback = null;
        if (listener != null) {
            callback = new BuildProgramCallback(){

                @Override
                public void buildFinished(long cl_program) {
                    buildLock.release();
                    listener.buildFinished(CLProgram.this);
                }
            };
        }
        int ret = 0;
        try {
            buildLock.acquire();
        }
        catch (InterruptedException e) {
            throw CLException.newException(ret, "\nInterrupted while waiting to get build lock");
        }
        boolean exception = true;
        try {
            ret = this.binding.clBuildProgram(this.ID, count, deviceIDs, options, callback);
            exception = false;
        }
        finally {
            if (callback == null || exception) {
                buildLock.release();
            }
        }
        if (ret != 0) {
            throw CLException.newException(ret, "\n" + this.getBuildLog());
        }
        return this;
    }

    public CLProgramConfiguration prepare() {
        return CLProgramBuilder.createConfiguration(this);
    }

    public CLKernel createCLKernel(String kernelName) {
        if (this.released) {
            return null;
        }
        int[] err = new int[1];
        long id = this.binding.clCreateKernel(this.ID, kernelName, err, 0);
        if (err[0] != 0) {
            throw CLException.newException(err[0], "unable to create Kernel with name: " + kernelName);
        }
        CLKernel kernel = new CLKernel(this, kernelName, id);
        this.kernels.add(kernel);
        return kernel;
    }

    public Map<String, CLKernel> createCLKernels() {
        if (this.released) {
            return Collections.emptyMap();
        }
        HashMap<String, CLKernel> newKernels = new HashMap<String, CLKernel>();
        IntBuffer numKernels = Buffers.newDirectByteBuffer((int)4).asIntBuffer();
        int ret = this.binding.clCreateKernelsInProgram(this.ID, 0, null, numKernels);
        if (ret != 0) {
            throw CLException.newException(ret, "can not create kernels for " + this);
        }
        if (numKernels.get(0) > 0) {
            PointerBuffer kernelIDs = PointerBuffer.allocateDirect((int)numKernels.get(0));
            ret = this.binding.clCreateKernelsInProgram(this.ID, kernelIDs.capacity(), kernelIDs, null);
            if (ret != 0) {
                throw CLException.newException(ret, "can not create " + kernelIDs.capacity() + " kernels for " + this);
            }
            for (int i = 0; i < kernelIDs.capacity(); ++i) {
                CLKernel kernel = new CLKernel(this, kernelIDs.get(i));
                this.kernels.add(kernel);
                newKernels.put(kernel.name, kernel);
            }
        } else {
            this.initBuildStatus();
            if (!this.isExecutable()) {
                throw CLException.newException(-45, "can not initialize kernels, program is not executable. status: " + this.buildStatusMap);
            }
        }
        return newKernels;
    }

    void onKernelReleased(CLKernel kernel) {
        this.kernels.remove(kernel);
    }

    @Override
    public void release() {
        super.release();
        this.releaseKernels();
        this.executable = false;
        this.released = true;
        this.buildStatusMap = null;
        int ret = this.binding.clReleaseProgram(this.ID);
        this.context.onProgramReleased(this);
        if (ret != 0) {
            throw CLException.newException(ret, "can not release " + this);
        }
    }

    private void releaseKernels() {
        if (!this.kernels.isEmpty()) {
            CLKernel[] array;
            for (CLKernel kernel : array = this.kernels.toArray(new CLKernel[this.kernels.size()])) {
                kernel.release();
            }
        }
    }

    public CLDevice[] getCLDevices() {
        if (this.released) {
            return new CLDevice[0];
        }
        PointerBuffer size = PointerBuffer.allocateDirect((int)1);
        int ret = this.binding.clGetProgramInfo(this.ID, 4451, 0L, null, size);
        if (ret != 0) {
            throw CLException.newException(ret, "on clGetProgramInfo of " + this);
        }
        ByteBuffer bb = Buffers.newDirectByteBuffer((int)((int)size.get(0)));
        ret = this.binding.clGetProgramInfo(this.ID, 4451, bb.capacity(), bb, null);
        if (ret != 0) {
            throw CLException.newException(ret, "on clGetProgramInfo of " + this);
        }
        int count = bb.capacity() / (Platform.is32Bit() ? 4 : 8);
        CLDevice[] devices = new CLDevice[count];
        for (int i = 0; i < count; ++i) {
            devices[i] = this.context.getDevice(Platform.is32Bit() ? (long)bb.getInt() : bb.getLong());
        }
        return devices;
    }

    public String getBuildLog() {
        if (this.released) {
            return "";
        }
        StringBuilder sb = new StringBuilder(200);
        CLDevice[] devices = this.getCLDevices();
        for (int i = 0; i < devices.length; ++i) {
            CLDevice device = devices[i];
            sb.append(device).append(" build log:\n");
            String log = this.getBuildLog(device).trim();
            sb.append(log.isEmpty() ? "    <empty>" : log);
            if (i == devices.length - 1) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    public Map<CLDevice, Status> getBuildStatus() {
        if (this.released) {
            return Collections.emptyMap();
        }
        this.initBuildStatus();
        return this.buildStatusMap;
    }

    public boolean isExecutable() {
        if (this.released) {
            return false;
        }
        this.initBuildStatus();
        return this.executable;
    }

    public String getBuildLog(CLDevice device) {
        return this.getBuildInfoString(device, 4483);
    }

    public Status getBuildStatus(CLDevice device) {
        if (this.released) {
            return Status.BUILD_NONE;
        }
        int clStatus = this.getBuildInfoInt(device, 4481);
        return Status.valueOf(clStatus);
    }

    public void setNoSource() {
        this.noSource = true;
    }

    public String getSource() {
        if (this.noSource) {
            return "";
        }
        try {
            return this.getProgramInfoString(4452);
        }
        catch (CLException.CLInvalidValueException ingore) {
            return "";
        }
    }

    public Map<CLDevice, byte[]> getBinaries() {
        if (!this.isExecutable()) {
            return Collections.emptyMap();
        }
        CLDevice[] devices = this.getCLDevices();
        PointerBuffer sizes = PointerBuffer.allocateDirect((int)devices.length);
        int ret = this.binding.clGetProgramInfo(this.ID, 4453, sizes.capacity() * sizes.elementSize(), sizes.getBuffer(), null);
        if (ret != 0) {
            throw CLException.newException(ret, "on clGetProgramInfo(CL_PROGRAM_BINARY_SIZES) of " + this);
        }
        int binariesSize = 0;
        while (sizes.remaining() != 0) {
            int size = (int)sizes.get();
            binariesSize += size;
        }
        ByteBuffer binaries = Buffers.newDirectByteBuffer((int)binariesSize);
        long address = InternalBufferUtil.getDirectBufferAddress(binaries);
        PointerBuffer addresses = PointerBuffer.allocateDirect((int)sizes.capacity());
        sizes.rewind();
        while (sizes.remaining() != 0) {
            addresses.put(address);
            address += sizes.get();
        }
        addresses.rewind();
        ret = this.binding.clGetProgramInfo(this.ID, 4454, addresses.capacity() * addresses.elementSize(), addresses.getBuffer(), null);
        if (ret != 0) {
            throw CLException.newException(ret, "on clGetProgramInfo(CL_PROGRAM_BINARIES) of " + this);
        }
        LinkedHashMap<CLDevice, byte[]> map = new LinkedHashMap<CLDevice, byte[]>();
        sizes.rewind();
        for (int i = 0; i < devices.length; ++i) {
            byte[] bytes = new byte[(int)sizes.get()];
            binaries.get(bytes);
            map.put(devices[i], bytes);
        }
        return map;
    }

    public static String optionsOf(String ... options) {
        StringBuilder sb = new StringBuilder(options.length * 24);
        for (int i = 0; i < options.length; ++i) {
            sb.append(options[i]);
            if (i == options.length - 1) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    public static String define(String name) {
        return "-D " + name;
    }

    public static String define(String name, Object value) {
        return "-D " + name + "=" + value;
    }

    @Override
    public String toString() {
        return "CLProgram [id: " + this.ID + " status: " + this.getBuildStatus() + "]";
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CLProgram other = (CLProgram)obj;
        if (this.ID != other.ID) {
            return false;
        }
        return this.context.equals(other.context);
    }

    public int hashCode() {
        int hash = 7;
        hash = 37 * hash + (this.context != null ? this.context.hashCode() : 0);
        hash = 37 * hash + (int)(this.ID ^ this.ID >>> 32);
        return hash;
    }

    public static interface CompilerOptions {
        public static final String SINGLE_PRECISION_CONSTANTS = "-cl-single-precision-constant";
        public static final String DENORMS_ARE_ZERO = "-cl-denorms-are-zero";
        public static final String DISABLE_OPT = "-cl-opt-disable";
        public static final String STRICT_ALIASING = "-cl-strict-aliasing";
        public static final String ENABLE_MAD = "-cl-mad-enable";
        public static final String NO_SIGNED_ZEROS = "-cl-no-signed-zeros";
        public static final String UNSAFE_MATH = "-cl-unsafe-math-optimizations";
        public static final String FINITE_MATH_ONLY = "-cl-finite-math-only";
        public static final String FAST_RELAXED_MATH = "-cl-fast-relaxed-math";
        public static final String DISABLE_WARNINGS = "-w";
        public static final String WARNINGS_ARE_ERRORS = "-Werror";
    }

    public static enum Status {
        BUILD_SUCCESS(0),
        BUILD_NONE(-1),
        BUILD_IN_PROGRESS(-3),
        BUILD_ERROR(-2);

        public final int STATUS;

        private Status(int status) {
            this.STATUS = status;
        }

        public static Status valueOf(int clBuildStatus) {
            switch (clBuildStatus) {
                case 0: {
                    return BUILD_SUCCESS;
                }
                case -1: {
                    return BUILD_NONE;
                }
                case -3: {
                    return BUILD_IN_PROGRESS;
                }
                case -2: {
                    return BUILD_ERROR;
                }
            }
            return null;
        }
    }
}

