/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl;

import com.jogamp.common.GlueGenVersion;
import com.jogamp.common.os.Platform;
import com.jogamp.common.util.JogampVersion;
import com.jogamp.common.util.VersionUtil;
import com.jogamp.opencl.CLDevice;
import com.jogamp.opencl.CLPlatform;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Manifest;

public class JoclVersion
extends JogampVersion {
    protected static volatile JoclVersion jogampCommonVersionInfo;
    private volatile int maxKeyStrlen = -1;

    protected JoclVersion(String packageName, Manifest mf) {
        super(packageName, mf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JoclVersion getInstance() {
        if (null != jogampCommonVersionInfo) return jogampCommonVersionInfo;
        Class<JoclVersion> clazz = JoclVersion.class;
        synchronized (JoclVersion.class) {
            if (null != jogampCommonVersionInfo) return jogampCommonVersionInfo;
            String packageName = "com.jogamp.opencl";
            Manifest mf = VersionUtil.getManifest((ClassLoader)JoclVersion.class.getClassLoader(), (String)"com.jogamp.opencl");
            jogampCommonVersionInfo = new JoclVersion("com.jogamp.opencl", mf);
            // ** MonitorExit[var0] (shouldn't be in output)
            return jogampCommonVersionInfo;
        }
    }

    public StringBuilder getAllVersions(StringBuilder sb) {
        if (null == sb) {
            sb = new StringBuilder();
        }
        try {
            VersionUtil.getPlatformInfo((StringBuilder)sb);
            sb.append(Platform.getNewline());
            GlueGenVersion.getInstance().toString(sb);
            sb.append(Platform.getNewline());
            this.toString(sb);
            sb.append(Platform.getNewline());
        }
        catch (Exception e) {
            sb.append(e.getMessage());
            e.printStackTrace();
        }
        return sb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringBuilder getOpenCLTextInfo(StringBuilder sb) {
        CLDevice[] devices;
        CLPlatform[] platforms;
        if (null == sb) {
            sb = new StringBuilder();
        }
        try {
            platforms = CLPlatform.listCLPlatforms();
        }
        catch (Throwable t) {
            Throwable pre = null;
            for (Throwable next = t; null != next; next = next.getCause()) {
                pre = next;
            }
            Throwable cause = pre;
            System.err.println("CLPlatform.listCLPlatforms() failed, exception: " + cause.getMessage());
            t.printStackTrace();
            sb.append("CLPlatform.listCLPlatforms() failed, exception: " + cause.getMessage());
            StringWriter stackTrace = new StringWriter();
            cause.printStackTrace(new PrintWriter(stackTrace));
            sb.append(stackTrace.toString());
            return sb;
        }
        ArrayList<Map<String, String>> platProps = new ArrayList<Map<String, String>>();
        if (0 > this.maxKeyStrlen) {
            JoclVersion cause = this;
            synchronized (cause) {
                if (0 > this.maxKeyStrlen) {
                    for (CLPlatform p : platforms) {
                        platProps.add(p.getProperties());
                        for (CLDevice d : devices = p.listCLDevices()) {
                            Map<String, String> props = d.getProperties();
                            Set<Map.Entry<String, String>> entries = props.entrySet();
                            for (Map.Entry<String, String> e : entries) {
                                this.maxKeyStrlen = Math.max(this.maxKeyStrlen, e.getKey().length());
                            }
                        }
                    }
                }
            }
        }
        sb.append(String.format("PP:DD:EE  -  Platform (PP), Device (DD), Entry (EE)%n", new Object[0]));
        int pI = 0;
        for (CLPlatform p : platforms) {
            ++pI;
            platProps.add(p.getProperties());
            devices = p.listCLDevices();
            int dI = 0;
            for (CLDevice d : devices) {
                ++dI;
                Map<String, String> props = d.getProperties();
                Set<Map.Entry<String, String>> entries = props.entrySet();
                int eI = 0;
                for (Map.Entry<String, String> e : entries) {
                    sb.append(String.format("%02d:%02d:%02d %" + this.maxKeyStrlen + "s: %s%n", pI, dI, ++eI, e.getKey(), e.getValue()));
                }
            }
        }
        return sb;
    }

    public StringBuilder getOpenCLHtmlInfo(StringBuilder sb) {
        CLPlatform[] platforms;
        if (null == sb) {
            sb = new StringBuilder();
        }
        try {
            platforms = CLPlatform.listCLPlatforms();
        }
        catch (Throwable t) {
            Throwable pre = null;
            for (Throwable next = t; null != next; next = next.getCause()) {
                pre = next;
            }
            Throwable cause = pre;
            System.err.println("CLPlatform.listCLPlatforms() failed, exception: " + cause.getMessage());
            t.printStackTrace();
            sb.append("<pre>CLPlatform.listCLPlatforms() failed, exception: " + cause.getMessage());
            StringWriter stackTrace = new StringWriter();
            cause.printStackTrace(new PrintWriter(stackTrace));
            sb.append(stackTrace.toString()).append("</pre>");
            return sb;
        }
        sb.append("<table border=\"1\">");
        ArrayList<Map<String, String>> platProps = new ArrayList<Map<String, String>>();
        ArrayList<Integer> spans = new ArrayList<Integer>();
        for (CLPlatform p : platforms) {
            platProps.add(p.getProperties());
            spans.add(p.listCLDevices().length);
        }
        JoclVersion.fillHtmlTable(platProps, spans, sb);
        ArrayList<Map<String, String>> devProps = new ArrayList<Map<String, String>>();
        for (CLPlatform p : platforms) {
            CLDevice[] devices;
            for (CLDevice d : devices = p.listCLDevices()) {
                devProps.add(d.getProperties());
            }
        }
        JoclVersion.fillHtmlTable(devProps, sb);
        sb.append("</table>");
        return sb;
    }

    private static void fillHtmlTable(List<Map<String, String>> properties, StringBuilder sb) {
        ArrayList<Integer> spans = new ArrayList<Integer>(properties.size());
        for (int i = 0; i < properties.size(); ++i) {
            spans.add(1);
        }
        JoclVersion.fillHtmlTable(properties, spans, sb);
    }

    private static void fillHtmlTable(List<Map<String, String>> properties, List<Integer> spans, StringBuilder sb) {
        boolean header = true;
        for (String key : properties.get(0).keySet()) {
            sb.append("<tr>");
            JoclVersion.htmlCell(sb, key);
            int i = 0;
            for (Map<String, String> map : properties) {
                JoclVersion.htmlCell(sb, spans.get(i), map.get(key), header);
                ++i;
            }
            sb.append("</tr>");
            header = false;
        }
    }

    private static void htmlCell(StringBuilder sb, String value) {
        sb.append("<td>").append(value).append("</td>");
    }

    private static void htmlCell(StringBuilder sb, int span, String value, boolean header) {
        if (header) {
            sb.append("<th colspan=\"").append(span).append("\">").append(value).append("</th>");
        } else {
            sb.append("<td colspan=\"").append(span).append("\">").append(value).append("</td>");
        }
    }

    public static void main(String[] args) {
        System.err.println(VersionUtil.getPlatformInfo());
        System.err.println(GlueGenVersion.getInstance());
        JoclVersion v = JoclVersion.getInstance();
        System.err.println(v.toString());
        if (CLPlatform.isAvailable()) {
            System.err.println(v.getOpenCLTextInfo(null).toString());
        } else {
            System.err.println("JOCL/OpenCL not available");
        }
    }
}

