/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl.gl;

import com.jogamp.opencl.CLBuffer;
import com.jogamp.opencl.CLContext;
import com.jogamp.opencl.CLException;
import com.jogamp.opencl.CLMemory;
import com.jogamp.opencl.gl.CLGLContext;
import com.jogamp.opencl.gl.CLGLObject;
import com.jogamp.opencl.llb.CL;
import com.jogamp.opengl.GLContext;
import java.nio.Buffer;

public final class CLGLBuffer<B extends Buffer>
extends CLBuffer<B>
implements CLGLObject {
    public final int GLID;

    private CLGLBuffer(CLContext context, B directBuffer, long id, int glObject, long size, int flags) {
        super(context, directBuffer, size, id, flags);
        this.GLID = glObject;
    }

    static <B extends Buffer> CLGLBuffer<B> create(CLContext context, B directBuffer, long size, int flags, int glBuffer) {
        CLGLBuffer.checkBuffer(directBuffer, flags);
        CL cl = CLGLBuffer.getCL(context);
        int[] result = new int[1];
        long id = cl.clCreateFromGLBuffer(context.ID, flags, glBuffer, result, 0);
        CLException.checkForError(result[0], "can not create CLGLObject from glBuffer #" + glBuffer);
        return new CLGLBuffer<B>(context, directBuffer, id, glBuffer, size, flags);
    }

    static <B extends Buffer> void checkBuffer(B directBuffer, int flags) throws IllegalArgumentException {
        if (directBuffer != null && !directBuffer.isDirect()) {
            throw new IllegalArgumentException("buffer is not a direct buffer");
        }
        if (CLGLBuffer.isHostPointerFlag(flags)) {
            throw new IllegalArgumentException("CL_MEM_COPY_HOST_PTR or CL_MEM_USE_HOST_PTR can not be used with OpenGL Buffers.");
        }
    }

    public void updateSize() {
        this.size = CLGLBuffer.getSizeImpl(this.context, this.ID);
        this.initCLCapacity();
    }

    @Override
    public int getGLObjectID() {
        return this.GLID;
    }

    @Override
    public CLMemory.GLObjectType getGLObjectType() {
        return CLMemory.GLObjectType.GL_OBJECT_BUFFER;
    }

    @Override
    public CLGLContext getContext() {
        return (CLGLContext)super.getContext();
    }

    @Override
    public GLContext getGLContext() {
        return this.getContext().getGLContext();
    }

    @Override
    public <T extends Buffer> CLGLBuffer<T> cloneWith(T directBuffer) {
        return new CLGLBuffer<T>(this.context, directBuffer, this.ID, this.GLID, this.size, this.FLAGS);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " [id: " + this.ID + " glID: " + this.GLID + "]";
    }
}

