/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl.util;

import com.jogamp.opencl.CLCommandQueue;
import com.jogamp.opencl.CLDevice;
import com.jogamp.opencl.util.Filter;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;

public class CLDeviceFilters {
    public static Filter<CLDevice> type(final CLDevice.Type ... types) {
        return new Filter<CLDevice>(){
            private final EnumSet<CLDevice.Type> set;
            {
                this.set = EnumSet.copyOf(Arrays.asList(types));
            }

            @Override
            public boolean accept(CLDevice item) {
                if (this.set.contains((Object)CLDevice.Type.ALL)) {
                    return true;
                }
                return this.set.contains((Object)item.getType());
            }
        };
    }

    public static Filter<CLDevice> byteOrder(final ByteOrder order) {
        return new Filter<CLDevice>(){

            @Override
            public boolean accept(CLDevice item) {
                return item.getByteOrder().equals(order);
            }
        };
    }

    public static Filter<CLDevice> glSharing() {
        return new Filter<CLDevice>(){

            @Override
            public boolean accept(CLDevice item) {
                return item.isGLMemorySharingSupported();
            }
        };
    }

    public static Filter<CLDevice> extension(final String ... extensions) {
        return new Filter<CLDevice>(){
            private final List<String> extensionList;
            {
                this.extensionList = Arrays.asList(extensions);
            }

            @Override
            public boolean accept(CLDevice item) {
                return item.getExtensions().containsAll(this.extensionList);
            }
        };
    }

    public static Filter<CLDevice> queueMode(final CLCommandQueue.Mode ... modes) {
        return new Filter<CLDevice>(){
            private final List<CLCommandQueue.Mode> modeList;
            {
                this.modeList = Arrays.asList(modes);
            }

            @Override
            public boolean accept(CLDevice item) {
                return item.getQueueProperties().containsAll(this.modeList);
            }
        };
    }
}

