/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl.util;

import com.jogamp.opencl.CLContext;
import com.jogamp.opencl.CLDevice;
import com.jogamp.opencl.CLPlatform;
import com.jogamp.opencl.CLResource;
import com.jogamp.opencl.util.CLDeviceFilters;
import com.jogamp.opencl.util.Filter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CLMultiContext
implements CLResource {
    private final List<CLContext> contexts = new ArrayList<CLContext>();
    private boolean released;

    private CLMultiContext() {
    }

    public static CLMultiContext create(CLPlatform ... platforms) {
        return CLMultiContext.create(platforms, CLDevice.Type.ALL);
    }

    public static CLMultiContext create(CLPlatform[] platforms, CLDevice.Type ... types) {
        return CLMultiContext.create(platforms, CLDeviceFilters.type(types));
    }

    public static CLMultiContext create(CLPlatform[] platforms, Filter<CLDevice> ... filters) {
        if (platforms == null) {
            throw new NullPointerException("platform list was null");
        }
        if (platforms.length == 0) {
            throw new IllegalArgumentException("platform list was empty");
        }
        ArrayList<CLDevice> devices = new ArrayList<CLDevice>();
        for (CLPlatform platform : platforms) {
            devices.addAll(Arrays.asList(platform.listCLDevices(filters)));
        }
        return CLMultiContext.create(devices);
    }

    public static CLMultiContext create(Collection<CLDevice> devices) {
        if (devices.isEmpty()) {
            throw new IllegalArgumentException("device list was empty");
        }
        Map<CLPlatform, List<CLDevice>> platformDevicesMap = CLMultiContext.filterPlatformConflicts(devices);
        CLMultiContext mc = new CLMultiContext();
        for (Map.Entry<CLPlatform, List<CLDevice>> entry : platformDevicesMap.entrySet()) {
            List<CLDevice> list = entry.getValue();
            for (CLDevice device : list) {
                CLContext context = CLContext.create(device);
                mc.contexts.add(context);
            }
        }
        return mc;
    }

    public static CLMultiContext wrap(CLContext ... contexts) {
        CLMultiContext mc = new CLMultiContext();
        mc.contexts.addAll(Arrays.asList(contexts));
        return mc;
    }

    private static Map<CLPlatform, List<CLDevice>> filterPlatformConflicts(Collection<CLDevice> devices) {
        HashMap<CLPlatform, List<CLDevice>> filtered = new HashMap<CLPlatform, List<CLDevice>>();
        HashMap<String, CLPlatform> used = new HashMap<String, CLPlatform>();
        for (CLDevice device : devices) {
            String name = device.getName();
            CLPlatform platform = device.getPlatform();
            CLPlatform usedPlatform = (CLPlatform)used.get(name);
            if (usedPlatform != null && !platform.equals(usedPlatform)) continue;
            if (!filtered.containsKey(platform)) {
                filtered.put(platform, new ArrayList());
            }
            ((List)filtered.get(platform)).add(device);
            used.put(name, platform);
        }
        return filtered;
    }

    @Override
    public void release() {
        if (this.released) {
            throw new RuntimeException(this.getClass().getSimpleName() + " already released");
        }
        this.released = true;
        for (CLContext context : this.contexts) {
            context.release();
        }
        this.contexts.clear();
    }

    public List<CLContext> getContexts() {
        return Collections.unmodifiableList(this.contexts);
    }

    public List<CLDevice> getDevices() {
        ArrayList<CLDevice> devices = new ArrayList<CLDevice>();
        for (CLContext context : this.contexts) {
            devices.addAll(Arrays.asList(context.getDevices()));
        }
        return devices;
    }

    @Override
    public boolean isReleased() {
        return this.released;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [" + this.contexts.size() + " contexts, " + this.getDevices().size() + " devices]";
    }
}

