/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.nativewindow.awt;

import com.jogamp.common.util.RunnableTask;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import jogamp.nativewindow.jawt.JAWTUtil;

public class AppContextInfo {
    private static final boolean DEBUG;
    private static final Method getAppContextMethod;
    private static final Object mainThreadAppContextLock;
    private volatile WeakReference<Object> mainThreadAppContextWR = null;
    private volatile WeakReference<ThreadGroup> mainThreadGroupWR = null;

    public AppContextInfo(String string) {
        this.update(string);
    }

    public final boolean isValid() {
        return null != this.getCachedThreadGroup();
    }

    public final ThreadGroup getCachedThreadGroup() {
        WeakReference<ThreadGroup> weakReference = this.mainThreadGroupWR;
        return null != weakReference ? (ThreadGroup)weakReference.get() : null;
    }

    public RunnableTask invokeOnAppContextThread(boolean bl, Runnable runnable, String string) {
        RunnableTask runnableTask;
        if (this.update("invoke")) {
            runnableTask = RunnableTask.invokeOnCurrentThread((Runnable)runnable);
            if (DEBUG) {
                System.err.println("Bug 1004: Invoke.0 on current AppContext: " + runnableTask);
            }
        } else {
            ThreadGroup threadGroup = this.getCachedThreadGroup();
            String string2 = string + (null != threadGroup ? "-OnAppContextTG" : "-OnSystemTG");
            runnableTask = RunnableTask.invokeOnNewThread((ThreadGroup)threadGroup, (String)string2, (boolean)bl, (Runnable)runnable);
            if (DEBUG) {
                int n = null != threadGroup ? threadGroup.hashCode() : 0;
                System.err.println("Bug 1004: Invoke.1 on new AppContext: " + runnableTask + ", tg " + threadGroup + " " + AppContextInfo.toHexString(n));
            }
        }
        return runnableTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean update(String string) {
        if (null != getAppContextMethod) {
            Object object;
            Object object2 = AppContextInfo.fetchAppContext();
            boolean bl = null != object2;
            Thread thread = Thread.currentThread();
            ThreadGroup threadGroup = thread.getThreadGroup();
            WeakReference<Object> weakReference = this.mainThreadAppContextWR;
            Object object3 = object = null != weakReference ? (Object)weakReference.get() : null;
            if (bl) {
                if (null == object || object != object2) {
                    int n;
                    int n2 = null != object ? object.hashCode() : 0;
                    Object object4 = mainThreadAppContextLock;
                    synchronized (object4) {
                        this.mainThreadGroupWR = new WeakReference<ThreadGroup>(threadGroup);
                        this.mainThreadAppContextWR = new WeakReference<Object>(object2);
                        n = object2.hashCode();
                    }
                    if (DEBUG) {
                        System.err.println("Bug 1004[TGMapped " + bl + "]: Init AppContext @ " + string + " on thread " + thread.getName() + " " + AppContextInfo.toHexString(thread.hashCode()) + ": tg " + threadGroup.getName() + " " + AppContextInfo.toHexString(threadGroup.hashCode()) + " -> appCtx [ main " + object + " " + AppContextInfo.toHexString(n2) + " -> this " + object2 + " " + AppContextInfo.toHexString(n) + " ] ");
                    }
                } else if (DEBUG) {
                    int n = object.hashCode();
                    int n3 = object2.hashCode();
                    System.err.println("Bug 1004[TGMapped " + bl + "]: OK AppContext @ " + string + " on thread " + thread.getName() + " " + AppContextInfo.toHexString(thread.hashCode()) + ": tg " + threadGroup.getName() + " " + AppContextInfo.toHexString(threadGroup.hashCode()) + "  : appCtx [ this " + object2 + " " + AppContextInfo.toHexString(n3) + "  , main " + object + " " + AppContextInfo.toHexString(n) + " ] ");
                }
                return true;
            }
            if (DEBUG) {
                int n = null != object ? object.hashCode() : 0;
                int n4 = null != object2 ? object2.hashCode() : 0;
                System.err.println("Bug 1004[TGMapped " + bl + "]: No AppContext @ " + string + " on thread " + thread.getName() + " " + AppContextInfo.toHexString(thread.hashCode()) + ": tg " + threadGroup.getName() + " " + AppContextInfo.toHexString(threadGroup.hashCode()) + " -> appCtx [ this " + object2 + " " + AppContextInfo.toHexString(n4) + " -> main " + object + " " + AppContextInfo.toHexString(n) + " ] ");
            }
        }
        return false;
    }

    private static Object fetchAppContext() {
        try {
            return getAppContextMethod.invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            System.err.println("Bug 1004: Caught: " + exception.getMessage());
            exception.printStackTrace();
            return null;
        }
    }

    private static String toHexString(int n) {
        return "0x" + Integer.toHexString(n);
    }

    static {
        mainThreadAppContextLock = new Object();
        DEBUG = JAWTUtil.DEBUG;
        final Method[] methodArray = new Method[]{null};
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    Class<?> clazz = Class.forName("sun.awt.AppContext");
                    methodArray[0] = clazz.getMethod("getAppContext", new Class[0]);
                }
                catch (Throwable throwable) {
                    System.err.println("Bug 1004: Caught @ static: " + throwable.getMessage());
                    throwable.printStackTrace();
                }
                return null;
            }
        });
        getAppContextMethod = methodArray[0];
    }
}

